/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldDocSortedHitQueue;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitQueue;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.NamedThreadFactory;
import org.apache.lucene.util.ThreadInterruptedException;

@Deprecated
public class ParallelMultiSearcher
extends MultiSearcher {
    private final ExecutorService executor;
    private final Searchable[] searchables;
    private final int[] starts;

    public ParallelMultiSearcher(Searchable ... searchableArray) throws IOException {
        this(Executors.newCachedThreadPool(new NamedThreadFactory(ParallelMultiSearcher.class.getSimpleName())), searchableArray);
    }

    public ParallelMultiSearcher(ExecutorService executorService, Searchable ... searchableArray) throws IOException {
        super(searchableArray);
        this.searchables = searchableArray;
        this.starts = this.getStarts();
        this.executor = executorService;
    }

    @Override
    public int docFreq(final Term term) throws IOException {
        int n;
        ExecutionHelper<Integer> executionHelper = new ExecutionHelper<Integer>(this.executor);
        for (n = 0; n < this.searchables.length; ++n) {
            final Searchable searchable = this.searchables[n];
            executionHelper.submit(new Callable<Integer>(){

                @Override
                public Integer call() throws IOException {
                    return searchable.docFreq(term);
                }
            });
        }
        n = 0;
        for (Integer n2 : executionHelper) {
            n += n2.intValue();
        }
        return n;
    }

    @Override
    public TopDocs search(Weight weight, Filter filter, int n) throws IOException {
        int n2;
        HitQueue hitQueue = new HitQueue(n, false);
        ReentrantLock reentrantLock = new ReentrantLock();
        ExecutionHelper<TopDocs> executionHelper = new ExecutionHelper<TopDocs>(this.executor);
        for (n2 = 0; n2 < this.searchables.length; ++n2) {
            executionHelper.submit(new MultiSearcher.MultiSearcherCallableNoSort(reentrantLock, this.searchables[n2], weight, filter, n, hitQueue, n2, this.starts));
        }
        n2 = 0;
        float f = Float.NEGATIVE_INFINITY;
        for (TopDocs topDocs : executionHelper) {
            n2 += topDocs.totalHits;
            f = Math.max(f, topDocs.getMaxScore());
        }
        ScoreDoc[] scoreDocArray = new ScoreDoc[hitQueue.size()];
        for (int i = hitQueue.size() - 1; i >= 0; --i) {
            scoreDocArray[i] = (ScoreDoc)hitQueue.pop();
        }
        return new TopDocs(n2, scoreDocArray, f);
    }

    @Override
    public TopFieldDocs search(Weight weight, Filter filter, int n, Sort sort) throws IOException {
        int n2;
        if (sort == null) {
            throw new NullPointerException();
        }
        FieldDocSortedHitQueue fieldDocSortedHitQueue = new FieldDocSortedHitQueue(n);
        ReentrantLock reentrantLock = new ReentrantLock();
        ExecutionHelper<TopFieldDocs> executionHelper = new ExecutionHelper<TopFieldDocs>(this.executor);
        for (n2 = 0; n2 < this.searchables.length; ++n2) {
            executionHelper.submit(new MultiSearcher.MultiSearcherCallableWithSort(reentrantLock, this.searchables[n2], weight, filter, n, fieldDocSortedHitQueue, sort, n2, this.starts));
        }
        n2 = 0;
        float f = Float.NEGATIVE_INFINITY;
        for (TopFieldDocs topFieldDocs : executionHelper) {
            n2 += topFieldDocs.totalHits;
            f = Math.max(f, topFieldDocs.getMaxScore());
        }
        ScoreDoc[] scoreDocArray = new ScoreDoc[fieldDocSortedHitQueue.size()];
        for (int i = fieldDocSortedHitQueue.size() - 1; i >= 0; --i) {
            scoreDocArray[i] = (ScoreDoc)fieldDocSortedHitQueue.pop();
        }
        return new TopFieldDocs(n2, scoreDocArray, fieldDocSortedHitQueue.getFields(), f);
    }

    @Override
    public void search(Weight weight, Filter filter, final Collector collector) throws IOException {
        for (int i = 0; i < this.searchables.length; ++i) {
            final int n = this.starts[i];
            Collector collector2 = new Collector(){

                @Override
                public void setScorer(Scorer scorer) throws IOException {
                    collector.setScorer(scorer);
                }

                @Override
                public void collect(int n2) throws IOException {
                    collector.collect(n2);
                }

                @Override
                public void setNextReader(IndexReader indexReader, int n2) throws IOException {
                    collector.setNextReader(indexReader, n + n2);
                }

                @Override
                public boolean acceptsDocsOutOfOrder() {
                    return collector.acceptsDocsOutOfOrder();
                }
            };
            this.searchables[i].search(weight, filter, collector2);
        }
    }

    @Override
    public void close() throws IOException {
        this.executor.shutdown();
        super.close();
    }

    HashMap<Term, Integer> createDocFrequencyMap(Set<Term> set) throws IOException {
        int n;
        Term[] termArray = set.toArray(new Term[set.size()]);
        int[] nArray = new int[set.size()];
        ExecutionHelper<int[]> executionHelper = new ExecutionHelper<int[]>(this.executor);
        Searchable[] searchableArray = this.searchables;
        int n2 = searchableArray.length;
        for (n = 0; n < n2; ++n) {
            Searchable searchable = searchableArray[n];
            executionHelper.submit(new DocumentFrequencyCallable(searchable, termArray));
        }
        int n3 = nArray.length;
        for (int[] nArray2 : executionHelper) {
            for (int i = 0; i < n3; ++i) {
                int n4 = i;
                nArray[n4] = nArray[n4] + nArray2[i];
            }
        }
        HashMap hashMap = new HashMap();
        for (n = 0; n < termArray.length; ++n) {
            hashMap.put(termArray[n], nArray[n]);
        }
        return hashMap;
    }

    private static final class ExecutionHelper<T>
    implements Iterator<T>,
    Iterable<T> {
        private final CompletionService<T> service;
        private int numTasks;

        ExecutionHelper(Executor executor) {
            this.service = new ExecutorCompletionService<T>(executor);
        }

        @Override
        public boolean hasNext() {
            return this.numTasks > 0;
        }

        public void submit(Callable<T> callable) {
            this.service.submit(callable);
            ++this.numTasks;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                T t = this.service.take().get();
                return t;
            }
            catch (InterruptedException interruptedException) {
                throw new ThreadInterruptedException(interruptedException);
            }
            catch (ExecutionException executionException) {
                throw new RuntimeException(executionException);
            }
            finally {
                --this.numTasks;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }
    }

    private static final class DocumentFrequencyCallable
    implements Callable<int[]> {
        private final Searchable searchable;
        private final Term[] terms;

        public DocumentFrequencyCallable(Searchable searchable, Term[] termArray) {
            this.searchable = searchable;
            this.terms = termArray;
        }

        @Override
        public int[] call() throws Exception {
            return this.searchable.docFreqs(this.terms);
        }
    }
}

