/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredTermEnum;

public class PrefixTermEnum
extends FilteredTermEnum {
    private final Term prefix;
    private boolean endEnum = false;

    public PrefixTermEnum(IndexReader indexReader, Term term) throws IOException {
        this.prefix = term;
        this.setEnum(indexReader.terms(new Term(term.field(), term.text())));
    }

    @Override
    public float difference() {
        return 1.0f;
    }

    @Override
    protected boolean endEnum() {
        return this.endEnum;
    }

    protected Term getPrefixTerm() {
        return this.prefix;
    }

    @Override
    protected boolean termCompare(Term term) {
        if (term.field() == this.prefix.field() && term.text().startsWith(this.prefix.text())) {
            return true;
        }
        this.endEnum = true;
        return false;
    }
}

