/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.DocIdSet;

public class SpanFilterResult {
    private DocIdSet docIdSet;
    private List<PositionInfo> positions;

    public SpanFilterResult(DocIdSet docIdSet, List<PositionInfo> list) {
        this.docIdSet = docIdSet;
        this.positions = list;
    }

    public List<PositionInfo> getPositions() {
        return this.positions;
    }

    public DocIdSet getDocIdSet() {
        return this.docIdSet;
    }

    public static class StartEnd {
        private int start;
        private int end;

        public StartEnd(int n, int n2) {
            this.start = n;
            this.end = n2;
        }

        public int getEnd() {
            return this.end;
        }

        public int getStart() {
            return this.start;
        }
    }

    public static class PositionInfo {
        private int doc;
        private List<StartEnd> positions;

        public PositionInfo(int n) {
            this.doc = n;
            this.positions = new ArrayList<StartEnd>();
        }

        public void addPosition(int n, int n2) {
            this.positions.add(new StartEnd(n, n2));
        }

        public int getDoc() {
            return this.doc;
        }

        public List<StartEnd> getPositions() {
            return this.positions;
        }
    }
}

