/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.TermScorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ReaderUtil;
import org.apache.lucene.util.ToStringUtils;

public class TermQuery
extends Query {
    private Term term;

    public TermQuery(Term term) {
        this.term = term;
    }

    public Term getTerm() {
        return this.term;
    }

    @Override
    public Weight createWeight(Searcher searcher) throws IOException {
        return new TermWeight(searcher);
    }

    @Override
    public void extractTerms(Set<Term> set) {
        set.add(this.getTerm());
    }

    @Override
    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.term.field().equals(string)) {
            stringBuilder.append(this.term.field());
            stringBuilder.append(":");
        }
        stringBuilder.append(this.term.text());
        stringBuilder.append(ToStringUtils.boost(this.getBoost()));
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof TermQuery)) {
            return false;
        }
        TermQuery termQuery = (TermQuery)object;
        return this.getBoost() == termQuery.getBoost() && this.term.equals(termQuery.term);
    }

    @Override
    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) ^ this.term.hashCode();
    }

    private class TermWeight
    extends Weight {
        private final Similarity similarity;
        private float value;
        private float idf;
        private float queryNorm;
        private float queryWeight;
        private Explanation.IDFExplanation idfExp;
        private final Set<Integer> hash;

        public TermWeight(Searcher searcher) throws IOException {
            this.similarity = TermQuery.this.getSimilarity(searcher);
            if (searcher instanceof IndexSearcher) {
                this.hash = new HashSet<Integer>();
                IndexReader indexReader = ((IndexSearcher)searcher).getIndexReader();
                final int[] nArray = new int[1];
                new ReaderUtil.Gather(indexReader){

                    @Override
                    protected void add(int n, IndexReader indexReader) throws IOException {
                        int n2 = indexReader.docFreq(TermQuery.this.term);
                        nArray[0] = nArray[0] + n2;
                        if (n2 > 0) {
                            TermWeight.this.hash.add(indexReader.hashCode());
                        }
                    }
                }.run();
                this.idfExp = this.similarity.idfExplain(TermQuery.this.term, searcher, nArray[0]);
            } else {
                this.idfExp = this.similarity.idfExplain(TermQuery.this.term, searcher);
                this.hash = null;
            }
            this.idf = this.idfExp.getIdf();
        }

        public String toString() {
            return "weight(" + TermQuery.this + ")";
        }

        @Override
        public Query getQuery() {
            return TermQuery.this;
        }

        @Override
        public float getValue() {
            return this.value;
        }

        @Override
        public float sumOfSquaredWeights() {
            this.queryWeight = this.idf * TermQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        @Override
        public void normalize(float f) {
            this.queryNorm = f;
            this.queryWeight *= f;
            this.value = this.queryWeight * this.idf;
        }

        @Override
        public Scorer scorer(IndexReader indexReader, boolean bl, boolean bl2) throws IOException {
            if (this.hash != null && indexReader.getSequentialSubReaders() == null && !this.hash.contains(indexReader.hashCode())) {
                return null;
            }
            TermDocs termDocs = indexReader.termDocs(TermQuery.this.term);
            if (termDocs == null) {
                return null;
            }
            return new TermScorer(this, termDocs, this.similarity, indexReader.norms(TermQuery.this.term.field()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Explanation explain(IndexReader indexReader, int n) throws IOException {
            ComplexExplanation complexExplanation = new ComplexExplanation();
            complexExplanation.setDescription("weight(" + this.getQuery() + " in " + n + "), product of:");
            Explanation explanation = new Explanation(this.idf, this.idfExp.explain());
            Explanation explanation2 = new Explanation();
            explanation2.setDescription("queryWeight(" + this.getQuery() + "), product of:");
            Explanation explanation3 = new Explanation(TermQuery.this.getBoost(), "boost");
            if (TermQuery.this.getBoost() != 1.0f) {
                explanation2.addDetail(explanation3);
            }
            explanation2.addDetail(explanation);
            Explanation explanation4 = new Explanation(this.queryNorm, "queryNorm");
            explanation2.addDetail(explanation4);
            explanation2.setValue(explanation3.getValue() * explanation.getValue() * explanation4.getValue());
            complexExplanation.addDetail(explanation2);
            String string = TermQuery.this.term.field();
            ComplexExplanation complexExplanation2 = new ComplexExplanation();
            complexExplanation2.setDescription("fieldWeight(" + TermQuery.this.term + " in " + n + "), product of:");
            Explanation explanation5 = new Explanation();
            int n2 = 0;
            TermDocs termDocs = indexReader.termDocs(TermQuery.this.term);
            if (termDocs != null) {
                try {
                    if (termDocs.skipTo(n) && termDocs.doc() == n) {
                        n2 = termDocs.freq();
                    }
                }
                finally {
                    termDocs.close();
                }
                explanation5.setValue(this.similarity.tf(n2));
                explanation5.setDescription("tf(termFreq(" + TermQuery.this.term + ")=" + n2 + ")");
            } else {
                explanation5.setValue(0.0f);
                explanation5.setDescription("no matching term");
            }
            complexExplanation2.addDetail(explanation5);
            complexExplanation2.addDetail(explanation);
            Explanation explanation6 = new Explanation();
            byte[] byArray = indexReader.norms(string);
            float f = byArray != null ? this.similarity.decodeNormValue(byArray[n]) : 1.0f;
            explanation6.setValue(f);
            explanation6.setDescription("fieldNorm(field=" + string + ", doc=" + n + ")");
            complexExplanation2.addDetail(explanation6);
            complexExplanation2.setMatch(explanation5.isMatch());
            complexExplanation2.setValue(explanation5.getValue() * explanation.getValue() * explanation6.getValue());
            complexExplanation.addDetail(complexExplanation2);
            complexExplanation.setMatch(complexExplanation2.getMatch());
            complexExplanation.setValue(explanation2.getValue() * complexExplanation2.getValue());
            if (explanation2.getValue() == 1.0f) {
                return complexExplanation2;
            }
            return complexExplanation;
        }
    }
}

