/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.function;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.function.DocValues;
import org.apache.lucene.search.function.FieldCacheSource;

public class ShortFieldSource
extends FieldCacheSource {
    private FieldCache.ShortParser parser;

    public ShortFieldSource(String string) {
        this(string, null);
    }

    public ShortFieldSource(String string, FieldCache.ShortParser shortParser) {
        super(string);
        this.parser = shortParser;
    }

    @Override
    public String description() {
        return "short(" + super.description() + ')';
    }

    @Override
    public DocValues getCachedFieldValues(FieldCache fieldCache, String string, IndexReader indexReader) throws IOException {
        final short[] sArray = fieldCache.getShorts(indexReader, string, this.parser);
        return new DocValues(){

            @Override
            public float floatVal(int n) {
                return sArray[n];
            }

            @Override
            public int intVal(int n) {
                return sArray[n];
            }

            @Override
            public String toString(int n) {
                return ShortFieldSource.this.description() + '=' + this.intVal(n);
            }

            @Override
            Object getInnerArray() {
                return sArray;
            }
        };
    }

    @Override
    public boolean cachedFieldSourceEquals(FieldCacheSource fieldCacheSource) {
        if (fieldCacheSource.getClass() != ShortFieldSource.class) {
            return false;
        }
        ShortFieldSource shortFieldSource = (ShortFieldSource)fieldCacheSource;
        return this.parser == null ? shortFieldSource.parser == null : this.parser.getClass() == shortFieldSource.parser.getClass();
    }

    @Override
    public int cachedFieldSourceHashCode() {
        return this.parser == null ? Short.class.hashCode() : this.parser.getClass().hashCode();
    }
}

