/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;

public abstract class SpanPositionCheckQuery
extends SpanQuery
implements Cloneable {
    protected SpanQuery match;

    public SpanPositionCheckQuery(SpanQuery spanQuery) {
        this.match = spanQuery;
    }

    public SpanQuery getMatch() {
        return this.match;
    }

    @Override
    public String getField() {
        return this.match.getField();
    }

    @Override
    public void extractTerms(Set<Term> set) {
        this.match.extractTerms(set);
    }

    protected abstract AcceptStatus acceptPosition(Spans var1) throws IOException;

    @Override
    public Spans getSpans(IndexReader indexReader) throws IOException {
        return new PositionCheckSpan(indexReader);
    }

    @Override
    public Query rewrite(IndexReader indexReader) throws IOException {
        SpanPositionCheckQuery spanPositionCheckQuery = null;
        SpanQuery spanQuery = (SpanQuery)this.match.rewrite(indexReader);
        if (spanQuery != this.match) {
            spanPositionCheckQuery = (SpanPositionCheckQuery)this.clone();
            spanPositionCheckQuery.match = spanQuery;
        }
        if (spanPositionCheckQuery != null) {
            return spanPositionCheckQuery;
        }
        return this;
    }

    protected class PositionCheckSpan
    extends Spans {
        private Spans spans;

        public PositionCheckSpan(IndexReader indexReader) throws IOException {
            this.spans = SpanPositionCheckQuery.this.match.getSpans(indexReader);
        }

        @Override
        public boolean next() throws IOException {
            if (!this.spans.next()) {
                return false;
            }
            return this.doNext();
        }

        @Override
        public boolean skipTo(int n) throws IOException {
            if (!this.spans.skipTo(n)) {
                return false;
            }
            return this.doNext();
        }

        protected boolean doNext() throws IOException {
            while (true) {
                switch (SpanPositionCheckQuery.this.acceptPosition(this)) {
                    case YES: {
                        return true;
                    }
                    case NO: {
                        if (this.spans.next()) break;
                        return false;
                    }
                    case NO_AND_ADVANCE: {
                        if (this.spans.skipTo(this.spans.doc() + 1)) break;
                        return false;
                    }
                }
            }
        }

        @Override
        public int doc() {
            return this.spans.doc();
        }

        @Override
        public int start() {
            return this.spans.start();
        }

        @Override
        public int end() {
            return this.spans.end();
        }

        @Override
        public Collection<byte[]> getPayload() throws IOException {
            ArrayList<byte[]> arrayList = null;
            if (this.spans.isPayloadAvailable()) {
                arrayList = new ArrayList<byte[]>(this.spans.getPayload());
            }
            return arrayList;
        }

        @Override
        public boolean isPayloadAvailable() {
            return this.spans.isPayloadAvailable();
        }

        public String toString() {
            return "spans(" + SpanPositionCheckQuery.this.toString() + ")";
        }
    }

    protected static enum AcceptStatus {
        YES,
        NO,
        NO_AND_ADVANCE;

    }
}

