/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import org.apache.lucene.search.spans.SpanPositionCheckQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.ToStringUtils;

public class SpanPositionRangeQuery
extends SpanPositionCheckQuery {
    protected int start = 0;
    protected int end;

    public SpanPositionRangeQuery(SpanQuery spanQuery, int n, int n2) {
        super(spanQuery);
        this.start = n;
        this.end = n2;
    }

    @Override
    protected SpanPositionCheckQuery.AcceptStatus acceptPosition(Spans spans) throws IOException {
        assert (spans.start() != spans.end());
        if (spans.start() >= this.end) {
            return SpanPositionCheckQuery.AcceptStatus.NO_AND_ADVANCE;
        }
        if (spans.start() >= this.start && spans.end() <= this.end) {
            return SpanPositionCheckQuery.AcceptStatus.YES;
        }
        return SpanPositionCheckQuery.AcceptStatus.NO;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    @Override
    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("spanPosRange(");
        stringBuilder.append(this.match.toString(string));
        stringBuilder.append(", ").append(this.start).append(", ");
        stringBuilder.append(this.end);
        stringBuilder.append(")");
        stringBuilder.append(ToStringUtils.boost(this.getBoost()));
        return stringBuilder.toString();
    }

    @Override
    public Object clone() {
        SpanPositionRangeQuery spanPositionRangeQuery = new SpanPositionRangeQuery((SpanQuery)this.match.clone(), this.start, this.end);
        spanPositionRangeQuery.setBoost(this.getBoost());
        return spanPositionRangeQuery;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SpanPositionRangeQuery)) {
            return false;
        }
        SpanPositionRangeQuery spanPositionRangeQuery = (SpanPositionRangeQuery)object;
        return this.end == spanPositionRangeQuery.end && this.start == spanPositionRangeQuery.start && this.match.equals(spanPositionRangeQuery.match) && this.getBoost() == spanPositionRangeQuery.getBoost();
    }

    @Override
    public int hashCode() {
        int n = this.match.hashCode();
        n ^= n << 8 | n >>> 25;
        return n ^= Float.floatToRawIntBits(this.getBoost()) ^ this.end ^ this.start;
    }
}

