/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

public abstract class BufferedIndexInput
extends IndexInput {
    public static final int BUFFER_SIZE = 1024;
    private int bufferSize = 1024;
    protected byte[] buffer;
    private long bufferStart = 0L;
    private int bufferLength = 0;
    private int bufferPosition = 0;

    @Override
    public byte readByte() throws IOException {
        if (this.bufferPosition >= this.bufferLength) {
            this.refill();
        }
        return this.buffer[this.bufferPosition++];
    }

    @Deprecated
    public BufferedIndexInput() {
        this("anonymous BuffereIndexInput");
    }

    public BufferedIndexInput(String string) {
        this(string, 1024);
    }

    @Deprecated
    public BufferedIndexInput(int n) {
        this("anonymous BuffereIndexInput", n);
    }

    public BufferedIndexInput(String string, int n) {
        super(string);
        this.checkBufferSize(n);
        this.bufferSize = n;
    }

    public void setBufferSize(int n) {
        assert (this.buffer == null || this.bufferSize == this.buffer.length) : "buffer=" + this.buffer + " bufferSize=" + this.bufferSize + " buffer.length=" + (this.buffer != null ? this.buffer.length : 0);
        if (n != this.bufferSize) {
            this.checkBufferSize(n);
            this.bufferSize = n;
            if (this.buffer != null) {
                byte[] byArray = new byte[n];
                int n2 = this.bufferLength - this.bufferPosition;
                int n3 = n2 > n ? n : n2;
                System.arraycopy(this.buffer, this.bufferPosition, byArray, 0, n3);
                this.bufferStart += (long)this.bufferPosition;
                this.bufferPosition = 0;
                this.bufferLength = n3;
                this.newBuffer(byArray);
            }
        }
    }

    protected void newBuffer(byte[] byArray) {
        this.buffer = byArray;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    private void checkBufferSize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("bufferSize must be greater than 0 (got " + n + ")");
        }
    }

    @Override
    public void readBytes(byte[] byArray, int n, int n2) throws IOException {
        this.readBytes(byArray, n, n2, true);
    }

    @Override
    public void readBytes(byte[] byArray, int n, int n2, boolean bl) throws IOException {
        if (n2 <= this.bufferLength - this.bufferPosition) {
            if (n2 > 0) {
                System.arraycopy(this.buffer, this.bufferPosition, byArray, n, n2);
            }
            this.bufferPosition += n2;
        } else {
            int n3 = this.bufferLength - this.bufferPosition;
            if (n3 > 0) {
                System.arraycopy(this.buffer, this.bufferPosition, byArray, n, n3);
                n += n3;
                n2 -= n3;
                this.bufferPosition += n3;
            }
            if (bl && n2 < this.bufferSize) {
                this.refill();
                if (this.bufferLength < n2) {
                    System.arraycopy(this.buffer, 0, byArray, n, this.bufferLength);
                    throw new IOException("read past EOF");
                }
                System.arraycopy(this.buffer, 0, byArray, n, n2);
                this.bufferPosition = n2;
            } else {
                long l = this.bufferStart + (long)this.bufferPosition + (long)n2;
                if (l > this.length()) {
                    throw new IOException("read past EOF");
                }
                this.readInternal(byArray, n, n2);
                this.bufferStart = l;
                this.bufferPosition = 0;
                this.bufferLength = 0;
            }
        }
    }

    @Override
    public int readInt() throws IOException {
        if (4 <= this.bufferLength - this.bufferPosition) {
            return (this.buffer[this.bufferPosition++] & 0xFF) << 24 | (this.buffer[this.bufferPosition++] & 0xFF) << 16 | (this.buffer[this.bufferPosition++] & 0xFF) << 8 | this.buffer[this.bufferPosition++] & 0xFF;
        }
        return super.readInt();
    }

    @Override
    public long readLong() throws IOException {
        if (8 <= this.bufferLength - this.bufferPosition) {
            int n = (this.buffer[this.bufferPosition++] & 0xFF) << 24 | (this.buffer[this.bufferPosition++] & 0xFF) << 16 | (this.buffer[this.bufferPosition++] & 0xFF) << 8 | this.buffer[this.bufferPosition++] & 0xFF;
            int n2 = (this.buffer[this.bufferPosition++] & 0xFF) << 24 | (this.buffer[this.bufferPosition++] & 0xFF) << 16 | (this.buffer[this.bufferPosition++] & 0xFF) << 8 | this.buffer[this.bufferPosition++] & 0xFF;
            return (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
        }
        return super.readLong();
    }

    @Override
    public int readVInt() throws IOException {
        if (5 <= this.bufferLength - this.bufferPosition) {
            byte by = this.buffer[this.bufferPosition++];
            int n = by & 0x7F;
            int n2 = 7;
            while ((by & 0x80) != 0) {
                by = this.buffer[this.bufferPosition++];
                n |= (by & 0x7F) << n2;
                n2 += 7;
            }
            return n;
        }
        return super.readVInt();
    }

    @Override
    public long readVLong() throws IOException {
        if (9 <= this.bufferLength - this.bufferPosition) {
            byte by = this.buffer[this.bufferPosition++];
            long l = by & 0x7F;
            int n = 7;
            while ((by & 0x80) != 0) {
                by = this.buffer[this.bufferPosition++];
                l |= ((long)by & 0x7FL) << n;
                n += 7;
            }
            return l;
        }
        return super.readVLong();
    }

    private void refill() throws IOException {
        int n;
        long l = this.bufferStart + (long)this.bufferPosition;
        long l2 = l + (long)this.bufferSize;
        if (l2 > this.length()) {
            l2 = this.length();
        }
        if ((n = (int)(l2 - l)) <= 0) {
            throw new IOException("read past EOF");
        }
        if (this.buffer == null) {
            this.newBuffer(new byte[this.bufferSize]);
            this.seekInternal(this.bufferStart);
        }
        this.readInternal(this.buffer, 0, n);
        this.bufferLength = n;
        this.bufferStart = l;
        this.bufferPosition = 0;
    }

    protected abstract void readInternal(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public long getFilePointer() {
        return this.bufferStart + (long)this.bufferPosition;
    }

    @Override
    public void seek(long l) throws IOException {
        if (l >= this.bufferStart && l < this.bufferStart + (long)this.bufferLength) {
            this.bufferPosition = (int)(l - this.bufferStart);
        } else {
            this.bufferStart = l;
            this.bufferPosition = 0;
            this.bufferLength = 0;
            this.seekInternal(l);
        }
    }

    protected abstract void seekInternal(long var1) throws IOException;

    @Override
    public Object clone() {
        BufferedIndexInput bufferedIndexInput = (BufferedIndexInput)super.clone();
        bufferedIndexInput.buffer = null;
        bufferedIndexInput.bufferLength = 0;
        bufferedIndexInput.bufferPosition = 0;
        bufferedIndexInput.bufferStart = this.getFilePointer();
        return bufferedIndexInput;
    }

    protected int flushBuffer(IndexOutput indexOutput, long l) throws IOException {
        int n = this.bufferLength - this.bufferPosition;
        if ((long)n > l) {
            n = (int)l;
        }
        if (n > 0) {
            indexOutput.writeBytes(this.buffer, this.bufferPosition, n);
            this.bufferPosition += n;
        }
        return n;
    }

    @Override
    public void copyBytes(IndexOutput indexOutput, long l) throws IOException {
        assert (l >= 0L) : "numBytes=" + l;
        while (l > 0L) {
            if (this.bufferLength == this.bufferPosition) {
                this.refill();
            }
            l -= (long)this.flushBuffer(indexOutput, l);
        }
    }
}

