/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;

public abstract class DataOutput {
    private static int COPY_BUFFER_SIZE = 16384;
    private byte[] copyBuffer;

    public abstract void writeByte(byte var1) throws IOException;

    public void writeBytes(byte[] byArray, int n) throws IOException {
        this.writeBytes(byArray, 0, n);
    }

    public abstract void writeBytes(byte[] var1, int var2, int var3) throws IOException;

    public void writeInt(int n) throws IOException {
        this.writeByte((byte)(n >> 24));
        this.writeByte((byte)(n >> 16));
        this.writeByte((byte)(n >> 8));
        this.writeByte((byte)n);
    }

    public final void writeVInt(int n) throws IOException {
        while ((n & 0xFFFFFF80) != 0) {
            this.writeByte((byte)(n & 0x7F | 0x80));
            n >>>= 7;
        }
        this.writeByte((byte)n);
    }

    public void writeLong(long l) throws IOException {
        this.writeInt((int)(l >> 32));
        this.writeInt((int)l);
    }

    public final void writeVLong(long l) throws IOException {
        while ((l & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte((byte)(l & 0x7FL | 0x80L));
            l >>>= 7;
        }
        this.writeByte((byte)l);
    }

    public void writeString(String string) throws IOException {
        BytesRef bytesRef = new BytesRef(10);
        UnicodeUtil.UTF16toUTF8((CharSequence)string, 0, string.length(), bytesRef);
        this.writeVInt(bytesRef.length);
        this.writeBytes(bytesRef.bytes, 0, bytesRef.length);
    }

    public void copyBytes(DataInput dataInput, long l) throws IOException {
        assert (l >= 0L) : "numBytes=" + l;
        long l2 = l;
        if (this.copyBuffer == null) {
            this.copyBuffer = new byte[COPY_BUFFER_SIZE];
        }
        while (l2 > 0L) {
            int n = l2 > (long)COPY_BUFFER_SIZE ? COPY_BUFFER_SIZE : (int)l2;
            dataInput.readBytes(this.copyBuffer, 0, n);
            this.writeBytes(this.copyBuffer, 0, n);
            l2 -= (long)n;
        }
    }

    @Deprecated
    public void writeChars(String string, int n, int n2) throws IOException {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.writeByte((byte)c);
                continue;
            }
            if (c >= '\u0080' && c <= '\u07ff' || c == '\u0000') {
                this.writeByte((byte)(0xC0 | c >> 6));
                this.writeByte((byte)(0x80 | c & 0x3F));
                continue;
            }
            this.writeByte((byte)(0xE0 | c >>> 12));
            this.writeByte((byte)(0x80 | c >> 6 & 0x3F));
            this.writeByte((byte)(0x80 | c & 0x3F));
        }
    }

    @Deprecated
    public void writeChars(char[] cArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            char c = cArray[i];
            if (c >= '\u0001' && c <= '\u007f') {
                this.writeByte((byte)c);
                continue;
            }
            if (c >= '\u0080' && c <= '\u07ff' || c == '\u0000') {
                this.writeByte((byte)(0xC0 | c >> 6));
                this.writeByte((byte)(0x80 | c & 0x3F));
                continue;
            }
            this.writeByte((byte)(0xE0 | c >>> 12));
            this.writeByte((byte)(0x80 | c >> 6 & 0x3F));
            this.writeByte((byte)(0x80 | c & 0x3F));
        }
    }

    public void writeStringStringMap(Map<String, String> map) throws IOException {
        if (map == null) {
            this.writeInt(0);
        } else {
            this.writeInt(map.size());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.writeString(entry.getKey());
                this.writeString(entry.getValue());
            }
        }
    }
}

