/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.store.BufferedIndexOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSLockFactory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.store.NoSuchDirectoryException;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.ThreadInterruptedException;

public abstract class FSDirectory
extends Directory {
    public static final int DEFAULT_READ_CHUNK_SIZE = Constants.JRE_IS_64BIT ? Integer.MAX_VALUE : 0x6400000;
    protected final File directory;
    protected final Set<String> staleFiles = Collections.synchronizedSet(new HashSet());
    private int chunkSize = DEFAULT_READ_CHUNK_SIZE;

    private static File getCanonicalPath(File file) throws IOException {
        return new File(file.getCanonicalPath());
    }

    protected FSDirectory(File file, LockFactory lockFactory) throws IOException {
        if (lockFactory == null) {
            lockFactory = new NativeFSLockFactory();
        }
        this.directory = FSDirectory.getCanonicalPath(file);
        if (this.directory.exists() && !this.directory.isDirectory()) {
            throw new NoSuchDirectoryException("file '" + this.directory + "' exists but is not a directory");
        }
        this.setLockFactory(lockFactory);
    }

    public static FSDirectory open(File file) throws IOException {
        return FSDirectory.open(file, null);
    }

    public static FSDirectory open(File file, LockFactory lockFactory) throws IOException {
        if ((Constants.WINDOWS || Constants.SUN_OS || Constants.LINUX) && Constants.JRE_IS_64BIT && MMapDirectory.UNMAP_SUPPORTED) {
            return new MMapDirectory(file, lockFactory);
        }
        if (Constants.WINDOWS) {
            return new SimpleFSDirectory(file, lockFactory);
        }
        return new NIOFSDirectory(file, lockFactory);
    }

    @Override
    public void setLockFactory(LockFactory lockFactory) throws IOException {
        super.setLockFactory(lockFactory);
        if (lockFactory instanceof FSLockFactory) {
            FSLockFactory fSLockFactory = (FSLockFactory)lockFactory;
            File file = fSLockFactory.getLockDir();
            if (file == null) {
                fSLockFactory.setLockDir(this.directory);
                fSLockFactory.setLockPrefix(null);
            } else if (file.getCanonicalPath().equals(this.directory.getCanonicalPath())) {
                fSLockFactory.setLockPrefix(null);
            }
        }
    }

    public static String[] listAll(File file) throws IOException {
        if (!file.exists()) {
            throw new NoSuchDirectoryException("directory '" + file + "' does not exist");
        }
        if (!file.isDirectory()) {
            throw new NoSuchDirectoryException("file '" + file + "' exists but is not a directory");
        }
        String[] stringArray = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return !new File(file, string).isDirectory();
            }
        });
        if (stringArray == null) {
            throw new IOException("directory '" + file + "' exists and is a directory, but cannot be listed: list() returned null");
        }
        return stringArray;
    }

    @Override
    public String[] listAll() throws IOException {
        this.ensureOpen();
        return FSDirectory.listAll(this.directory);
    }

    @Override
    public boolean fileExists(String string) {
        this.ensureOpen();
        File file = new File(this.directory, string);
        return file.exists();
    }

    @Override
    public long fileModified(String string) {
        this.ensureOpen();
        File file = new File(this.directory, string);
        return file.lastModified();
    }

    public static long fileModified(File file, String string) {
        File file2 = new File(file, string);
        return file2.lastModified();
    }

    @Override
    @Deprecated
    public void touchFile(String string) {
        this.ensureOpen();
        File file = new File(this.directory, string);
        file.setLastModified(System.currentTimeMillis());
    }

    @Override
    public long fileLength(String string) throws IOException {
        this.ensureOpen();
        File file = new File(this.directory, string);
        long l = file.length();
        if (l == 0L && !file.exists()) {
            throw new FileNotFoundException(string);
        }
        return l;
    }

    @Override
    public void deleteFile(String string) throws IOException {
        this.ensureOpen();
        File file = new File(this.directory, string);
        if (!file.delete()) {
            throw new IOException("Cannot delete " + file);
        }
        this.staleFiles.remove(string);
    }

    @Override
    public IndexOutput createOutput(String string) throws IOException {
        this.ensureOpen();
        this.ensureCanWrite(string);
        return new FSIndexOutput(this, string);
    }

    protected void ensureCanWrite(String string) throws IOException {
        if (!this.directory.exists() && !this.directory.mkdirs()) {
            throw new IOException("Cannot create directory: " + this.directory);
        }
        File file = new File(this.directory, string);
        if (file.exists() && !file.delete()) {
            throw new IOException("Cannot overwrite: " + file);
        }
    }

    protected void onIndexOutputClosed(FSIndexOutput fSIndexOutput) {
        this.staleFiles.add(fSIndexOutput.name);
    }

    @Override
    @Deprecated
    public void sync(String string) throws IOException {
        this.sync(Collections.singleton(string));
    }

    @Override
    public void sync(Collection<String> collection) throws IOException {
        this.ensureOpen();
        HashSet<String> hashSet = new HashSet<String>(collection);
        hashSet.retainAll(this.staleFiles);
        for (String string : hashSet) {
            this.fsync(string);
        }
        this.staleFiles.removeAll(hashSet);
    }

    @Override
    public IndexInput openInput(String string) throws IOException {
        this.ensureOpen();
        return this.openInput(string, 1024);
    }

    @Override
    public String getLockID() {
        String string;
        this.ensureOpen();
        try {
            string = this.directory.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString(), iOException);
        }
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            n = 31 * n + c;
        }
        return "lucene-" + Integer.toHexString(n);
    }

    @Override
    public synchronized void close() {
        this.isOpen = false;
    }

    @Deprecated
    public File getFile() {
        return this.getDirectory();
    }

    public File getDirectory() {
        this.ensureOpen();
        return this.directory;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "@" + this.directory + " lockFactory=" + this.getLockFactory();
    }

    public final void setReadChunkSize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("chunkSize must be positive");
        }
        if (!Constants.JRE_IS_64BIT) {
            this.chunkSize = n;
        }
    }

    public final int getReadChunkSize() {
        return this.chunkSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fsync(String string) throws IOException {
        File file = new File(this.directory, string);
        boolean bl = false;
        int n = 0;
        IOException iOException = null;
        while (!bl && n < 5) {
            ++n;
            RandomAccessFile randomAccessFile = null;
            try {
                try {
                    randomAccessFile = new RandomAccessFile(file, "rw");
                    randomAccessFile.getFD().sync();
                    bl = true;
                }
                finally {
                    if (randomAccessFile == null) continue;
                    randomAccessFile.close();
                }
            }
            catch (IOException iOException2) {
                if (iOException == null) {
                    iOException = iOException2;
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    throw new ThreadInterruptedException(interruptedException);
                }
            }
        }
        if (!bl) {
            throw iOException;
        }
    }

    protected static class FSIndexOutput
    extends BufferedIndexOutput {
        private final FSDirectory parent;
        private final String name;
        private final RandomAccessFile file;
        private volatile boolean isOpen;

        public FSIndexOutput(FSDirectory fSDirectory, String string) throws IOException {
            this.parent = fSDirectory;
            this.name = string;
            this.file = new RandomAccessFile(new File(fSDirectory.directory, string), "rw");
            this.isOpen = true;
        }

        @Override
        public void flushBuffer(byte[] byArray, int n, int n2) throws IOException {
            this.file.write(byArray, n, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            this.parent.onIndexOutputClosed(this);
            if (this.isOpen) {
                boolean bl = false;
                try {
                    super.close();
                    bl = true;
                }
                finally {
                    this.isOpen = false;
                    if (!bl) {
                        try {
                            this.file.close();
                        }
                        catch (Throwable throwable) {}
                    } else {
                        this.file.close();
                    }
                }
            }
        }

        @Override
        public void seek(long l) throws IOException {
            super.seek(l);
            this.file.seek(l);
        }

        @Override
        public long length() throws IOException {
            return this.file.length();
        }

        @Override
        public void setLength(long l) throws IOException {
            this.file.setLength(l);
        }
    }
}

