/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import org.apache.lucene.util.Attribute;
import org.apache.lucene.util.AttributeReflector;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.VirtualMethod;

public abstract class AttributeImpl
implements Cloneable,
Serializable,
Attribute {
    @Deprecated
    private static final VirtualMethod<AttributeImpl> toStringMethod = new VirtualMethod<AttributeImpl>(AttributeImpl.class, "toString", new Class[0]);
    @Deprecated
    protected boolean enableBackwards = true;

    public abstract void clear();

    public String toString() {
        return this.reflectAsString(false);
    }

    public final String reflectAsString(final boolean bl) {
        final StringBuilder stringBuilder = new StringBuilder();
        this.reflectWith(new AttributeReflector(){

            @Override
            public void reflect(Class<? extends Attribute> clazz, String string, Object object) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                if (bl) {
                    stringBuilder.append(clazz.getName()).append('#');
                }
                stringBuilder.append(string).append('=').append(object == null ? "null" : object);
            }
        });
        return stringBuilder.toString();
    }

    @Deprecated
    private boolean assertExternalClass(Class<? extends AttributeImpl> clazz) {
        String string = clazz.getName();
        return !string.startsWith("org.apache.lucene.") && !string.startsWith("org.apache.solr.") || string.equals("org.apache.lucene.util.TestAttributeSource$TestAttributeImpl");
    }

    public void reflectWith(AttributeReflector attributeReflector) {
        Class<?> clazz = this.getClass();
        LinkedList<WeakReference<Class<? extends Attribute>>> linkedList = AttributeSource.getAttributeInterfaces(clazz);
        if (linkedList.size() != 1) {
            throw new UnsupportedOperationException(clazz.getName() + " implements more than one Attribute interface, the default reflectWith() implementation cannot handle this.");
        }
        Class clazz2 = (Class)linkedList.getFirst().get();
        if (this.enableBackwards && toStringMethod.isOverriddenAsOf(clazz)) {
            assert (this.assertExternalClass(clazz)) : "no Lucene/Solr classes should fallback to toString() parsing";
            for (String string : this.toString().split(",")) {
                int n = string.indexOf(61);
                if (n < 0) {
                    throw new UnsupportedOperationException("The backwards compatibility layer to support reflectWith() on old AtributeImpls expects the toString() implementation to return a correct format as specified for method reflectAsString(false)");
                }
                attributeReflector.reflect(clazz2, string.substring(0, n).trim(), string.substring(n + 1));
            }
            return;
        }
        Field[] fieldArray = clazz.getDeclaredFields();
        try {
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                if (Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                attributeReflector.reflect(clazz2, field.getName(), field.get(this));
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    public abstract void copyTo(AttributeImpl var1);

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
        return object;
    }
}

