/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SorterTemplate;

public final class BytesRefHash {
    public static final int DEFAULT_CAPACITY = 16;
    final ByteBlockPool pool;
    int[] bytesStart;
    private final BytesRef scratch1 = new BytesRef();
    private int hashSize;
    private int hashHalfSize;
    private int hashMask;
    private int count;
    private int lastCount = -1;
    private int[] ords;
    private final BytesStartArray bytesStartArray;
    private AtomicLong bytesUsed;

    public BytesRefHash() {
        this(new ByteBlockPool(new ByteBlockPool.DirectAllocator()));
    }

    public BytesRefHash(ByteBlockPool byteBlockPool) {
        this(byteBlockPool, 16, new DirectBytesStartArray(16));
    }

    public BytesRefHash(ByteBlockPool byteBlockPool, int n, BytesStartArray bytesStartArray) {
        this.hashSize = n;
        this.hashHalfSize = this.hashSize >> 1;
        this.hashMask = this.hashSize - 1;
        this.pool = byteBlockPool;
        this.ords = new int[this.hashSize];
        Arrays.fill(this.ords, -1);
        this.bytesStartArray = bytesStartArray;
        this.bytesStart = bytesStartArray.init();
        this.bytesUsed = bytesStartArray.bytesUsed() == null ? new AtomicLong(0L) : bytesStartArray.bytesUsed();
        this.bytesUsed.addAndGet(this.hashSize * 4);
    }

    public int size() {
        return this.count;
    }

    public BytesRef get(int n, BytesRef bytesRef) {
        assert (this.bytesStart != null) : "bytesStart is null - not initialized";
        assert (n < this.bytesStart.length) : "ord exceeds byteStart len: " + this.bytesStart.length;
        return this.pool.setBytesRef(bytesRef, this.bytesStart[n]);
    }

    public int[] compact() {
        assert (this.bytesStart != null) : "Bytesstart is null - not initialized";
        int n = 0;
        for (int i = 0; i < this.hashSize; ++i) {
            if (this.ords[i] == -1) continue;
            if (n < i) {
                this.ords[n] = this.ords[i];
                this.ords[i] = -1;
            }
            ++n;
        }
        assert (n == this.count);
        this.lastCount = this.count;
        return this.ords;
    }

    public int[] sort(final Comparator<BytesRef> comparator) {
        final int[] nArray = this.compact();
        new SorterTemplate(){
            private final BytesRef pivot = new BytesRef();
            private final BytesRef scratch1 = new BytesRef();
            private final BytesRef scratch2 = new BytesRef();

            @Override
            protected void swap(int n, int n2) {
                int n3 = nArray[n];
                nArray[n] = nArray[n2];
                nArray[n2] = n3;
            }

            @Override
            protected int compare(int n, int n2) {
                int n3 = nArray[n];
                int n4 = nArray[n2];
                assert (BytesRefHash.this.bytesStart.length > n3 && BytesRefHash.this.bytesStart.length > n4);
                return comparator.compare(BytesRefHash.this.pool.setBytesRef(this.scratch1, BytesRefHash.this.bytesStart[n3]), BytesRefHash.this.pool.setBytesRef(this.scratch2, BytesRefHash.this.bytesStart[n4]));
            }

            @Override
            protected void setPivot(int n) {
                int n2 = nArray[n];
                assert (BytesRefHash.this.bytesStart.length > n2);
                BytesRefHash.this.pool.setBytesRef(this.pivot, BytesRefHash.this.bytesStart[n2]);
            }

            @Override
            protected int comparePivot(int n) {
                int n2 = nArray[n];
                assert (BytesRefHash.this.bytesStart.length > n2);
                return comparator.compare(this.pivot, BytesRefHash.this.pool.setBytesRef(this.scratch2, BytesRefHash.this.bytesStart[n2]));
            }
        }.quickSort(0, this.count - 1);
        return nArray;
    }

    private boolean equals(int n, BytesRef bytesRef) {
        return this.pool.setBytesRef(this.scratch1, this.bytesStart[n]).bytesEquals(bytesRef);
    }

    private boolean shrink(int n) {
        int n2;
        for (n2 = this.hashSize; n2 >= 8 && n2 / 4 > n; n2 /= 2) {
        }
        if (n2 != this.hashSize) {
            this.bytesUsed.addAndGet(4 * -(this.hashSize - n2));
            this.hashSize = n2;
            this.ords = new int[this.hashSize];
            Arrays.fill(this.ords, -1);
            this.hashHalfSize = n2 / 2;
            this.hashMask = n2 - 1;
            return true;
        }
        return false;
    }

    public void clear(boolean bl) {
        this.lastCount = this.count;
        this.count = 0;
        if (bl) {
            this.pool.dropBuffersAndReset();
        }
        this.bytesStart = this.bytesStartArray.clear();
        if (this.lastCount != -1 && this.shrink(this.lastCount)) {
            return;
        }
        Arrays.fill(this.ords, -1);
    }

    public void clear() {
        this.clear(true);
    }

    public void close() {
        this.clear(true);
        this.ords = null;
        this.bytesUsed.addAndGet(4 * -this.hashSize);
    }

    public int add(BytesRef bytesRef) {
        return this.add(bytesRef, bytesRef.hashCode());
    }

    public int add(BytesRef bytesRef, int n) {
        int n2;
        assert (this.bytesStart != null) : "Bytesstart is null - not initialized";
        int n3 = bytesRef.length;
        int n4 = n & this.hashMask;
        int n5 = this.ords[n4];
        if (n5 != -1 && !this.equals(n5, bytesRef)) {
            n2 = (n >> 8) + n | 1;
            while ((n5 = this.ords[n4 = (n += n2) & this.hashMask]) != -1 && !this.equals(n5, bytesRef)) {
            }
        }
        if (n5 == -1) {
            n2 = 2 + bytesRef.length;
            if (n2 + this.pool.byteUpto > 32768) {
                if (n2 > 32768) {
                    throw new MaxBytesLengthExceededException("bytes can be at most 32766 in length; got " + bytesRef.length);
                }
                this.pool.nextBuffer();
            }
            byte[] byArray = this.pool.buffer;
            int n6 = this.pool.byteUpto;
            if (this.count >= this.bytesStart.length) {
                this.bytesStart = this.bytesStartArray.grow();
                assert (this.count < this.bytesStart.length + 1) : "count: " + this.count + " len: " + this.bytesStart.length;
            }
            n5 = this.count++;
            this.bytesStart[n5] = n6 + this.pool.byteOffset;
            if (n3 < 128) {
                byArray[n6] = (byte)n3;
                this.pool.byteUpto += n3 + 1;
                assert (n3 >= 0) : "Length must be positive: " + n3;
                System.arraycopy(bytesRef.bytes, bytesRef.offset, byArray, n6 + 1, n3);
            } else {
                byArray[n6] = (byte)(0x80 | n3 & 0x7F);
                byArray[n6 + 1] = (byte)(n3 >> 7 & 0xFF);
                this.pool.byteUpto += n3 + 2;
                System.arraycopy(bytesRef.bytes, bytesRef.offset, byArray, n6 + 2, n3);
            }
            assert (this.ords[n4] == -1);
            this.ords[n4] = n5;
            if (this.count == this.hashHalfSize) {
                this.rehash(2 * this.hashSize, true);
            }
            return n5;
        }
        return -(n5 + 1);
    }

    public int addByPoolOffset(int n) {
        assert (this.bytesStart != null) : "Bytesstart is null - not initialized";
        int n2 = n;
        int n3 = n & this.hashMask;
        int n4 = this.ords[n3];
        if (n4 != -1 && this.bytesStart[n4] != n) {
            int n5 = (n2 >> 8) + n2 | 1;
            while ((n4 = this.ords[n3 = (n2 += n5) & this.hashMask]) != -1 && this.bytesStart[n4] != n) {
            }
        }
        if (n4 == -1) {
            if (this.count >= this.bytesStart.length) {
                this.bytesStart = this.bytesStartArray.grow();
                assert (this.count < this.bytesStart.length + 1) : "count: " + this.count + " len: " + this.bytesStart.length;
            }
            n4 = this.count++;
            this.bytesStart[n4] = n;
            assert (this.ords[n3] == -1);
            this.ords[n3] = n4;
            if (this.count == this.hashHalfSize) {
                this.rehash(2 * this.hashSize, false);
            }
            return n4;
        }
        return -(n4 + 1);
    }

    private void rehash(int n, boolean bl) {
        int n2 = n - 1;
        this.bytesUsed.addAndGet(4 * n);
        int[] nArray = new int[n];
        Arrays.fill(nArray, -1);
        for (int i = 0; i < this.hashSize; ++i) {
            int n3;
            int n4;
            int n5;
            int n6 = this.ords[i];
            if (n6 == -1) continue;
            if (bl) {
                int n7;
                int n8;
                n5 = this.bytesStart[n6];
                n4 = n5 & Short.MAX_VALUE;
                byte[] byArray = this.pool.buffers[n5 >> 15];
                n3 = 0;
                if ((byArray[n4] & 0x80) == 0) {
                    n8 = byArray[n4];
                    n7 = n4 + 1;
                } else {
                    n8 = (byArray[n4] & 0x7F) + ((byArray[n4 + 1] & 0xFF) << 7);
                    n7 = n4 + 2;
                }
                int n9 = n7 + n8;
                while (n7 < n9) {
                    n3 = 31 * n3 + byArray[n7++];
                }
            } else {
                n3 = this.bytesStart[n6];
            }
            n5 = n3 & n2;
            assert (n5 >= 0);
            if (nArray[n5] != -1) {
                n4 = (n3 >> 8) + n3 | 1;
                while (nArray[n5 = (n3 += n4) & n2] != -1) {
                }
            }
            nArray[n5] = n6;
        }
        this.hashMask = n2;
        this.bytesUsed.addAndGet(4 * -this.ords.length);
        this.ords = nArray;
        this.hashSize = n;
        this.hashHalfSize = n / 2;
    }

    public void reinit() {
        if (this.bytesStart == null) {
            this.bytesStart = this.bytesStartArray.init();
        }
        if (this.ords == null) {
            this.ords = new int[this.hashSize];
            this.bytesUsed.addAndGet(4 * this.hashSize);
        }
    }

    public int byteStart(int n) {
        assert (this.bytesStart != null) : "Bytesstart is null - not initialized";
        assert (n >= 0 && n < this.count) : n;
        return this.bytesStart[n];
    }

    public static class DirectBytesStartArray
    extends BytesStartArray {
        protected final int initSize;
        private int[] bytesStart;
        private final AtomicLong bytesUsed = new AtomicLong(0L);

        public DirectBytesStartArray(int n) {
            this.initSize = n;
        }

        @Override
        public int[] clear() {
            this.bytesStart = null;
            return null;
        }

        @Override
        public int[] grow() {
            assert (this.bytesStart != null);
            this.bytesStart = ArrayUtil.grow(this.bytesStart, this.bytesStart.length + 1);
            return this.bytesStart;
        }

        @Override
        public int[] init() {
            this.bytesStart = new int[ArrayUtil.oversize(this.initSize, 4)];
            return this.bytesStart;
        }

        @Override
        public AtomicLong bytesUsed() {
            return this.bytesUsed;
        }
    }

    public static class TrackingDirectBytesStartArray
    extends BytesStartArray {
        protected final int initSize;
        private int[] bytesStart;
        protected final AtomicLong bytesUsed;

        public TrackingDirectBytesStartArray(int n, AtomicLong atomicLong) {
            this.initSize = n;
            this.bytesUsed = atomicLong;
        }

        @Override
        public int[] clear() {
            if (this.bytesStart != null) {
                this.bytesUsed.addAndGet(-this.bytesStart.length * 4);
            }
            this.bytesStart = null;
            return null;
        }

        @Override
        public int[] grow() {
            assert (this.bytesStart != null);
            int n = this.bytesStart.length;
            this.bytesStart = ArrayUtil.grow(this.bytesStart, this.bytesStart.length + 1);
            this.bytesUsed.addAndGet((this.bytesStart.length - n) * 4);
            return this.bytesStart;
        }

        @Override
        public int[] init() {
            this.bytesStart = new int[ArrayUtil.oversize(this.initSize, 4)];
            this.bytesUsed.addAndGet(this.bytesStart.length * 4);
            return this.bytesStart;
        }

        @Override
        public AtomicLong bytesUsed() {
            return this.bytesUsed;
        }
    }

    public static abstract class BytesStartArray {
        public abstract int[] init();

        public abstract int[] grow();

        public abstract int[] clear();

        public abstract AtomicLong bytesUsed();
    }

    public static class MaxBytesLengthExceededException
    extends RuntimeException {
        MaxBytesLengthExceededException(String string) {
            super(string);
        }
    }
}

