/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.util.Version;

public abstract class CharacterUtils {
    private static final Java4CharacterUtils JAVA_4 = new Java4CharacterUtils();
    private static final Java5CharacterUtils JAVA_5 = new Java5CharacterUtils();

    public static CharacterUtils getInstance(Version version) {
        return version.onOrAfter(Version.LUCENE_31) ? JAVA_5 : JAVA_4;
    }

    public abstract int codePointAt(char[] var1, int var2);

    public abstract int codePointAt(CharSequence var1, int var2);

    public abstract int codePointAt(char[] var1, int var2, int var3);

    public static CharacterBuffer newCharacterBuffer(int n) {
        if (n < 2) {
            throw new IllegalArgumentException("buffersize must be >= 2");
        }
        return new CharacterBuffer(new char[n], 0, 0);
    }

    public abstract boolean fill(CharacterBuffer var1, Reader var2) throws IOException;

    public static final class CharacterBuffer {
        private final char[] buffer;
        private int offset;
        private int length;
        private char lastTrailingHighSurrogate = '\u0000';

        CharacterBuffer(char[] cArray, int n, int n2) {
            this.buffer = cArray;
            this.offset = n;
            this.length = n2;
        }

        public char[] getBuffer() {
            return this.buffer;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public void reset() {
            this.offset = 0;
            this.length = 0;
            this.lastTrailingHighSurrogate = '\u0000';
        }
    }

    private static final class Java4CharacterUtils
    extends CharacterUtils {
        Java4CharacterUtils() {
        }

        @Override
        public final int codePointAt(char[] cArray, int n) {
            return cArray[n];
        }

        @Override
        public int codePointAt(CharSequence charSequence, int n) {
            return charSequence.charAt(n);
        }

        @Override
        public int codePointAt(char[] cArray, int n, int n2) {
            if (n >= n2) {
                throw new IndexOutOfBoundsException("offset must be less than limit");
            }
            return cArray[n];
        }

        @Override
        public boolean fill(CharacterBuffer characterBuffer, Reader reader) throws IOException {
            characterBuffer.offset = 0;
            int n = reader.read(characterBuffer.buffer);
            if (n == -1) {
                return false;
            }
            characterBuffer.length = n;
            return true;
        }
    }

    private static final class Java5CharacterUtils
    extends CharacterUtils {
        Java5CharacterUtils() {
        }

        @Override
        public final int codePointAt(char[] cArray, int n) {
            return Character.codePointAt(cArray, n);
        }

        @Override
        public int codePointAt(CharSequence charSequence, int n) {
            return Character.codePointAt(charSequence, n);
        }

        @Override
        public int codePointAt(char[] cArray, int n, int n2) {
            return Character.codePointAt(cArray, n, n2);
        }

        @Override
        public boolean fill(CharacterBuffer characterBuffer, Reader reader) throws IOException {
            char[] cArray = characterBuffer.buffer;
            characterBuffer.offset = 0;
            cArray[0] = characterBuffer.lastTrailingHighSurrogate;
            int n = characterBuffer.lastTrailingHighSurrogate == '\u0000' ? 0 : 1;
            characterBuffer.lastTrailingHighSurrogate = '\u0000';
            int n2 = reader.read(cArray, n, cArray.length - n);
            if (n2 == -1) {
                characterBuffer.length = n;
                return n != 0;
            }
            characterBuffer.length = n2 + n;
            if (characterBuffer.length > 1 && Character.isHighSurrogate(cArray[characterBuffer.length - 1])) {
                characterBuffer.lastTrailingHighSurrogate = cArray[--characterBuffer.length];
            }
            return true;
        }
    }
}

