/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CloseableThreadLocal<T>
implements Closeable {
    private ThreadLocal<WeakReference<T>> t = new ThreadLocal();
    private Map<Thread, T> hardRefs = new HashMap<Thread, T>();

    protected T initialValue() {
        return null;
    }

    public T get() {
        WeakReference<T> weakReference = this.t.get();
        if (weakReference == null) {
            T t = this.initialValue();
            if (t != null) {
                this.set(t);
                return t;
            }
            return null;
        }
        return weakReference.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(T t) {
        this.t.set(new WeakReference<T>(t));
        Map<Thread, T> map = this.hardRefs;
        synchronized (map) {
            this.hardRefs.put(Thread.currentThread(), t);
            Iterator<Thread> iterator = this.hardRefs.keySet().iterator();
            while (iterator.hasNext()) {
                Thread thread = iterator.next();
                if (thread.isAlive()) continue;
                iterator.remove();
            }
        }
    }

    @Override
    public void close() {
        this.hardRefs = null;
        if (this.t != null) {
            this.t.remove();
        }
        this.t = null;
    }
}

