/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.IndexReader;

public final class ReaderUtil {
    private ReaderUtil() {
    }

    public static void gatherSubReaders(List<IndexReader> list, IndexReader indexReader) {
        IndexReader[] indexReaderArray = indexReader.getSequentialSubReaders();
        if (indexReaderArray == null) {
            list.add(indexReader);
        } else {
            for (int i = 0; i < indexReaderArray.length; ++i) {
                ReaderUtil.gatherSubReaders(list, indexReaderArray[i]);
            }
        }
    }

    public static IndexReader subReader(int n, IndexReader indexReader) {
        ArrayList<IndexReader> arrayList = new ArrayList<IndexReader>();
        ReaderUtil.gatherSubReaders(arrayList, indexReader);
        IndexReader[] indexReaderArray = arrayList.toArray(new IndexReader[arrayList.size()]);
        int[] nArray = new int[indexReaderArray.length];
        int n2 = 0;
        for (int i = 0; i < indexReaderArray.length; ++i) {
            nArray[i] = n2;
            n2 += indexReaderArray[i].maxDoc();
        }
        return indexReaderArray[ReaderUtil.subIndex(n, nArray)];
    }

    public static IndexReader subReader(IndexReader indexReader, int n) {
        ArrayList<IndexReader> arrayList = new ArrayList<IndexReader>();
        ReaderUtil.gatherSubReaders(arrayList, indexReader);
        IndexReader[] indexReaderArray = arrayList.toArray(new IndexReader[arrayList.size()]);
        return indexReaderArray[n];
    }

    public static int subIndex(int n, int[] nArray) {
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = n2 - 1;
        while (n4 >= n3) {
            int n5 = n3 + n4 >>> 1;
            int n6 = nArray[n5];
            if (n < n6) {
                n4 = n5 - 1;
                continue;
            }
            if (n > n6) {
                n3 = n5 + 1;
                continue;
            }
            while (n5 + 1 < n2 && nArray[n5 + 1] == n6) {
                ++n5;
            }
            return n5;
        }
        return n4;
    }

    public static abstract class Gather {
        private final IndexReader topReader;

        public Gather(IndexReader indexReader) {
            this.topReader = indexReader;
        }

        public int run() throws IOException {
            return this.run(0, this.topReader);
        }

        public int run(int n) throws IOException {
            return this.run(n, this.topReader);
        }

        private int run(int n, IndexReader indexReader) throws IOException {
            IndexReader[] indexReaderArray = indexReader.getSequentialSubReaders();
            if (indexReaderArray == null) {
                this.add(n, indexReader);
                n += indexReader.maxDoc();
            } else {
                for (int i = 0; i < indexReaderArray.length; ++i) {
                    n = this.run(n, indexReaderArray[i]);
                }
            }
            return n;
        }

        protected abstract void add(int var1, IndexReader var2) throws IOException;
    }
}

