/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.StringInterner;

public class SimpleStringInterner
extends StringInterner {
    private final Entry[] cache;
    private final int maxChainLength;

    public SimpleStringInterner(int n, int n2) {
        this.cache = new Entry[Math.max(1, BitUtil.nextHighestPowerOfTwo(n))];
        this.maxChainLength = Math.max(2, n2);
    }

    @Override
    public String intern(String string) {
        int n = string.hashCode();
        int n2 = n & this.cache.length - 1;
        Entry entry = this.cache[n2];
        Entry entry2 = null;
        int n3 = 0;
        Entry entry3 = entry;
        while (entry3 != null) {
            if (entry3.hash == n && (entry3.str == string || entry3.str.compareTo(string) == 0)) {
                return entry3.str;
            }
            ++n3;
            if (entry3.next != null) {
                entry2 = entry3;
            }
            entry3 = entry3.next;
        }
        string = string.intern();
        this.cache[n2] = new Entry(string, n, entry);
        if (n3 >= this.maxChainLength) {
            entry2.next = null;
        }
        return string;
    }

    private static class Entry {
        private final String str;
        private final int hash;
        private Entry next;

        private Entry(String string, int n, Entry entry) {
            this.str = string;
            this.hash = n;
            this.next = entry;
        }
    }
}

