/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.fst.Outputs;

public final class ByteSequenceOutputs
extends Outputs<BytesRef> {
    private static final BytesRef NO_OUTPUT = new BytesRef();

    private ByteSequenceOutputs() {
    }

    public static ByteSequenceOutputs getSingleton() {
        return new ByteSequenceOutputs();
    }

    @Override
    public BytesRef common(BytesRef bytesRef, BytesRef bytesRef2) {
        assert (bytesRef != null);
        assert (bytesRef2 != null);
        int n = bytesRef.offset;
        int n2 = bytesRef2.offset;
        int n3 = n + Math.min(bytesRef.length, bytesRef2.length);
        while (n < n3 && bytesRef.bytes[n] == bytesRef2.bytes[n2]) {
            ++n;
            ++n2;
        }
        if (n == bytesRef.offset) {
            return NO_OUTPUT;
        }
        if (n == bytesRef.offset + bytesRef.length) {
            return bytesRef;
        }
        if (n2 == bytesRef2.offset + bytesRef2.length) {
            return bytesRef2;
        }
        return new BytesRef(bytesRef.bytes, bytesRef.offset, n - bytesRef.offset);
    }

    @Override
    public BytesRef subtract(BytesRef bytesRef, BytesRef bytesRef2) {
        assert (bytesRef != null);
        assert (bytesRef2 != null);
        if (bytesRef2 == NO_OUTPUT) {
            return bytesRef;
        }
        if (bytesRef2.length == bytesRef.length) {
            return NO_OUTPUT;
        }
        assert (bytesRef2.length < bytesRef.length) : "inc.length=" + bytesRef2.length + " vs output.length=" + bytesRef.length;
        assert (bytesRef2.length > 0);
        return new BytesRef(bytesRef.bytes, bytesRef.offset + bytesRef2.length, bytesRef.length - bytesRef2.length);
    }

    @Override
    public BytesRef add(BytesRef bytesRef, BytesRef bytesRef2) {
        assert (bytesRef != null);
        assert (bytesRef2 != null);
        if (bytesRef == NO_OUTPUT) {
            return bytesRef2;
        }
        if (bytesRef2 == NO_OUTPUT) {
            return bytesRef;
        }
        assert (bytesRef.length > 0);
        assert (bytesRef2.length > 0);
        BytesRef bytesRef3 = new BytesRef(bytesRef.length + bytesRef2.length);
        System.arraycopy(bytesRef.bytes, bytesRef.offset, bytesRef3.bytes, 0, bytesRef.length);
        System.arraycopy(bytesRef2.bytes, bytesRef2.offset, bytesRef3.bytes, bytesRef.length, bytesRef2.length);
        bytesRef3.length = bytesRef.length + bytesRef2.length;
        return bytesRef3;
    }

    @Override
    public void write(BytesRef bytesRef, DataOutput dataOutput) throws IOException {
        assert (bytesRef != null);
        dataOutput.writeVInt(bytesRef.length);
        dataOutput.writeBytes(bytesRef.bytes, bytesRef.offset, bytesRef.length);
    }

    @Override
    public BytesRef read(DataInput dataInput) throws IOException {
        int n = dataInput.readVInt();
        if (n == 0) {
            return NO_OUTPUT;
        }
        BytesRef bytesRef = new BytesRef(n);
        dataInput.readBytes(bytesRef.bytes, 0, n);
        bytesRef.length = n;
        return bytesRef;
    }

    @Override
    public BytesRef getNoOutput() {
        return NO_OUTPUT;
    }

    @Override
    public String outputToString(BytesRef bytesRef) {
        return bytesRef.utf8ToString();
    }
}

