/*
 * Decompiled with CFR 0.152.
 */
package jd.config;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jd.config.SubConfiguration;
import jd.controlling.JDLogger;
import jd.utils.JDUtilities;
import org.appwork.utils.IO;

public class DatabaseConnector
implements Serializable {
    private static final long serialVersionUID = 8074213660382482620L;
    private static Logger logger = JDLogger.getLogger();
    private String configpath = JDUtilities.getJDHomeDirectoryFromEnvironment().getAbsolutePath() + "/config/";
    private final HashMap<String, Object> dbdata = new HashMap();
    public static final Object LOCK = new Object();
    private static boolean dbshutdown = false;
    private static Connection con = null;

    public static boolean isDatabaseShutdown() {
        return dbshutdown;
    }

    public DatabaseConnector(String string) throws SQLException {
    }

    public DatabaseConnector() throws SQLException {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDatabaseHeader() {
        logger.finer("Checking database");
        File file = new File(this.configpath + "database.script");
        if (!file.exists()) {
            return true;
        }
        boolean bl = true;
        BufferedInputStream bufferedInputStream = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            String string = "";
            byte[] byArray = new byte[100];
            block32: for (int i = 0; i < 7; ++i) {
                string = IO.readLine(bufferedInputStream, byArray);
                if (string == null) {
                    bl = false;
                    break;
                }
                switch (i) {
                    case 0: {
                        if (string.equals("CREATE SCHEMA PUBLIC AUTHORIZATION DBA")) continue block32;
                        bl = false;
                        continue block32;
                    }
                    case 1: {
                        if (string.equals("CREATE MEMORY TABLE CONFIG(NAME VARCHAR(256),OBJ OBJECT)")) continue block32;
                        bl = false;
                        continue block32;
                    }
                    case 2: {
                        if (string.equals("CREATE MEMORY TABLE LINKS(NAME VARCHAR(256),OBJ OBJECT)")) continue block32;
                        bl = false;
                        continue block32;
                    }
                    case 3: {
                        if (string.equals("CREATE USER SA PASSWORD \"\"")) continue block32;
                        bl = false;
                        continue block32;
                    }
                    case 4: {
                        if (string.equals("GRANT DBA TO SA")) continue block32;
                        bl = false;
                        continue block32;
                    }
                    case 5: {
                        if (string.equals("SET WRITE_DELAY 10")) continue block32;
                        bl = false;
                        continue block32;
                    }
                    case 6: {
                        if (string.equals("SET SCHEMA PUBLIC")) continue block32;
                        bl = false;
                    }
                }
            }
            while ((string = IO.readLine(bufferedInputStream, byArray)) != null) {
                if (string.startsWith("INSERT INTO")) continue;
                bl = false;
                break;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = false;
        }
        catch (IOException iOException) {
            bl = false;
        }
        finally {
            try {
                bufferedInputStream.close();
            }
            catch (Throwable throwable) {}
            try {
                fileInputStream.close();
            }
            catch (Throwable throwable) {}
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean hasData(String string) {
        Object object = LOCK;
        synchronized (object) {
            block24: {
                if (!DatabaseConnector.isDatabaseShutdown()) {
                    boolean bl;
                    Statement statement = null;
                    ResultSet resultSet = null;
                    try {
                        statement = con.createStatement();
                        resultSet = statement.executeQuery("SELECT * FROM config WHERE name = '" + string + "'");
                        if (!resultSet.next()) break block24;
                        bl = true;
                    }
                    catch (Exception exception) {
                        break block24;
                    }
                    return bl;
                    finally {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable) {}
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeData(String string) {
        Object object = LOCK;
        synchronized (object) {
            if (!DatabaseConnector.isDatabaseShutdown()) {
                this.dbdata.remove(string);
                Statement statement = null;
                ResultSet resultSet = null;
                try {
                    statement = con.createStatement();
                    resultSet = statement.executeQuery("DELETE FROM config WHERE name = '" + string + "'");
                }
                catch (Exception exception) {
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable) {}
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
        }
    }

    public synchronized Object getData(String string) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<SubConfiguration> getSubConfigurationKeys() {
        Object object = LOCK;
        synchronized (object) {
            if (DatabaseConnector.isDatabaseShutdown()) {
                return null;
            }
            ArrayList<SubConfiguration> arrayList = new ArrayList<SubConfiguration>();
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                statement = con.createStatement();
                resultSet = statement.executeQuery("SELECT * FROM config");
                while (resultSet.next()) {
                    SubConfiguration subConfiguration = SubConfiguration.getConfig(resultSet.getString(1));
                    HashMap<String, Object> hashMap = subConfiguration.getProperties();
                    if (hashMap == null || hashMap.size() <= 0) continue;
                    arrayList.add(subConfiguration);
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (Throwable throwable) {}
                try {
                    statement.close();
                }
                catch (Throwable throwable) {}
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfiguration(String string, Object object) {
        Object object2 = LOCK;
        synchronized (object2) {
            if (!DatabaseConnector.isDatabaseShutdown()) {
                this.dbdata.put(string, object);
                ResultSet resultSet = null;
                Statement statement = null;
                Statement statement2 = null;
                try {
                    statement = con.createStatement();
                    resultSet = statement.executeQuery("SELECT COUNT(name) FROM config WHERE name = '" + string + "'");
                    resultSet.next();
                    if (resultSet.getInt(1) > 0) {
                        statement2 = con.prepareStatement("UPDATE config SET obj = ? WHERE name = '" + string + "'");
                        statement2.setObject(1, object);
                        statement2.execute();
                    } else {
                        statement2 = con.prepareStatement("INSERT INTO config VALUES (?,?)");
                        statement2.setString(1, string);
                        statement2.setObject(2, object);
                        statement2.execute();
                    }
                }
                catch (Exception exception) {
                    Statement statement3 = null;
                    try {
                        System.out.println("First save " + string);
                        statement3 = con.prepareStatement("INSERT INTO config VALUES (?,?)");
                        statement2.setString(1, string);
                        statement2.setObject(2, object);
                        statement2.execute();
                    }
                    catch (Exception exception2) {
                        JDLogger.getLogger().warning("Database save error: " + string);
                        JDLogger.exception(Level.FINEST, exception2);
                    }
                    finally {
                        try {
                            statement3.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        statement2.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownDatabase() {
        Object object = LOCK;
        synchronized (object) {
            if (!DatabaseConnector.isDatabaseShutdown()) {
                try {
                    dbshutdown = true;
                    con.close();
                }
                catch (SQLException sQLException) {
                    JDLogger.exception(sQLException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getLinks() {
        Object object = LOCK;
        synchronized (object) {
            block20: {
                if (!DatabaseConnector.isDatabaseShutdown()) {
                    Object object2;
                    Statement statement = null;
                    ResultSet resultSet = null;
                    try {
                        statement = con.createStatement();
                        resultSet = statement.executeQuery("SELECT * FROM links");
                        resultSet.next();
                        object2 = resultSet.getObject(2);
                    }
                    catch (Throwable throwable) {
                        JDLogger.exception(Level.FINEST, throwable);
                        JDLogger.getLogger().warning("Database not available. Create new one: links");
                        break block20;
                    }
                    return object2;
                    finally {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable) {}
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        Object object = LOCK;
        synchronized (object) {
            if (!DatabaseConnector.isDatabaseShutdown()) {
                PreparedStatement preparedStatement = null;
                try {
                    preparedStatement = con.prepareStatement("CHECKPOINT");
                    preparedStatement.execute();
                }
                catch (Exception exception) {
                    JDLogger.exception(exception);
                }
                finally {
                    try {
                        preparedStatement.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    public Connection getDatabaseConnection() {
        return con;
    }
}

