/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.downloadcontroller;

import java.io.File;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.logging.Logger;
import jd.controlling.IOPermission;
import jd.controlling.JDLogger;
import jd.controlling.JDPluginLogger;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.downloadcontroller.DownloadSpeedManager;
import jd.controlling.downloadcontroller.SingleDownloadControllerHandler;
import jd.controlling.proxy.ProxyInfo;
import jd.http.Browser;
import jd.http.BrowserSettingsThread;
import jd.nutils.io.JDIO;
import jd.plugins.Account;
import jd.plugins.DownloadLink;
import jd.plugins.LinkStatus;
import jd.plugins.PluginException;
import jd.plugins.PluginForHost;
import jd.plugins.download.DownloadInterface;
import org.appwork.controlling.State;
import org.appwork.controlling.StateMachine;
import org.appwork.controlling.StateMachineInterface;
import org.appwork.controlling.StateMonitor;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.Exceptions;
import org.appwork.utils.Regex;
import org.appwork.utils.logging.Log;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.jdownloader.controlling.FileCreationEvent;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.settings.GeneralSettings;
import org.jdownloader.settings.IfFileExistsAction;
import org.jdownloader.translate._JDT;

public class SingleDownloadController
extends BrowserSettingsThread
implements StateMachineInterface {
    private static final Object DUPELOCK = new Object();
    private boolean aborted = false;
    private PluginForHost currentPlugin = null;
    private DownloadLink downloadLink;
    private LinkStatus linkStatus;
    private Account account = null;
    private SingleDownloadControllerHandler handler = null;
    private StateMachine stateMachine;
    private StateMonitor stateMonitor;
    private IOPermission ioP = null;
    private DownloadSpeedManager connectionHandler = null;
    public static final State IDLE_STATE = new State("IDLE");
    public static final State RUNNING_STATE = new State("RUNNING");
    public static final State FINAL_STATE = new State("FINAL_STATE");

    public DownloadSpeedManager getConnectionHandler() {
        return this.connectionHandler;
    }

    public SingleDownloadControllerHandler getHandler() {
        return this.handler;
    }

    public void setHandler(SingleDownloadControllerHandler singleDownloadControllerHandler) {
        this.handler = singleDownloadControllerHandler;
    }

    public SingleDownloadController(DownloadLink downloadLink, Account account) {
        this(downloadLink, account, null, null);
    }

    public SingleDownloadController(DownloadLink downloadLink, Account account, DownloadSpeedManager downloadSpeedManager) {
        this(downloadLink, account, null, downloadSpeedManager);
    }

    public SingleDownloadController(DownloadLink downloadLink, Account account, ProxyInfo proxyInfo, DownloadSpeedManager downloadSpeedManager) {
        super("Download: " + downloadLink.getName() + "_" + downloadLink.getHost());
        this.connectionHandler = downloadSpeedManager;
        this.stateMachine = new StateMachine(this, IDLE_STATE, FINAL_STATE);
        this.downloadLink = downloadLink;
        this.linkStatus = this.downloadLink.getLinkStatus();
        this.linkStatus.setActive(true);
        this.setPriority(1);
        this.downloadLink.setDownloadLinkController(this);
        this.account = account;
        this.setCurrentProxy(proxyInfo);
    }

    public SingleDownloadController abortDownload() {
        if (this.aborted) {
            return this;
        }
        if (!this.downloadLink.getLinkStatus().isPluginActive()) {
            return this;
        }
        this.aborted = true;
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (SingleDownloadController.this.downloadLink.getLinkStatus().isPluginActive()) {
                    DownloadInterface downloadInterface = SingleDownloadController.this.downloadLink.getDownloadInstance();
                    if (downloadInterface != null && SingleDownloadController.this.downloadLink.getLinkStatus().hasStatus(1024)) {
                        downloadInterface.stopDownload();
                        break;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Log.exception(interruptedException);
                    }
                }
            }
        };
        thread.setDaemon(true);
        thread.setName("Abort: " + this.downloadLink.getName() + "_" + this.downloadLink.getHost());
        thread.start();
        this.interrupt();
        return this;
    }

    public DownloadLink getDownloadLink() {
        return this.downloadLink;
    }

    private void handlePlugin() {
        try {
            this.linkStatus.setStatusText(_JDT._.gui_download_create_connection());
            this.currentPlugin.init();
            if (this.downloadLink.getLinkStatus().getRetryCount() <= this.currentPlugin.getMaxRetries()) {
                try {
                    try {
                        this.setContextClassLoader(this.currentPlugin.getLazyP().getClassLoader());
                        this.currentPlugin.handle(this.downloadLink, this.account);
                    }
                    catch (Browser.BrowserException browserException) {
                        if (browserException.getException() != null) {
                            throw browserException.getException();
                        }
                        throw browserException;
                    }
                }
                catch (PluginException pluginException) {
                    pluginException.fillLinkStatus(this.downloadLink.getLinkStatus());
                    if (pluginException.getLinkStatus() == 0x400000) {
                        this.logger.info(JDLogger.getStackTrace(pluginException));
                    }
                    this.logger.info(this.downloadLink.getLinkStatus().getLongErrorMessage());
                }
                catch (UnknownHostException unknownHostException) {
                    this.linkStatus.addStatus(2048);
                    this.linkStatus.setErrorMessage(_JDT._.plugins_errors_nointernetconn());
                    this.linkStatus.setValue(JsonConfig.create(GeneralSettings.class).getNetworkIssuesTimeout());
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    this.linkStatus.addStatus(2048);
                    this.linkStatus.setErrorMessage(_JDT._.plugins_errors_hosteroffline());
                    this.linkStatus.setValue(JsonConfig.create(GeneralSettings.class).getNetworkIssuesTimeout());
                }
                catch (SocketException socketException) {
                    this.linkStatus.addStatus(2048);
                    this.linkStatus.setErrorMessage(_JDT._.plugins_errors_disconnect());
                    this.linkStatus.setValue(JsonConfig.create(GeneralSettings.class).getNetworkIssuesTimeout());
                }
                catch (IOException iOException) {
                    this.linkStatus.addStatus(2048);
                    this.linkStatus.setErrorMessage(_JDT._.plugins_errors_hosterproblem());
                    this.linkStatus.setValue(600000L);
                }
                catch (InterruptedException interruptedException) {
                    long l = this.downloadLink.getLivePlugin() == null ? -1L : this.downloadLink.getLivePlugin().getVersion();
                    this.logger.finest("Hoster Plugin Version: " + l);
                    this.linkStatus.addStatus(0x400000);
                    this.linkStatus.setErrorMessage(_JDT._.plugins_errors_error() + Exceptions.getStackTrace(interruptedException));
                }
                catch (Throwable throwable) {
                    this.logger.finest("Hoster Plugin Version: " + this.downloadLink.getLivePlugin().getVersion());
                    JDLogger.exception(throwable);
                    this.linkStatus.addStatus(0x400000);
                    this.linkStatus.setErrorMessage(_JDT._.plugins_errors_error() + Exceptions.getStackTrace(throwable));
                }
            } else {
                this.downloadLink.getLinkStatus().addStatus(0x400000);
                this.downloadLink.getLinkStatus().setErrorMessage("Download failed!");
            }
            if (this.isAborted() && !this.linkStatus.isFinished()) {
                this.linkStatus.setErrorMessage(null);
                this.linkStatus.setStatus(1);
                return;
            }
            if (this.linkStatus.isFailed()) {
                this.logger.warning("\r\nError occured- " + this.downloadLink.getLinkStatus());
            }
            if (this.handler != null && this.handler.handleDownloadLink(this.downloadLink, this.account)) {
                return;
            }
            switch (this.linkStatus.getLatestStatus()) {
                case 0x200000: {
                    this.onErrorLocalIO(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 16: {
                    this.onErrorIPWaittime(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 2048: {
                    this.onErrorDownloadTemporarilyUnavailable(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 4096: {
                    this.onErrorHostTemporarilyUnavailable(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 32: {
                    this.onErrorFileNotFound(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 524288: {
                    this.onErrorLinkBlock(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 131072: {
                    this.onErrorFatal(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 8: {
                    this.onErrorCaptcha(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 256: {
                    this.onErrorPremium(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 512: {
                    this.onErrorIncomplete(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 8192: {
                    this.onErrorFileExists(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 16384: {
                    this.onErrorChunkloadFailed(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 0x400000: {
                    this.onErrorPluginDefect(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 32768: 
                case 0x100000: {
                    this.onErrorNoConnection(this.downloadLink, this.currentPlugin);
                    break;
                }
                default: {
                    if (this.linkStatus.hasStatus(2)) {
                        this.logger.finest("\r\nFinished- " + this.downloadLink.getLinkStatus());
                        this.logger.info("\r\nFinished- " + this.downloadLink.getFileOutput());
                        this.onDownloadFinishedSuccessFull(this.downloadLink);
                        break;
                    }
                    this.retry(this.downloadLink, this.currentPlugin);
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            this.logger.severe("Error in Plugin Version: " + this.downloadLink.getLivePlugin().getVersion());
            JDLogger.exception(throwable);
        }
    }

    private void onErrorLinkBlock(DownloadLink downloadLink, PluginForHost pluginForHost) {
        if (this.handler != null && this.handler.handleDownloadLink(downloadLink, this.account)) {
            return;
        }
        LinkStatus linkStatus = downloadLink.getLinkStatus();
        if (linkStatus.hasStatus(8192)) {
            this.onErrorFileExists(downloadLink, pluginForHost);
        } else {
            linkStatus.resetWaitTime();
            downloadLink.setEnabled(false);
        }
    }

    private void onErrorPluginDefect(DownloadLink downloadLink, PluginForHost pluginForHost) {
        long l = this.downloadLink.getLivePlugin() == null ? -1L : this.downloadLink.getLivePlugin().getVersion();
        this.logger.warning("The Plugin for " + this.currentPlugin.getHost() + " seems to be out of date(rev" + l + "). Please inform the Support-team http://jdownloader.org/support.");
        if (downloadLink.getLinkStatus().getErrorMessage() != null) {
            this.logger.warning(downloadLink.getLinkStatus().getErrorMessage());
        }
        try {
            this.logger.finest(pluginForHost.getBrowser().getRequest().getHttpConnection() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.logger.finest(pluginForHost.getBrowser() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = downloadLink.getLinkStatus().getErrorMessage();
        downloadLink.getLinkStatus().setErrorMessage(_JDT._.controller_status_plugindefective() + (string == null ? "" : " " + string));
    }

    public boolean isAborted() {
        return this.aborted;
    }

    private void onDownloadFinishedSuccessFull(DownloadLink downloadLink) {
        if (JsonConfig.create(GeneralSettings.class).getIfFileExistsAction() == IfFileExistsAction.SKIP_FILE) {
            ArrayList<DownloadLink> arrayList = DownloadController.getInstance().getAllDownloadLinks();
            for (DownloadLink downloadLink2 : arrayList) {
                if (downloadLink == downloadLink2 || !downloadLink.getFileOutput().equals(downloadLink2.getFileOutput())) continue;
                downloadLink2.getLinkStatus().addStatus(8192);
                downloadLink2.getLinkStatus().setErrorMessage(_JDT._.controller_status_fileexists_othersource(downloadLink.getHost()));
                downloadLink2.setEnabled(false);
            }
        }
    }

    private void onErrorCaptcha(DownloadLink downloadLink, PluginForHost pluginForHost) {
        this.retry(downloadLink, pluginForHost);
    }

    private void retry(DownloadLink downloadLink, PluginForHost pluginForHost) {
        int n;
        if (downloadLink.getLinkStatus().getValue() > 0L) {
            downloadLink.getLinkStatus().setStatusText(null);
        }
        if ((n = downloadLink.getLinkStatus().getRetryCount()) <= pluginForHost.getMaxRetries()) {
            downloadLink.getLinkStatus().reset();
            downloadLink.getLinkStatus().setRetryCount(n + 1);
            downloadLink.getLinkStatus().setErrorMessage(null);
            try {
                pluginForHost.sleep(Math.max((int)downloadLink.getLinkStatus().getValue(), 2000), downloadLink);
            }
            catch (PluginException pluginException) {
                downloadLink.getLinkStatus().setStatusText(null);
                return;
            }
        } else {
            downloadLink.getLinkStatus().addStatus(0x400000);
        }
    }

    private void onErrorChunkloadFailed(DownloadLink downloadLink, PluginForHost pluginForHost) {
        LinkStatus linkStatus = downloadLink.getLinkStatus();
        if (linkStatus.getErrorMessage() == null) {
            linkStatus.setErrorMessage(_JDT._.plugins_error_downloadfailed());
        }
        if (linkStatus.getValue() != 0x8000000L) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            this.retry(downloadLink, pluginForHost);
        }
    }

    private void onErrorFatal(DownloadLink downloadLink, PluginForHost pluginForHost) {
    }

    private void onErrorFileExists(DownloadLink downloadLink, PluginForHost pluginForHost) {
        IfFileExistsAction ifFileExistsAction;
        LinkStatus linkStatus = downloadLink.getLinkStatus();
        String[] stringArray = new String[]{_JDT._.system_download_triggerfileexists_overwrite(), _JDT._.system_download_triggerfileexists_skip(), _JDT._.system_download_triggerfileexists_rename()};
        IfFileExistsAction ifFileExistsAction2 = ifFileExistsAction = JsonConfig.create(GeneralSettings.class).getIfFileExistsAction();
        switch (ifFileExistsAction2) {
            default: 
        }
        switch (ifFileExistsAction2) {
            case SKIP_FILE: {
                linkStatus.setErrorMessage(_JDT._.controller_status_fileexists_skip());
                downloadLink.setEnabled(false);
                break;
            }
            case AUTO_RENAME: {
                linkStatus.reset();
                File file = new File(downloadLink.getFileOutput());
                String string = file.getName();
                String string2 = JDIO.getFileExtension(file);
                String string3 = string.substring(0, string.length() - string2.length() - 1);
                int n = 2;
                try {
                    String[] stringArray2 = new Regex(string3, "(.*)_(\\d+)").getRow(0);
                    n = Integer.parseInt(stringArray2[1]) + 1;
                    downloadLink.forceFileName(string3 + "_" + n + "." + string2);
                    while (new File(downloadLink.getFileOutput()).exists()) {
                        downloadLink.forceFileName(string3 + "_" + ++n + "." + string2);
                    }
                    break;
                }
                catch (Exception exception) {
                    n = 2;
                    downloadLink.forceFileName(string3 + "_" + n + "." + string2);
                    break;
                }
            }
            default: {
                if (new File(downloadLink.getFileOutput()).delete()) {
                    linkStatus.reset();
                    break;
                }
                linkStatus.addStatus(131072);
                linkStatus.setErrorMessage(_JDT._.controller_status_fileexists_overwritefailed() + downloadLink.getFileOutput());
            }
        }
    }

    private void onErrorFileNotFound(DownloadLink downloadLink, PluginForHost pluginForHost) {
        this.logger.severe("File not found :" + downloadLink.getDownloadURL());
        downloadLink.setAvailable(false);
        downloadLink.setEnabled(false);
    }

    private void onErrorIncomplete(DownloadLink downloadLink, PluginForHost pluginForHost) {
        this.retry(downloadLink, pluginForHost);
    }

    private void onErrorNoConnection(DownloadLink downloadLink, PluginForHost pluginForHost) {
        LinkStatus linkStatus = downloadLink.getLinkStatus();
        this.logger.severe("Error occurred: No Server connection");
        long l = JsonConfig.create(GeneralSettings.class).getWaittimeOnConnectionLoss();
        linkStatus.addStatus(2048);
        linkStatus.setWaitTime(l);
        if (linkStatus.getErrorMessage() == null) {
            linkStatus.setErrorMessage(_JDT._.controller_status_connectionproblems());
        }
    }

    private void onErrorPremium(DownloadLink downloadLink, PluginForHost pluginForHost) {
        LinkStatus linkStatus = downloadLink.getLinkStatus();
        linkStatus.reset();
    }

    private void onErrorLocalIO(DownloadLink downloadLink, PluginForHost pluginForHost) {
        LinkStatus linkStatus = downloadLink.getLinkStatus();
        linkStatus.setWaitTime(1800000L);
        downloadLink.setEnabled(false);
    }

    private void onErrorDownloadTemporarilyUnavailable(DownloadLink downloadLink, PluginForHost pluginForHost) {
        this.logger.warning("Error occurred: Temporarily unavailable: Please wait " + downloadLink.getLinkStatus().getValue() + " ms for a retry");
        LinkStatus linkStatus = downloadLink.getLinkStatus();
        if (linkStatus.getErrorMessage() == null) {
            linkStatus.setErrorMessage(_JDT._.controller_status_tempunavailable());
        }
        if (linkStatus.getValue() > 0L) {
            linkStatus.setWaitTime(linkStatus.getValue());
        } else if (linkStatus.getValue() == 0L) {
            linkStatus.setWaitTime(1800000L);
        } else {
            linkStatus.resetWaitTime();
            downloadLink.setEnabled(false);
        }
        if (linkStatus.getValue() >= 0L) {
            downloadLink.getLinkStatus().setRetryCount(downloadLink.getLinkStatus().getRetryCount() + 1);
        }
    }

    private void onErrorHostTemporarilyUnavailable(DownloadLink downloadLink, PluginForHost pluginForHost) {
        LinkStatus linkStatus = downloadLink.getLinkStatus();
        long l = downloadLink.getLinkStatus().getValue();
        if (l <= 0L) {
            this.logger.severe(_JDT._.plugins_errors_pluginerror());
            l = 3600000L;
        }
        this.logger.warning("Error occurred: Download from this host is currently not possible: Please wait " + l + " ms for a retry");
        linkStatus.setWaitTime(l);
        HTTPProxy hTTPProxy = this.getCurrentProxy();
        if (hTTPProxy != null && hTTPProxy instanceof ProxyInfo) {
            ((ProxyInfo)hTTPProxy).setHostBlockedTimeout(downloadLink, l);
        }
    }

    private void onErrorIPWaittime(DownloadLink downloadLink, PluginForHost pluginForHost) {
        LinkStatus linkStatus = downloadLink.getLinkStatus();
        long l = downloadLink.getLinkStatus().getValue();
        if (l <= 0L) {
            this.logger.severe(_JDT._.plugins_errors_pluginerror());
            l = 3600000L;
        }
        linkStatus.setWaitTime(l);
        linkStatus.setStatusText(null);
        HTTPProxy hTTPProxy = this.getCurrentProxy();
        if (hTTPProxy != null && hTTPProxy instanceof ProxyInfo) {
            ((ProxyInfo)hTTPProxy).setHostIPBlockTimeout(downloadLink, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block24: {
            JDPluginLogger jDPluginLogger = null;
            try {
                this.stateMachine.setStatus(RUNNING_STATE);
                this.linkStatus.setStatusText(null);
                this.linkStatus.setErrorMessage(null);
                this.linkStatus.resetWaitTime();
                this.downloadLink.setLivePlugin(this.downloadLink.getDefaultPlugin().getNewInstance());
                this.currentPlugin = this.downloadLink.getLivePlugin();
                this.currentPlugin.setIOPermission(this.ioP);
                jDPluginLogger = new JDPluginLogger(this.downloadLink.getHost() + ":Download:" + this.downloadLink.getName());
                this.currentPlugin.setLogger(jDPluginLogger);
                super.setLogger(jDPluginLogger);
                this.currentPlugin.setBrowser(new Browser());
                if (this.currentPlugin == null) break block24;
                if (this.downloadLink.getDownloadURL() == null) {
                    this.downloadLink.getLinkStatus().setStatusText(_JDT._.controller_status_containererror());
                    this.downloadLink.getLinkStatus().setErrorMessage(_JDT._.controller_status_containererror());
                    this.downloadLink.setEnabled(false);
                    return;
                }
                Object object = DUPELOCK;
                synchronized (object) {
                    block25: {
                        if (!DownloadInterface.preDownloadCheckFailed(this.downloadLink)) break block25;
                        this.onErrorLinkBlock(this.downloadLink, this.currentPlugin);
                        return;
                    }
                    this.linkStatus.setInProgress(true);
                }
                this.handlePlugin();
                if (this.isAborted() && !this.linkStatus.isFinished()) {
                    jDPluginLogger.clear();
                    jDPluginLogger.info("\r\nDownload stopped- " + this.downloadLink.getName());
                } else if (this.linkStatus.isFinished()) {
                    jDPluginLogger.clear();
                    jDPluginLogger.finest("\r\nFinished- " + this.downloadLink.getLinkStatus());
                    jDPluginLogger.info("\r\nFinished- " + this.downloadLink.getName() + "->" + this.downloadLink.getFileOutput());
                    FileCreationManager.getInstance().getEventSender().fireEvent(new FileCreationEvent(this, FileCreationEvent.Type.NEW_FILES, new File[]{new File(this.downloadLink.getFileOutput())}));
                }
                jDPluginLogger.logInto(JDLogger.getLogger());
            }
            finally {
                if (jDPluginLogger != null) {
                    jDPluginLogger.clear();
                }
                try {
                    this.linkStatus.setInProgress(false);
                    this.downloadLink.setDownloadLinkController(null);
                    this.downloadLink.setDownloadInstance(null);
                    if (this.currentPlugin != null) {
                        this.currentPlugin.clean();
                        this.currentPlugin.setBrowser(null);
                        this.currentPlugin.getLogger().clear();
                        this.currentPlugin.setDownloadLink(null);
                        this.currentPlugin = null;
                    }
                    this.downloadLink.setLivePlugin(null);
                }
                finally {
                    this.linkStatus.setActive(false);
                    this.stateMachine.setStatus(FINAL_STATE);
                }
            }
        }
    }

    @Override
    public void setLogger(Logger logger) {
    }

    @Override
    public StateMachine getStateMachine() {
        return this.stateMachine;
    }

    public void setIOPermission(IOPermission iOPermission) {
        this.ioP = iOPermission;
    }

    static {
        IDLE_STATE.addChildren(RUNNING_STATE);
        RUNNING_STATE.addChildren(FINAL_STATE);
    }
}

