/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.linkcollector;

import java.io.File;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import jd.controlling.IOEQ;
import jd.controlling.JDLogger;
import jd.controlling.linkchecker.LinkChecker;
import jd.controlling.linkchecker.LinkCheckerHandler;
import jd.controlling.linkcollector.CrawledLinkStorable;
import jd.controlling.linkcollector.CrawledPackageStorable;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkCollectorCrawler;
import jd.controlling.linkcollector.LinkCollectorEvent;
import jd.controlling.linkcollector.LinkCollectorEventSender;
import jd.controlling.linkcollector.LinkCollectorListener;
import jd.controlling.linkcollector.LinknameCleaner;
import jd.controlling.linkcollector.OfflineCrawledPackage;
import jd.controlling.linkcollector.PackagizerInterface;
import jd.controlling.linkcollector.PermanentOfflinePackage;
import jd.controlling.linkcollector.VariousCrawledPackage;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.linkcrawler.LinkCrawler;
import jd.controlling.linkcrawler.LinkCrawlerFilter;
import jd.controlling.linkcrawler.LinkCrawlerHandler;
import jd.controlling.linkcrawler.PackageInfo;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.controlling.packagecontroller.PackageController;
import jd.parser.Regex;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.PluginForHost;
import org.appwork.exceptions.WTFException;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.shutdown.ShutdownVetoException;
import org.appwork.shutdown.ShutdownVetoListener;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.queue.Queue;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.formatter.HexFormatter;
import org.appwork.utils.logging.Log;
import org.appwork.utils.zip.ZipIOReader;
import org.appwork.utils.zip.ZipIOWriter;
import org.jdownloader.controlling.UniqueSessionID;
import org.jdownloader.controlling.filter.LinkFilterController;
import org.jdownloader.controlling.packagizer.PackagizerController;
import org.jdownloader.plugins.controller.host.HostPluginController;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;
import org.jdownloader.settings.staticreferences.CFG_LINKCOLLECTOR;
import org.jdownloader.translate._JDT;

public class LinkCollector
extends PackageController<CrawledPackage, CrawledLink>
implements LinkCheckerHandler<CrawledLink>,
LinkCrawlerHandler {
    private transient LinkCollectorEventSender eventsender = new LinkCollectorEventSender();
    private static LinkCollector INSTANCE = new LinkCollector();
    private LinkChecker<CrawledLink> linkChecker = null;
    private HashSet<String> dupeCheckMap = new HashSet();
    private HashMap<String, CrawledPackage> packageMap = new HashMap();
    private ArrayList<CrawledLink> filteredStuff = new ArrayList();
    private LinkCrawlerFilter crawlerFilter = null;
    private DelayedRunnable asyncSaving = null;
    private boolean allowSave = false;
    private boolean allowLoad = true;
    private PackagizerInterface packagizer = null;
    protected OfflineCrawledPackage offlinePackage;
    protected VariousCrawledPackage variousPackage;
    protected PermanentOfflinePackage permanentofflinePackage;
    private HashMap<String, ArrayList<CrawledLink>> offlineMap = new HashMap();
    private HashMap<String, ArrayList<CrawledLink>> variousMap = new HashMap();

    public static LinkCollector getInstance() {
        return INSTANCE;
    }

    private LinkCollector() {
        ShutdownController.getInstance().addShutdownVetoListener(new ShutdownVetoListener(){

            @Override
            public void onShutdownVeto(ArrayList<ShutdownVetoException> arrayList) {
            }

            @Override
            public void onShutdownRequest(int n) throws ShutdownVetoException {
                if (n > 0) {
                    return;
                }
                if (LinkChecker.isChecking() || LinkCrawler.isCrawling()) {
                    // empty if block
                }
            }

            @Override
            public void onShutdown() {
            }
        });
        ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

            @Override
            public void run() {
                LinkCollector.this.abort();
                for (int i = 10; i > 0 && (LinkChecker.isChecking() || LinkCrawler.isCrawling()); --i) {
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
                IOEQ.getQueue().addWait(new QueueAction<Void, RuntimeException>(Queue.QueuePriority.HIGH){

                    @Override
                    protected Void run() throws RuntimeException {
                        LinkCollector.this.saveLinkCollectorLinks();
                        return null;
                    }
                });
            }

            @Override
            public String toString() {
                return "save linkcollector...";
            }
        });
        this.asyncSaving = new DelayedRunnable(IOEQ.TIMINGQUEUE, 5000L, 60000L){

            @Override
            public void delayedrun() {
                LinkCollector.this.saveLinkCollectorLinks();
            }
        };
        this.eventsender.addListener(new LinkCollectorListener(){

            @Override
            public void onLinkCollectorAbort(LinkCollectorEvent linkCollectorEvent) {
                LinkCollector.this.asyncSaving.run();
            }

            @Override
            public void onLinkCollectorFilteredLinksAvailable(LinkCollectorEvent linkCollectorEvent) {
                LinkCollector.this.asyncSaving.run();
            }

            @Override
            public void onLinkCollectorFilteredLinksEmpty(LinkCollectorEvent linkCollectorEvent) {
                LinkCollector.this.asyncSaving.run();
            }

            @Override
            public void onLinkCollectorDataRefresh(LinkCollectorEvent linkCollectorEvent) {
                LinkCollector.this.asyncSaving.run();
            }

            @Override
            public void onLinkCollectorStructureRefresh(LinkCollectorEvent linkCollectorEvent) {
                LinkCollector.this.asyncSaving.run();
            }

            @Override
            public void onLinkCollectorLinksRemoved(LinkCollectorEvent linkCollectorEvent) {
                LinkCollector.this.asyncSaving.run();
            }

            @Override
            public void onLinkCollectorLinkAdded(LinkCollectorEvent linkCollectorEvent, CrawledLink crawledLink) {
            }
        });
    }

    public LinkCollectorEventSender getEventsender() {
        return this.eventsender;
    }

    @Override
    protected void _controllerPackageNodeAdded(CrawledPackage crawledPackage, Queue.QueuePriority queuePriority) {
        this.eventsender.fireEvent(new LinkCollectorEvent(this, LinkCollectorEvent.TYPE.REFRESH_STRUCTURE, queuePriority));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _controllerPackageNodeRemoved(CrawledPackage crawledPackage, Queue.QueuePriority queuePriority) {
        String string = this.getPackageMapID(crawledPackage);
        if (string != null) {
            this.packageMap.remove(string);
        }
        this.eventsender.fireEvent(new LinkCollectorEvent(this, LinkCollectorEvent.TYPE.REMOVE_CONTENT, crawledPackage, queuePriority));
        ArrayList<CrawledLink> arrayList = null;
        CrawledPackage crawledPackage2 = crawledPackage;
        synchronized (crawledPackage2) {
            arrayList = new ArrayList<CrawledLink>(crawledPackage.getChildren());
        }
        this.cleanupMaps(arrayList);
    }

    private String getPackageMapID(CrawledPackage crawledPackage) {
        for (Map.Entry<String, CrawledPackage> entry : this.packageMap.entrySet()) {
            if (entry.getValue() != crawledPackage) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    protected void _controllerParentlessLinks(List<CrawledLink> list, Queue.QueuePriority queuePriority) {
        this.eventsender.fireEvent(new LinkCollectorEvent(this, LinkCollectorEvent.TYPE.REMOVE_CONTENT, list, queuePriority));
        this.cleanupMaps(list);
    }

    @Override
    protected void _controllerStructureChanged(Queue.QueuePriority queuePriority) {
        this.eventsender.fireEvent(new LinkCollectorEvent(this, LinkCollectorEvent.TYPE.REFRESH_STRUCTURE, queuePriority));
    }

    public void abort() {
        this.eventsender.fireEvent(new LinkCollectorEvent(this, LinkCollectorEvent.TYPE.ABORT));
        if (this.linkChecker != null) {
            this.linkChecker.stopChecking();
        }
    }

    private void addCrawledLink(final CrawledLink crawledLink) {
        IOEQ.getQueue().add(new QueueAction<Void, RuntimeException>(){

            public void newPackage(ArrayList<CrawledLink> arrayList, String string, String string2, String string3) {
                ArrayList arrayList2;
                CrawledPackage crawledPackage = new CrawledPackage();
                crawledPackage.setCreated(System.currentTimeMillis());
                crawledPackage.setName(string);
                if (string2 != null) {
                    crawledPackage.setDownloadFolder(string2);
                }
                LinkCollector.this.packageMap.put(string3, crawledPackage);
                if (arrayList != null && arrayList.size() > 0) {
                    LinkCollector.this.addmoveChildren(crawledPackage, arrayList, -1);
                }
                if ((arrayList2 = (ArrayList)LinkCollector.this.offlineMap.remove(string3)) != null && arrayList2.size() > 0) {
                    LinkCollector.this.addmoveChildren(crawledPackage, arrayList2, -1);
                }
                if ((arrayList2 = (ArrayList)LinkCollector.this.variousMap.remove(string3)) != null && arrayList2.size() > 0) {
                    LinkCollector.this.addmoveChildren(crawledPackage, arrayList2, -1);
                }
            }

            @Override
            protected Void run() throws RuntimeException {
                try {
                    if (!LinkCollector.this.dupeCheckMap.add(crawledLink.getLinkID())) {
                        return null;
                    }
                    PackageInfo packageInfo = crawledLink.getDesiredPackageInfo();
                    UniqueSessionID uniqueSessionID = null;
                    String string = null;
                    String string2 = null;
                    String string3 = null;
                    boolean bl = false;
                    if (packageInfo != null) {
                        string = packageInfo.getName();
                        uniqueSessionID = packageInfo.getUniqueId();
                        if (uniqueSessionID != null) {
                            string2 = packageInfo.getUniqueId().toString();
                        }
                        string3 = packageInfo.getDestinationFolder();
                    }
                    if (string == null) {
                        string = LinknameCleaner.cleanFileName(crawledLink.getName());
                        if (!bl || (string2 = null) != null) {
                            // empty if block
                        }
                    }
                    String string4 = string2 + "_" + string + "_" + string3;
                    CrawledPackage crawledPackage = (CrawledPackage)LinkCollector.this.packageMap.get(string4);
                    if (crawledPackage == null) {
                        if (LinkCrawler.PERMANENT_OFFLINE_ID == uniqueSessionID) {
                            LinkCollector.this.getPermanentOfflineCrawledPackage();
                            ArrayList<CrawledLink> arrayList = new ArrayList<CrawledLink>(1);
                            arrayList.add(crawledLink);
                            LinkCollector.this.addmoveChildren(LinkCollector.this.getPermanentOfflineCrawledPackage(), arrayList, -1);
                        } else {
                            ArrayList<CrawledLink> arrayList = new ArrayList<CrawledLink>(1);
                            arrayList.add(crawledLink);
                            this.newPackage(arrayList, string, string3, string4);
                        }
                    } else {
                        ArrayList<CrawledLink> arrayList = new ArrayList<CrawledLink>(1);
                        arrayList.add(crawledLink);
                        LinkCollector.this.addmoveChildren(crawledPackage, arrayList, -1);
                    }
                    LinkCollector.this.eventsender.fireEvent(new LinkCollectorEvent(LinkCollector.this, LinkCollectorEvent.TYPE.ADDED_LINK, crawledLink, Queue.QueuePriority.NORM));
                    return null;
                }
                catch (RuntimeException runtimeException) {
                    LinkCollector.this.dupeCheckMap.remove(crawledLink.getLinkID());
                    throw runtimeException;
                }
            }
        });
    }

    private ArrayList<CrawledLink> getIdentifiedMap(String string, HashMap<String, ArrayList<CrawledLink>> hashMap) {
        ArrayList<CrawledLink> arrayList = hashMap.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            hashMap.put(string, arrayList);
        }
        return arrayList;
    }

    private PermanentOfflinePackage getPermanentOfflineCrawledPackage() {
        if (this.permanentofflinePackage != null) {
            return this.permanentofflinePackage;
        }
        this.permanentofflinePackage = new PermanentOfflinePackage();
        this.permanentofflinePackage.setExpanded(true);
        this.permanentofflinePackage.setName("_GUI._.Permanently_Offline_Package()");
        return this.permanentofflinePackage;
    }

    private VariousCrawledPackage getVariousCrawledPackage() {
        if (this.variousPackage != null) {
            return this.variousPackage;
        }
        this.variousPackage = new VariousCrawledPackage();
        this.variousPackage.setExpanded(true);
        this.variousPackage.setName(_JDT._.LinkCollector_addCrawledLink_variouspackage());
        return this.variousPackage;
    }

    private OfflineCrawledPackage getOfflineCrawledPackage() {
        if (this.offlinePackage != null) {
            return this.offlinePackage;
        }
        this.offlinePackage = new OfflineCrawledPackage();
        this.offlinePackage.setExpanded(true);
        this.offlinePackage.setName(_JDT._.LinkCollector_addCrawledLink_offlinepackage());
        return this.offlinePackage;
    }

    public LinkCrawler addCrawlerJob(ArrayList<CrawledLink> arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            throw new IllegalArgumentException("no links");
        }
        this.lazyInit();
        LinkCollectorCrawler linkCollectorCrawler = new LinkCollectorCrawler(){

            @Override
            protected void generalCrawledLinkModifier(CrawledLink crawledLink) {
                LinkCollectingJob linkCollectingJob = crawledLink.getSourceJob();
                if (linkCollectingJob != null) {
                    if (crawledLink.getDownloadLink() != null) {
                        if (linkCollectingJob.getCustomSourceUrl() != null) {
                            crawledLink.getDownloadLink().setBrowserUrl(linkCollectingJob.getCustomSourceUrl());
                        }
                        if (linkCollectingJob.getCustomComment() != null) {
                            crawledLink.getDownloadLink().setComment(linkCollectingJob.getCustomComment());
                        }
                    }
                    if (linkCollectingJob.getOutputFolder() != null && (crawledLink.getDesiredPackageInfo() == null || crawledLink.getDesiredPackageInfo().getDestinationFolder() == null)) {
                        if (crawledLink.getDesiredPackageInfo() == null) {
                            crawledLink.setDesiredPackageInfo(new PackageInfo());
                        }
                        crawledLink.getDesiredPackageInfo().setDestinationFolder(linkCollectingJob.getOutputFolder().getAbsolutePath());
                    }
                    if (!StringUtils.isEmpty(linkCollectingJob.getPackageName()) && (crawledLink.getDesiredPackageInfo() == null || StringUtils.isEmpty(crawledLink.getDesiredPackageInfo().getName()))) {
                        if (crawledLink.getDesiredPackageInfo() == null) {
                            crawledLink.setDesiredPackageInfo(new PackageInfo());
                        }
                        crawledLink.getDesiredPackageInfo().setName(linkCollectingJob.getPackageName());
                    }
                    if (!StringUtils.isEmpty(linkCollectingJob.getExtractPassword())) {
                        if (crawledLink.getDesiredPackageInfo() == null) {
                            crawledLink.setDesiredPackageInfo(new PackageInfo());
                        }
                        crawledLink.getDesiredPackageInfo().getExtractionPasswords().add(linkCollectingJob.getExtractPassword());
                    }
                }
            }
        };
        this.eventsender.addListener(linkCollectorCrawler, true);
        linkCollectorCrawler.setFilter(this.crawlerFilter);
        linkCollectorCrawler.setHandler(this);
        linkCollectorCrawler.crawl(new ArrayList<CrawledLink>(arrayList));
        return linkCollectorCrawler;
    }

    public LinkCrawler addCrawlerJob(final LinkCollectingJob linkCollectingJob) {
        if (linkCollectingJob == null) {
            throw new IllegalArgumentException("job is null");
        }
        this.lazyInit();
        LinkCollectorCrawler linkCollectorCrawler = new LinkCollectorCrawler(){

            @Override
            protected void generalCrawledLinkModifier(CrawledLink crawledLink) {
                if (crawledLink.getDownloadLink() != null) {
                    if (linkCollectingJob.getCustomSourceUrl() != null) {
                        crawledLink.getDownloadLink().setBrowserUrl(linkCollectingJob.getCustomSourceUrl());
                    }
                    if (linkCollectingJob.getCustomComment() != null) {
                        crawledLink.getDownloadLink().setComment(linkCollectingJob.getCustomComment());
                    }
                }
                if (linkCollectingJob.getOutputFolder() != null && (crawledLink.getDesiredPackageInfo() == null || crawledLink.getDesiredPackageInfo().getDestinationFolder() == null)) {
                    if (crawledLink.getDesiredPackageInfo() == null) {
                        crawledLink.setDesiredPackageInfo(new PackageInfo());
                    }
                    crawledLink.getDesiredPackageInfo().setDestinationFolder(linkCollectingJob.getOutputFolder().getAbsolutePath());
                }
                if (!StringUtils.isEmpty(linkCollectingJob.getPackageName()) && (crawledLink.getDesiredPackageInfo() == null || StringUtils.isEmpty(crawledLink.getDesiredPackageInfo().getName()))) {
                    if (crawledLink.getDesiredPackageInfo() == null) {
                        crawledLink.setDesiredPackageInfo(new PackageInfo());
                    }
                    crawledLink.getDesiredPackageInfo().setName(linkCollectingJob.getPackageName());
                }
                if (!StringUtils.isEmpty(linkCollectingJob.getExtractPassword())) {
                    if (crawledLink.getDesiredPackageInfo() == null) {
                        crawledLink.setDesiredPackageInfo(new PackageInfo());
                    }
                    crawledLink.getDesiredPackageInfo().getExtractionPasswords().add(linkCollectingJob.getExtractPassword());
                }
            }
        };
        this.eventsender.addListener(linkCollectorCrawler, true);
        linkCollectorCrawler.setFilter(this.crawlerFilter);
        linkCollectorCrawler.setHandler(this);
        String string = linkCollectingJob.getText();
        linkCollectingJob.setText(null);
        linkCollectorCrawler.crawl(string, null, linkCollectingJob.isDeepAnalyse());
        return linkCollectorCrawler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFilteredStuff(CrawledLink crawledLink) {
        ArrayList<CrawledLink> arrayList = this.filteredStuff;
        synchronized (arrayList) {
            this.filteredStuff.add(crawledLink);
        }
        this.eventsender.fireEvent(new LinkCollectorEvent(this, LinkCollectorEvent.TYPE.FILTERED_AVAILABLE));
    }

    private void cleanupMaps(List<CrawledLink> list) {
        if (list == null) {
            return;
        }
        for (CrawledLink crawledLink : list) {
            this.dupeCheckMap.remove(crawledLink.getLinkID());
            this.removeFromMap(this.variousMap, crawledLink);
            this.removeFromMap(this.offlineMap, crawledLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        super.clear();
        ArrayList<CrawledLink> arrayList = this.filteredStuff;
        synchronized (arrayList) {
            this.filteredStuff.clear();
        }
        this.dupeCheckMap.clear();
        this.offlinePackage = null;
        this.variousPackage = null;
        this.permanentofflinePackage = null;
        this.variousMap.clear();
        this.offlineMap.clear();
        this.eventsender.fireEvent(new LinkCollectorEvent(this, LinkCollectorEvent.TYPE.FILTERED_EMPTY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FilePackage createFilePackage(CrawledPackage crawledPackage, ArrayList<CrawledLink> arrayList) {
        FilePackage filePackage = FilePackage.getInstance();
        filePackage.setName(crawledPackage.getName());
        filePackage.setDownloadDirectory(crawledPackage.getDownloadFolder());
        filePackage.setCreated(crawledPackage.getCreated());
        filePackage.setExpanded(crawledPackage.isExpanded());
        filePackage.setComment(crawledPackage.getComment());
        CrawledPackage crawledPackage2 = crawledPackage;
        synchronized (crawledPackage2) {
            ArrayList<DownloadLink> arrayList2 = new ArrayList<DownloadLink>(crawledPackage.getChildren().size());
            List<CrawledLink> list = crawledPackage.getChildren();
            if (arrayList != null && arrayList.size() > 0) {
                list = new ArrayList<CrawledLink>(arrayList);
            }
            for (CrawledLink crawledLink : list) {
                DownloadLink downloadLink = crawledLink.getDownloadLink();
                if (downloadLink == null) continue;
                if (crawledLink.isNameSet()) {
                    downloadLink.forceFileName(crawledLink.getName());
                }
                downloadLink.setEnabled(crawledLink.isEnabled());
                downloadLink.setNodeChangeListener(null);
                downloadLink.setCreated(crawledLink.getCreated());
                arrayList2.add(downloadLink);
                downloadLink.setParentNode(filePackage);
            }
            filePackage.getChildren().addAll(arrayList2);
        }
        return filePackage;
    }

    private String getCheckFileName() {
        return "check.info";
    }

    public LinkCrawlerFilter getCrawlerFilter() {
        return this.crawlerFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<CrawledLink> getFilteredStuff(boolean bl) {
        ArrayList<CrawledLink> arrayList = null;
        ArrayList<CrawledLink> arrayList2 = this.filteredStuff;
        synchronized (arrayList2) {
            arrayList = new ArrayList<CrawledLink>(this.filteredStuff);
            if (bl) {
                this.filteredStuff.clear();
            }
        }
        if (bl) {
            this.eventsender.fireEvent(new LinkCollectorEvent(this, LinkCollectorEvent.TYPE.FILTERED_EMPTY));
        }
        return arrayList;
    }

    public int getfilteredStuffSize() {
        return this.filteredStuff.size();
    }

    public LinkChecker<CrawledLink> getLinkChecker() {
        this.lazyInit();
        return this.linkChecker;
    }

    public PackagizerInterface getPackagizer() {
        return this.packagizer;
    }

    @Override
    public void handleFilteredLink(CrawledLink crawledLink) {
        this.addFilteredStuff(crawledLink);
    }

    @Override
    public void handleFinalLink(CrawledLink crawledLink) {
        if (CFG_LINKCOLLECTOR.DO_LINK_CHECK.isEnabled()) {
            this.linkChecker.check(crawledLink);
        } else {
            PackagizerInterface packagizerInterface = this.getPackagizer();
            if (packagizerInterface != null) {
                packagizerInterface.runByUrl(crawledLink);
            }
            this.addCrawledLink(crawledLink);
        }
    }

    public boolean isLoadAllowed() {
        return this.allowLoad;
    }

    public boolean isSaveAllowed() {
        return this.allowSave;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit() {
        if (this.linkChecker != null) {
            return;
        }
        LinkCollector linkCollector = this;
        synchronized (linkCollector) {
            if (this.linkChecker != null) {
                return;
            }
            this.linkChecker = new LinkChecker();
            this.linkChecker.setLinkCheckHandler(this);
            this.setCrawlerFilter(LinkFilterController.getInstance());
            this.setPackagizer(PackagizerController.getInstance());
        }
    }

    @Override
    public void linkCheckDone(CrawledLink crawledLink) {
        if (this.crawlerFilter.dropByFileProperties(crawledLink)) {
            this.addFilteredStuff(crawledLink);
        } else {
            PackagizerInterface packagizerInterface = this.getPackagizer();
            if (packagizerInterface != null) {
                packagizerInterface.runByFile(crawledLink);
            }
            this.addCrawledLink(crawledLink);
        }
    }

    public void refreshData() {
        this.eventsender.fireEvent(new LinkCollectorEvent(this, LinkCollectorEvent.TYPE.REFRESH_DATA));
    }

    public ArrayList<FilePackage> removeAndConvert(final ArrayList<CrawledLink> arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        return IOEQ.getQueue().addWait(new QueueAction<ArrayList<FilePackage>, RuntimeException>(){

            @Override
            protected ArrayList<FilePackage> run() throws RuntimeException {
                ArrayList<FilePackage> arrayList3 = new ArrayList<FilePackage>();
                HashMap<CrawledPackage, ArrayList<CrawledLink>> hashMap = new HashMap<CrawledPackage, ArrayList<CrawledLink>>();
                LinkCollector.this.cleanupMaps(arrayList);
                for (CrawledLink object : arrayList) {
                    CrawledPackage crawledPackage = object.getParentNode();
                    if (crawledPackage == null || crawledPackage.getControlledBy() != LinkCollector.this) {
                        Log.exception(new Throwable("not controlled by this packagecontroller"));
                        continue;
                    }
                    ArrayList<CrawledLink> arrayList2 = (ArrayList<CrawledLink>)hashMap.get(crawledPackage);
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<CrawledLink>();
                        hashMap.put(crawledPackage, arrayList2);
                    }
                    arrayList2.add(object);
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    LinkCollector.this.removeChildren((AbstractPackageNode)entry.getKey(), (List)entry.getValue(), true);
                    arrayList3.add(LinkCollector.this.createFilePackage((CrawledPackage)entry.getKey(), (ArrayList)entry.getValue()));
                }
                return arrayList3;
            }
        });
    }

    private void removeFromMap(HashMap<String, ArrayList<CrawledLink>> hashMap, CrawledLink crawledLink) {
        for (Map.Entry<String, ArrayList<CrawledLink>> entry : hashMap.entrySet()) {
            String string = entry.getKey();
            ArrayList<CrawledLink> arrayList = entry.getValue();
            if (arrayList == null || !arrayList.remove(crawledLink)) continue;
            if (arrayList.size() != 0) break;
            hashMap.remove(string);
            break;
        }
    }

    private String getIDFromMap(HashMap<String, ArrayList<CrawledLink>> hashMap, CrawledLink crawledLink) {
        for (Map.Entry<String, ArrayList<CrawledLink>> entry : hashMap.entrySet()) {
            String string = entry.getKey();
            ArrayList<CrawledLink> arrayList = entry.getValue();
            if (arrayList == null || !arrayList.contains(crawledLink)) continue;
            return string;
        }
        return null;
    }

    public synchronized void initLinkCollector() {
        if (!this.isLoadAllowed()) {
            return;
        }
        LinkedList<CrawledPackage> linkedList = null;
        final HashMap<CrawledPackage, CrawledPackageStorable> hashMap = new HashMap<CrawledPackage, CrawledPackageStorable>();
        try {
            linkedList = this.load(this.getLinkCollectorListFile(), hashMap);
        }
        catch (Throwable throwable) {
            Log.exception(throwable);
        }
        try {
            if (linkedList == null) {
                hashMap.clear();
                linkedList = this.load(new File(this.getLinkCollectorListFile().getAbsolutePath() + ".tmp"), hashMap);
            }
        }
        catch (Throwable throwable) {
            Log.exception(throwable);
        }
        if (linkedList == null) {
            hashMap.clear();
            linkedList = new LinkedList();
        }
        this.postInit(linkedList);
        final LinkedList<CrawledPackage> linkedList2 = linkedList;
        IOEQ.getQueue().add(new QueueAction<Void, RuntimeException>(Queue.QueuePriority.HIGH){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Void run() throws RuntimeException {
                if (LinkCollector.this.isLoadAllowed()) {
                    LinkCollector.this.writeLock();
                    try {
                        for (CrawledPackage crawledPackage : linkedList2) {
                            ArrayList arrayList;
                            String string;
                            for (CrawledLink crawledLink : crawledPackage.getChildren()) {
                                LinkCollector.this.dupeCheckMap.add(crawledLink.getLinkID());
                            }
                            crawledPackage.setControlledBy(LinkCollector.this);
                            CrawledPackageStorable crawledPackageStorable = (CrawledPackageStorable)hashMap.get(crawledPackage);
                            if (crawledPackageStorable == null) continue;
                            if (CrawledPackageStorable.TYPE.NORMAL.equals((Object)crawledPackageStorable._getType()) && crawledPackageStorable.getPackageID() != null) {
                                LinkCollector.this.packageMap.put(crawledPackageStorable.getPackageID(), crawledPackage);
                                continue;
                            }
                            if (CrawledPackageStorable.TYPE.VARIOUS.equals((Object)crawledPackageStorable._getType())) {
                                for (CrawledLinkStorable crawledLinkStorable : crawledPackageStorable.getLinks()) {
                                    string = crawledLinkStorable.getID();
                                    if (string == null) continue;
                                    arrayList = LinkCollector.this.getIdentifiedMap(string, LinkCollector.this.variousMap);
                                    arrayList.add(crawledLinkStorable._getCrawledLink());
                                }
                                continue;
                            }
                            if (!CrawledPackageStorable.TYPE.OFFLINE.equals((Object)crawledPackageStorable._getType())) continue;
                            for (CrawledLinkStorable crawledLinkStorable : crawledPackageStorable.getLinks()) {
                                string = crawledLinkStorable.getID();
                                if (string == null) continue;
                                arrayList = LinkCollector.this.getIdentifiedMap(string, LinkCollector.this.offlineMap);
                                arrayList.add(crawledLinkStorable._getCrawledLink());
                            }
                        }
                        LinkCollector.this.packages.addAll(0, linkedList2);
                    }
                    finally {
                        LinkCollector.this.setLoadAllowed(false);
                        LinkCollector.this.setSaveAllowed(true);
                        LinkCollector.this.writeUnlock();
                    }
                    LinkCollector.this.eventsender.fireEvent(new LinkCollectorEvent(LinkCollector.this, LinkCollectorEvent.TYPE.REFRESH_STRUCTURE));
                }
                return null;
            }
        });
    }

    private void postInit(LinkedList<CrawledPackage> linkedList) {
        if (linkedList == null || linkedList.size() == 0) {
            return;
        }
        Iterator iterator = linkedList.iterator();
        DownloadLink downloadLink = null;
        CrawledLink crawledLink = null;
        PluginForHost pluginForHost = null;
        while (iterator.hasNext()) {
            CrawledPackage crawledPackage = (CrawledPackage)iterator.next();
            if (crawledPackage.getChildren().size() == 0) {
                iterator.remove();
                continue;
            }
            Iterator<CrawledLink> iterator2 = crawledPackage.getChildren().iterator();
            while (iterator2.hasNext()) {
                crawledLink = iterator2.next();
                downloadLink = crawledLink.getDownloadLink();
                if (downloadLink == null) {
                    iterator2.remove();
                    continue;
                }
                try {
                    pluginForHost = null;
                    LazyHostPlugin lazyHostPlugin = HostPluginController.getInstance().get(downloadLink.getHost());
                    if (lazyHostPlugin != null) {
                        pluginForHost = (PluginForHost)lazyHostPlugin.getPrototype();
                    }
                }
                catch (Throwable throwable) {
                    JDLogger.exception(throwable);
                }
                if (pluginForHost == null) {
                    try {
                        for (LazyHostPlugin lazyHostPlugin : HostPluginController.getInstance().list()) {
                            if (!((PluginForHost)lazyHostPlugin.getPrototype()).rewriteHost(downloadLink)) continue;
                            pluginForHost = (PluginForHost)lazyHostPlugin.getPrototype();
                            break;
                        }
                        if (pluginForHost != null) {
                            Log.L.info("Plugin " + pluginForHost.getHost() + " now handles " + crawledLink.getName());
                        }
                    }
                    catch (Throwable throwable) {
                        Log.exception(throwable);
                    }
                }
                if (pluginForHost != null) {
                    downloadLink.setDefaultPlugin(pluginForHost);
                    continue;
                }
                Log.L.severe("Could not find plugin " + crawledLink.getHost() + " for " + crawledLink.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private LinkedList<CrawledPackage> load(File file, HashMap<CrawledPackage, CrawledPackageStorable> hashMap) {
        LinkedList linkedList;
        block40: {
            linkedList = null;
            if (file == null) break block40;
            ZipIOReader zipIOReader = null;
            try {
                void var10_20;
                Object object;
                int n;
                Object object3;
                Object object4;
                zipIOReader = new ZipIOReader(file);
                ZipEntry zipEntry = zipIOReader.getZipFile(this.getCheckFileName());
                String string = null;
                if (zipEntry != null) {
                    object4 = null;
                    try {
                        object4 = zipIOReader.getInputStream(zipEntry);
                        object3 = IO.readStream(1024, (InputStream)object4);
                        string = new String((byte[])object3, "UTF-8");
                        object3 = null;
                    }
                    finally {
                        try {
                            ((InputStream)object4).close();
                        }
                        catch (Throwable throwable) {}
                    }
                    zipEntry = null;
                }
                if (string != null) {
                    object4 = MessageDigest.getInstance("SHA1");
                    object3 = new byte[1024];
                    n = 0;
                    for (ZipEntry zipEntry2 : zipIOReader.getZipFiles()) {
                        if (!zipEntry2.getName().matches("^\\d+$")) continue;
                        ++n;
                        FilterInputStream filterInputStream = null;
                        try {
                            filterInputStream = new DigestInputStream(zipIOReader.getInputStream(zipEntry2), (MessageDigest)object4);
                            while (filterInputStream.read((byte[])object3) >= 0) {
                            }
                        }
                        finally {
                            try {
                                filterInputStream.close();
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    String i = HexFormatter.byteArrayToHex(((MessageDigest)object4).digest());
                    object = new Regex(string, "(\\d+)").getMatch(0);
                    String string2 = new Regex(string, ".*?:(\\d+)").getMatch(0);
                    String string3 = new Regex(string, ".*?:.*?:(.+)").getMatch(0);
                    boolean bl = string2 != null && Integer.parseInt(string2) == n;
                    boolean bl2 = string3 != null && string3.equalsIgnoreCase(i);
                    Log.L.info("LinkCollectorListVerify: TimeStamp(" + (String)object + ")|numberOfPackages(" + n + "):" + bl + "|hash:" + bl2);
                }
                object4 = new HashMap();
                object3 = zipIOReader.getZipFiles();
                n = ((byte[])object3).length;
                boolean iterator = false;
                while (var10_20 < n) {
                    object = object3[var10_20];
                    if (object.getName().matches("^\\d+$")) {
                        InputStream inputStream;
                        block39: {
                            int n2 = Integer.parseInt(object.getName());
                            InputStream inputStream2 = null;
                            try {
                                inputStream = zipIOReader.getInputStream((ZipEntry)object);
                                byte[] byArray = IO.readStream((int)object.getSize(), inputStream);
                                String string4 = new String(byArray, "UTF-8");
                                byArray = null;
                                CrawledPackageStorable crawledPackageStorable = JSonStorage.restoreFromString(string4, new TypeRef<CrawledPackageStorable>(){}, null);
                                string4 = null;
                                if (crawledPackageStorable == null) break block39;
                                ((HashMap)object4).put(n2, crawledPackageStorable._getCrawledPackage());
                                if (hashMap == null) break block39;
                                hashMap.put(crawledPackageStorable._getCrawledPackage(), crawledPackageStorable);
                            }
                            catch (Throwable throwable) {
                                try {
                                    inputStream2.close();
                                }
                                catch (Throwable throwable2) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                        }
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {}
                    }
                    ++var10_20;
                }
                object3 = new ArrayList(((HashMap)object4).keySet());
                Collections.sort(object3);
                ArrayList arrayList = new ArrayList(((ArrayList)object3).size());
                Iterator iterator2 = ((ArrayList)object3).iterator();
                while (iterator2.hasNext()) {
                    object = (Integer)iterator2.next();
                    arrayList.add(((HashMap)object4).get(object));
                }
                object4 = null;
                object3 = null;
                linkedList = new LinkedList(arrayList);
            }
            catch (Throwable throwable) {
                Log.exception(throwable);
            }
            finally {
                try {
                    zipIOReader.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return linkedList;
    }

    private void save(final ArrayList<CrawledPackage> arrayList, final File file) {
        IOEQ.getQueue().add(new QueueAction<Void, RuntimeException>(Queue.QueuePriority.HIGH){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            protected Void run() throws RuntimeException {
                if (arrayList == null) return null;
                if (file == null) return null;
                File file2 = new File(file.getAbsolutePath() + ".tmp");
                file2.getParentFile().mkdirs();
                file2.delete();
                ZipIOWriter zipIOWriter = null;
                int n = 0;
                String string = "%02d";
                if (arrayList.size() >= 10) {
                    string = String.format("%%0%dd", (int)Math.log10(arrayList.size()) + 1);
                }
                try {
                    CrawledPackageStorable crawledPackageStorable;
                    CrawledPackage crawledPackage2;
                    MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
                    zipIOWriter = new ZipIOWriter(file2, true);
                    for (CrawledPackage crawledPackage2 : arrayList) {
                        crawledPackageStorable = new CrawledPackageStorable(crawledPackage2);
                        crawledPackageStorable.setPackageID(LinkCollector.this.getPackageMapID(crawledPackage2));
                        if (!CrawledPackageStorable.TYPE.NORMAL.equals((Object)crawledPackageStorable.getType())) {
                            CrawledLink crawledLink;
                            if (CrawledPackageStorable.TYPE.VARIOUS.equals((Object)crawledPackageStorable.getType())) {
                                for (CrawledLinkStorable crawledLinkStorable : crawledPackageStorable.getLinks()) {
                                    crawledLink = crawledLinkStorable._getCrawledLink();
                                    crawledLinkStorable.setID(LinkCollector.this.getIDFromMap(LinkCollector.this.variousMap, crawledLink));
                                }
                            } else if (CrawledPackageStorable.TYPE.OFFLINE.equals((Object)crawledPackageStorable.getType())) {
                                for (CrawledLinkStorable crawledLinkStorable : crawledPackageStorable.getLinks()) {
                                    crawledLink = crawledLinkStorable._getCrawledLink();
                                    crawledLinkStorable.setID(LinkCollector.this.getIDFromMap(LinkCollector.this.offlineMap, crawledLink));
                                }
                            }
                        }
                        Iterator<CrawledLinkStorable> iterator = JSonStorage.toString(crawledPackageStorable);
                        crawledPackageStorable = null;
                        byte[] byArray = ((String)((Object)iterator)).getBytes("UTF-8");
                        iterator = null;
                        messageDigest.update(byArray);
                        zipIOWriter.addByteArry(byArray, true, "", String.format(string, n++));
                    }
                    String string2 = System.currentTimeMillis() + ":" + arrayList.size() + ":" + HexFormatter.byteArrayToHex(messageDigest.digest());
                    zipIOWriter.addByteArry(string2.getBytes("UTF-8"), true, "", LinkCollector.this.getCheckFileName());
                    try {
                        zipIOWriter.close();
                    }
                    catch (Throwable throwable) {
                        crawledPackageStorable = null;
                        try {
                            zipIOWriter.close();
                            return crawledPackageStorable;
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                        return crawledPackageStorable;
                    }
                    if (file.exists() && !file.delete()) {
                        Log.exception(new WTFException("Could not delete: " + file.getAbsolutePath()));
                        crawledPackage2 = null;
                        return crawledPackage2;
                    }
                    if (!file2.renameTo(file)) {
                        Log.exception(new WTFException("Could not rename file: " + file2 + " to " + file));
                        crawledPackage2 = null;
                        return crawledPackage2;
                    }
                    crawledPackage2 = null;
                    return crawledPackage2;
                }
                catch (Throwable throwable) {
                    Log.exception(throwable);
                    return null;
                }
                finally {
                    try {
                        zipIOWriter.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLinkCollectorLinks() {
        if (!this.isSaveAllowed()) {
            return;
        }
        ArrayList<CrawledPackage> arrayList = null;
        boolean bl = this.readLock();
        try {
            arrayList = new ArrayList<CrawledPackage>(this.packages);
        }
        finally {
            this.readUnlock(bl);
        }
        this.save(arrayList, this.getLinkCollectorListFile());
    }

    private File getLinkCollectorListFile() {
        return Application.getResource("cfg/linkcollector.zip");
    }

    public void setCrawlerFilter(LinkCrawlerFilter linkCrawlerFilter) {
        if (linkCrawlerFilter == null) {
            throw new IllegalArgumentException("crawlerFilter is null");
        }
        this.crawlerFilter = linkCrawlerFilter;
    }

    public void setLoadAllowed(boolean bl) {
        this.allowLoad = bl;
    }

    public void setPackagizer(PackagizerInterface packagizerInterface) {
        this.packagizer = packagizerInterface;
    }

    public void setSaveAllowed(boolean bl) {
        this.allowSave = bl;
    }
}

