/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect.ipcheck;

import jd.controlling.reconnect.ipcheck.IP;
import jd.controlling.reconnect.ipcheck.IPCheckException;
import org.jdownloader.translate._JDT;

public class IPConnectionState {
    private final IP ip;
    private final IPCheckException cause;

    public String toString() {
        if (this.isOffline()) {
            return _JDT._.literally_offline();
        }
        return this.ip.toString();
    }

    public IPConnectionState(IP iP) {
        if (iP == null) {
            throw new NullPointerException();
        }
        this.ip = iP;
        this.cause = null;
    }

    public IPConnectionState(IPCheckException iPCheckException) {
        if (iPCheckException == null) {
            throw new NullPointerException();
        }
        this.cause = iPCheckException;
        this.ip = null;
    }

    private boolean equalsCause(IPConnectionState iPConnectionState) {
        if (this.cause == null && iPConnectionState.cause != null) {
            return false;
        }
        if (iPConnectionState.cause == null && this.cause != null) {
            return false;
        }
        if (this.cause == iPConnectionState.cause) {
            return true;
        }
        return this.cause.getMessage().equals(iPConnectionState.cause.getMessage());
    }

    public boolean equalsLog(IPConnectionState iPConnectionState) {
        if (this.ip == null && iPConnectionState.ip == null) {
            return this.equalsCause(iPConnectionState);
        }
        if (iPConnectionState.ip == null && this.ip != null) {
            return false;
        }
        if (this.ip == null && iPConnectionState.ip != null) {
            return false;
        }
        return this.ip.equals(iPConnectionState.ip);
    }

    public IPCheckException getCause() {
        return this.cause;
    }

    public IP getExternalIp() {
        return this.ip;
    }

    public boolean isOffline() {
        return this.ip == null;
    }

    public boolean isOnline() {
        return this.ip != null;
    }
}

