/*
 * Decompiled with CFR 0.152.
 */
package jd.crypt;

public class BaseDecoder {
    private boolean _finalized;
    private int bitsPerChar;
    private byte[] bytes = new byte[94];
    private int bytesPerWord;
    private int charsPerWord;
    private char[] remainedChars;

    public BaseDecoder(char[] cArray) {
        int n;
        for (n = 0; n < this.bytes.length; ++n) {
            this.bytes[n] = -1;
        }
        for (n = 0; n < cArray.length; n = (int)((byte)(n + 1))) {
            int n2 = cArray[n] - 33;
            try {
                if (this.bytes[n2] != -1) {
                    throw new IllegalArgumentException("Duplicated alphabet: '" + cArray[n] + "'");
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IllegalArgumentException("Illegal alphabet: '" + cArray[n] + "'");
            }
            this.bytes[n2] = n;
        }
        this.bitsPerChar = (int)(Math.log(cArray.length) / Math.log(2.0));
        this.bytesPerWord = this.lcm(8, this.bitsPerChar) / 8;
        this.charsPerWord = this.lcm(8, this.bitsPerChar) / this.bitsPerChar;
        this.remainedChars = new char[0];
        this._finalized = false;
    }

    private void _decode(char[] cArray, int n, byte[] byArray, int n2, boolean bl) throws IllegalAlphabetException {
        int n3 = 0;
        int n4 = 0;
        int n5 = this.bytesPerWord - 1;
        for (int i = this.charsPerWord - 1; i >= 0; --i) {
            char c = cArray[n + i];
            n3 |= this.getByte(c, bl) << n4;
            int n6 = (n4 += this.bitsPerChar) / 8;
            for (int j = 0; j < n6; ++j) {
                byArray[n2 + n5--] = (byte)(n3 & 0xFF);
                n3 >>= 8;
                n4 -= 8;
            }
        }
    }

    private byte[] _decode(char[] cArray, int n, int n2) throws IllegalAlphabetException {
        int n3 = this.remainedChars.length + n2;
        int n4 = n3 % this.charsPerWord;
        char[] cArray2 = new char[n3];
        System.arraycopy(this.remainedChars, 0, cArray2, 0, this.remainedChars.length);
        System.arraycopy(cArray, n, cArray2, this.remainedChars.length, n2);
        if (n3 / this.charsPerWord > 0) {
            n4 += this.charsPerWord;
            n3 -= this.charsPerWord;
        }
        this.remainedChars = new char[n4];
        System.arraycopy(cArray2, cArray2.length - this.remainedChars.length, this.remainedChars, 0, this.remainedChars.length);
        char[] cArray3 = new char[n3];
        System.arraycopy(cArray2, 0, cArray3, 0, cArray3.length);
        int n5 = cArray3.length / this.charsPerWord;
        if (n5 == 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[n5 * this.bytesPerWord];
        for (int i = 0; i < n5; ++i) {
            int n6 = i * this.charsPerWord;
            int n7 = i * this.bytesPerWord;
            this._decode(cArray3, n6, byArray, n7, false);
        }
        return byArray;
    }

    private byte[] _decodeFinal(char[] cArray, int n, int n2) throws IllegalAlphabetException, BadPaddingException {
        int n3;
        int n4;
        int n5;
        int n6;
        if (this._finalized) {
            throw new IllegalStateException("Hasn't been reset");
        }
        this._decode(cArray, n, n2);
        this._finalized = true;
        if (this.remainedChars.length == 0) {
            return new byte[0];
        }
        if (this.remainedChars.length % this.charsPerWord > 0) {
            throw new BadPaddingException("Not aligned to " + this.charsPerWord);
        }
        char[] cArray2 = this.remainedChars;
        int n7 = cArray2.length / this.charsPerWord;
        byte[] byArray = new byte[n7 * this.bytesPerWord];
        --n7;
        for (n6 = 0; n6 < n7; ++n6) {
            n5 = n6 * this.charsPerWord;
            n4 = n6 * this.bytesPerWord;
            this._decode(cArray2, n5, byArray, n4, false);
        }
        n6 = n7 * this.charsPerWord;
        n5 = n7 * this.bytesPerWord;
        this._decode(cArray2, n6, byArray, n5, true);
        n4 = -1;
        for (n3 = 0; n3 < this.charsPerWord; ++n3) {
            if (cArray2[cArray2.length - this.charsPerWord + n3] != '=') continue;
            n4 = n3;
            break;
        }
        if (n4 != -1) {
            n3 = 8 / this.bitsPerChar;
            if (n4 <= n3) {
                throw new BadPaddingException();
            }
            if (n4 * this.bitsPerChar / 8 == (n4 - 1) * this.bitsPerChar / 8) {
                throw new BadPaddingException();
            }
            int n8 = n4 * this.bitsPerChar / 8;
            int n9 = this.bytesPerWord - n8;
            byte[] byArray2 = new byte[byArray.length - n9];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            return byArray2;
        }
        return byArray;
    }

    public byte[] decode(char[] cArray) throws IllegalAlphabetException {
        return this.decode(cArray, 0, cArray.length);
    }

    public byte[] decode(char[] cArray, int n, int n2) throws IllegalAlphabetException {
        return this._decode(cArray, n, n2);
    }

    public byte[] decodeFinal() throws IllegalAlphabetException, BadPaddingException {
        return this.decodeFinal(new char[0]);
    }

    public byte[] decodeFinal(char[] cArray) throws IllegalAlphabetException, BadPaddingException {
        return this.decodeFinal(cArray, 0, cArray.length);
    }

    public byte[] decodeFinal(char[] cArray, int n, int n2) throws IllegalAlphabetException, BadPaddingException {
        return this._decodeFinal(cArray, n, n2);
    }

    private int gcd(int n, int n2) {
        return n2 == 0 ? n : this.gcd(n2, n % n2);
    }

    private byte getByte(char c, boolean bl) throws IllegalAlphabetException {
        if (c == '=') {
            if (bl) {
                return 0;
            }
            throw new IllegalAlphabetException(c);
        }
        int n = c - 33;
        if (n < 0 || n >= this.bytes.length) {
            throw new IllegalArgumentException("Unknown char: " + c + "(" + n);
        }
        byte by = this.bytes[n];
        if (by == -1) {
            throw new IllegalArgumentException("Unknown char?: " + c);
        }
        return by;
    }

    public boolean isValidCharacter(char c) {
        try {
            return this.bytes[c - 33] != -1;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    private int lcm(int n, int n2) {
        return n * n2 / this.gcd(n, n2);
    }

    public BaseDecoder reset() {
        this.remainedChars = new char[0];
        this._finalized = false;
        return this;
    }

    public static class IllegalAlphabetException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public IllegalAlphabetException() {
        }

        public IllegalAlphabetException(char c) {
            this("Illegal alphabet: " + c);
        }

        public IllegalAlphabetException(String string) {
            super(string);
        }
    }

    public static class BadPaddingException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public BadPaddingException() {
            super("Bad padding");
        }

        public BadPaddingException(String string) {
            super(string);
        }
    }
}

