/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils;

import java.awt.Color;

public class ColorSpaceConverter {
    public double[] D50 = new double[]{96.4212, 100.0, 82.5188};
    public double[] D55 = new double[]{95.6797, 100.0, 92.1481};
    public double[] D65 = new double[]{95.0429, 100.0, 108.89};
    public double[] D75 = new double[]{94.9722, 100.0, 122.6394};
    public double[] whitePoint = this.D65;
    public static final double cos16 = -0.9576594803233847;
    public static final double sin16 = -0.2879033166650653;
    public static final double d160 = 0.13793103448275862;
    public static final double d3 = 0.3333333333333333;
    public static final double d24 = 0.4166666666666667;
    public double[] chromaD50 = new double[]{0.3457, 0.3585, 100.0};
    public double[] chromaD55 = new double[]{0.3324, 0.3474, 100.0};
    public double[] chromaD65 = new double[]{0.3127, 0.329, 100.0};
    public double[] chromaD75 = new double[]{0.299, 0.3149, 100.0};
    public double[] chromaWhitePoint = this.chromaD65;
    public double[][] M = new double[][]{{0.4124, 0.3576, 0.1805}, {0.2126, 0.7152, 0.0722}, {0.0193, 0.1192, 0.9505}};
    public double[][] Mi = new double[][]{{3.2406, -1.5372, -0.4986}, {-0.9689, 1.8758, 0.0415}, {0.0557, -0.204, 1.057}};

    public ColorSpaceConverter() {
        this.whitePoint = this.D65;
        this.chromaWhitePoint = this.chromaD65;
    }

    public ColorSpaceConverter(String string) {
        this.whitePoint = this.D65;
        this.chromaWhitePoint = this.chromaD65;
        if (string.equalsIgnoreCase("d50")) {
            this.whitePoint = this.D50;
            this.chromaWhitePoint = this.chromaD50;
        } else if (string.equalsIgnoreCase("d55")) {
            this.whitePoint = this.D55;
            this.chromaWhitePoint = this.chromaD55;
        } else if (string.equalsIgnoreCase("d65")) {
            this.whitePoint = this.D65;
            this.chromaWhitePoint = this.chromaD65;
        } else if (string.equalsIgnoreCase("d75")) {
            this.whitePoint = this.D75;
            this.chromaWhitePoint = this.chromaD75;
        }
    }

    public int[] HSBtoRGB(double d, double d2, double d3) {
        int[] nArray = new int[3];
        int n = Color.HSBtoRGB((float)d, (float)d2, (float)d3);
        nArray[0] = n >> 16 & 0xFF;
        nArray[1] = n >> 8 & 0xFF;
        nArray[2] = n >> 0 & 0xFF;
        return nArray;
    }

    public int[] HSBtoRGB(double[] dArray) {
        return this.HSBtoRGB(dArray[0], dArray[1], dArray[2]);
    }

    public int[] LABtoRGB(double d, double d2, double d3) {
        return this.XYZtoRGB(this.LABtoXYZ(d, d2, d3));
    }

    public int[] LABtoRGB(double[] dArray) {
        return this.XYZtoRGB(this.LABtoXYZ(dArray));
    }

    public double[] LABtoXYZ(double d, double d2, double d3) {
        double[] dArray = new double[3];
        double d4 = (d + 16.0) / 116.0;
        double d5 = d4 * d4 * d4;
        double d6 = d2 / 500.0 + d4;
        double d7 = d6 * d6 * d6;
        double d8 = d4 - d3 / 200.0;
        double d9 = d8 * d8 * d8;
        d4 = d5 > 0.008856 ? d5 : (d4 - 0.13793103448275862) / 7.787;
        d6 = d7 > 0.008856 ? d7 : (d6 - 0.13793103448275862) / 7.787;
        d8 = d9 > 0.008856 ? d9 : (d8 - 0.13793103448275862) / 7.787;
        dArray[0] = d6 * this.whitePoint[0];
        dArray[1] = d4 * this.whitePoint[1];
        dArray[2] = d8 * this.whitePoint[2];
        return dArray;
    }

    public double[] LABtoXYZ(double[] dArray) {
        return this.LABtoXYZ(dArray[0], dArray[1], dArray[2]);
    }

    public double[] RGBtoHSB(int n, int n2, int n3) {
        double[] dArray = new double[3];
        float[] fArray = new float[3];
        Color.RGBtoHSB(n, n2, n3, fArray);
        dArray[0] = fArray[0];
        dArray[1] = fArray[1];
        dArray[2] = fArray[2];
        return dArray;
    }

    public double[] RGBtoHSB(int[] nArray) {
        return this.RGBtoHSB(nArray[0], nArray[1], nArray[2]);
    }

    public double[] RGBtoLAB(int n, int n2, int n3) {
        return this.XYZtoLAB(this.RGBtoXYZ(n, n2, n3));
    }

    public double[] RGBtoLAB(int[] nArray) {
        return this.XYZtoLAB(this.RGBtoXYZ(nArray));
    }

    public double[] RGBtoXYZ(int n, int n2, int n3) {
        double[] dArray = new double[3];
        double d = (double)n / 255.0;
        double d2 = (double)n2 / 255.0;
        double d3 = (double)n3 / 255.0;
        d = d <= 0.04045 ? (d /= 12.92) : Math.pow((d + 0.055) / 1.055, 2.4);
        d2 = d2 <= 0.04045 ? (d2 /= 12.92) : Math.pow((d2 + 0.055) / 1.055, 2.4);
        d3 = d3 <= 0.04045 ? (d3 /= 12.92) : Math.pow((d3 + 0.055) / 1.055, 2.4);
        dArray[0] = (d *= 100.0) * this.M[0][0] + (d2 *= 100.0) * this.M[0][1] + (d3 *= 100.0) * this.M[0][2];
        dArray[1] = d * this.M[1][0] + d2 * this.M[1][1] + d3 * this.M[1][2];
        dArray[2] = d * this.M[2][0] + d2 * this.M[2][1] + d3 * this.M[2][2];
        return dArray;
    }

    public double[] RGBtoXYZ(int[] nArray) {
        return this.RGBtoXYZ(nArray[0], nArray[1], nArray[2]);
    }

    public double[] xyYtoXYZ(double d, double d2, double d3) {
        double[] dArray = new double[3];
        if (d2 == 0.0) {
            dArray[0] = 0.0;
            dArray[1] = 0.0;
            dArray[2] = 0.0;
        } else {
            dArray[0] = d * d3 / d2;
            dArray[1] = d3;
            dArray[2] = (1.0 - d - d2) * d3 / d2;
        }
        return dArray;
    }

    public double[] xyYtoXYZ(double[] dArray) {
        return this.xyYtoXYZ(dArray[0], dArray[1], dArray[2]);
    }

    public double[] XYZtoLAB(double d, double d2, double d3) {
        double d4 = d / this.whitePoint[0];
        double d5 = d2 / this.whitePoint[1];
        double d6 = d3 / this.whitePoint[2];
        d4 = d4 > 0.008856 ? Math.pow(d4, 0.3333333333333333) : 7.787 * d4 + 0.13793103448275862;
        d5 = d5 > 0.008856 ? Math.pow(d5, 0.3333333333333333) : 7.787 * d5 + 0.13793103448275862;
        d6 = d6 > 0.008856 ? Math.pow(d6, 0.3333333333333333) : 7.787 * d6 + 0.13793103448275862;
        double[] dArray = new double[]{116.0 * d5 - 16.0, 500.0 * (d4 - d5), 200.0 * (d5 - d6)};
        return dArray;
    }

    public double[] XYZtoLAB(double[] dArray) {
        return this.XYZtoLAB(dArray[0], dArray[1], dArray[2]);
    }

    public int[] XYZtoRGB(double d, double d2, double d3) {
        int[] nArray = new int[3];
        double d4 = d / 100.0;
        double d5 = d2 / 100.0;
        double d6 = d3 / 100.0;
        double d7 = d4 * this.Mi[0][0] + d5 * this.Mi[0][1] + d6 * this.Mi[0][2];
        double d8 = d4 * this.Mi[1][0] + d5 * this.Mi[1][1] + d6 * this.Mi[1][2];
        double d9 = d4 * this.Mi[2][0] + d5 * this.Mi[2][1] + d6 * this.Mi[2][2];
        d7 = d7 > 0.0031308 ? 1.055 * Math.pow(d7, 0.4166666666666667) - 0.055 : (d7 *= 12.92);
        d8 = d8 > 0.0031308 ? 1.055 * Math.pow(d8, 0.4166666666666667) - 0.055 : (d8 *= 12.92);
        d9 = d9 > 0.0031308 ? 1.055 * Math.pow(d9, 0.4166666666666667) - 0.055 : (d9 *= 12.92);
        d7 = d7 < 0.0 ? 0.0 : d7;
        d8 = d8 < 0.0 ? 0.0 : d8;
        d9 = d9 < 0.0 ? 0.0 : d9;
        nArray[0] = (int)Math.round(d7 * 255.0);
        nArray[1] = (int)Math.round(d8 * 255.0);
        nArray[2] = (int)Math.round(d9 * 255.0);
        return nArray;
    }

    public int[] XYZtoRGB(double[] dArray) {
        return this.XYZtoRGB(dArray[0], dArray[1], dArray[2]);
    }

    public double[] XYZtoxyY(double d, double d2, double d3) {
        double[] dArray = new double[3];
        if (d + d2 + d3 == 0.0) {
            dArray[0] = this.chromaWhitePoint[0];
            dArray[1] = this.chromaWhitePoint[1];
            dArray[2] = this.chromaWhitePoint[2];
        } else {
            dArray[0] = d / (d + d2 + d3);
            dArray[1] = d2 / (d + d2 + d3);
            dArray[2] = d2;
        }
        return dArray;
    }

    public double[] XYZtoxyY(double[] dArray) {
        return this.XYZtoxyY(dArray[0], dArray[1], dArray[2]);
    }

    public double[] LABtoDIN99(double[] dArray) {
        double[] dArray2 = new double[3];
        dArray2[0] = 105.51 * Math.log(1.0 + 0.0158 * dArray[0]);
        if (dArray[1] == 0.0 && dArray[2] == 0.0) {
            dArray2[1] = 0.0;
            dArray2[2] = 0.0;
            return dArray2;
        }
        double d = dArray[1] * -0.9576594803233847 + dArray[2] * -0.2879033166650653;
        double d2 = 0.7 * (dArray[2] * -0.9576594803233847 - dArray[1] * -0.2879033166650653);
        double d3 = 0.045 * Math.sqrt(d * d + d2 * d2);
        double d4 = Math.log(1.0 + d3) / d3;
        dArray2[1] = d4 * d;
        dArray2[2] = d4 * d2;
        return dArray2;
    }

    public double[] RGBtoDIN99(int[] nArray) {
        return this.LABtoDIN99(this.RGBtoLAB(nArray));
    }
}

