/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DiffMatchPatch {
    public float diffTimeout = 1.0f;
    public short diffEditCost = (short)4;
    public short diffDualThreshold = (short)32;
    public float matchBalance = 0.5f;
    public float matchThreshold = 0.5f;
    public int matchMinLength = 100;
    public int matchMaxLength = 1000;
    public short patchMargin = (short)4;
    private int matchMaxBits = 32;
    private Pattern BLANKLINEEND = Pattern.compile("\\n\\r?\\n\\Z", 32);
    private Pattern BLANKLINESTART = Pattern.compile("\\A\\r?\\n\\r?\\n", 32);

    public LinkedList<Diff> diffMain(String string, String string2) {
        return this.diffMain(string, string2, true);
    }

    public LinkedList<Diff> diffMain(String string, String string2, boolean bl) {
        if (string.equals(string2)) {
            LinkedList<Diff> linkedList = new LinkedList<Diff>();
            linkedList.add(new Diff(Operation.EQUAL, string));
            return linkedList;
        }
        int n = this.diffCommonPrefix(string, string2);
        String string3 = string.substring(0, n);
        string = string.substring(n);
        string2 = string2.substring(n);
        n = this.diffCommonSuffix(string, string2);
        String string4 = string.substring(string.length() - n);
        string = string.substring(0, string.length() - n);
        string2 = string2.substring(0, string2.length() - n);
        LinkedList<Diff> linkedList = this.diffCompute(string, string2, bl);
        if (string3.length() != 0) {
            linkedList.addFirst(new Diff(Operation.EQUAL, string3));
        }
        if (string4.length() != 0) {
            linkedList.addLast(new Diff(Operation.EQUAL, string4));
        }
        this.diffCleanupMerge(linkedList);
        return linkedList;
    }

    protected LinkedList<Diff> diffCompute(String string, String string2, boolean bl) {
        String string3;
        LinkedList<Diff> linkedList = new LinkedList<Diff>();
        if (string.length() == 0) {
            linkedList.add(new Diff(Operation.INSERT, string2));
            return linkedList;
        }
        if (string2.length() == 0) {
            linkedList.add(new Diff(Operation.DELETE, string));
            return linkedList;
        }
        String string4 = string.length() > string2.length() ? string : string2;
        int n = string4.indexOf(string3 = string.length() > string2.length() ? string2 : string);
        if (n != -1) {
            Operation operation = string.length() > string2.length() ? Operation.DELETE : Operation.INSERT;
            linkedList.add(new Diff(operation, string4.substring(0, n)));
            linkedList.add(new Diff(Operation.EQUAL, string3));
            linkedList.add(new Diff(operation, string4.substring(n + string3.length())));
            return linkedList;
        }
        string4 = null;
        string3 = null;
        String[] stringArray = this.diffHalfMatch(string, string2);
        if (stringArray != null) {
            String string5 = stringArray[0];
            String string6 = stringArray[1];
            String string7 = stringArray[2];
            String string8 = stringArray[3];
            String string9 = stringArray[4];
            LinkedList<Diff> linkedList2 = this.diffMain(string5, string7, bl);
            LinkedList<Diff> linkedList3 = this.diffMain(string6, string8, bl);
            linkedList = linkedList2;
            linkedList.add(new Diff(Operation.EQUAL, string9));
            linkedList.addAll(linkedList3);
            return linkedList;
        }
        if (bl && (string.length() < 100 || string2.length() < 100)) {
            bl = false;
        }
        ArrayList arrayList = null;
        if (bl) {
            Object[] objectArray = this.diffLinesToChars(string, string2);
            string = (String)objectArray[0];
            string2 = (String)objectArray[1];
            arrayList = (ArrayList)objectArray[2];
        }
        if ((linkedList = this.diffMap(string, string2)) == null) {
            linkedList = new LinkedList();
            linkedList.add(new Diff(Operation.DELETE, string));
            linkedList.add(new Diff(Operation.INSERT, string2));
        }
        if (bl) {
            this.diffCharsToLines(linkedList, arrayList);
            this.diffCleanupSemantic(linkedList);
            linkedList.add(new Diff(Operation.EQUAL, ""));
            int n2 = 0;
            int n3 = 0;
            String string10 = "";
            String string11 = "";
            ListIterator<Diff> listIterator = linkedList.listIterator();
            Diff diff = (Diff)listIterator.next();
            while (diff != null) {
                switch (diff.operation) {
                    case INSERT: {
                        ++n3;
                        string11 = string11 + diff.text;
                        break;
                    }
                    case DELETE: {
                        ++n2;
                        string10 = string10 + diff.text;
                        break;
                    }
                    case EQUAL: {
                        if (n2 >= 1 && n3 >= 1) {
                            listIterator.previous();
                            for (int i = 0; i < n2 + n3; ++i) {
                                listIterator.previous();
                                listIterator.remove();
                            }
                            for (Diff diff2 : this.diffMain(string10, string11, false)) {
                                listIterator.add(diff2);
                            }
                        }
                        n3 = 0;
                        n2 = 0;
                        string10 = "";
                        string11 = "";
                    }
                }
                diff = listIterator.hasNext() ? (Diff)listIterator.next() : null;
            }
            linkedList.removeLast();
        }
        return linkedList;
    }

    public Object[] diffLinesToChars(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        arrayList.add("");
        String string3 = this.diffLinesToCharsMunge(string, arrayList, hashMap);
        String string4 = this.diffLinesToCharsMunge(string2, arrayList, hashMap);
        return new Object[]{string3, string4, arrayList};
    }

    private String diffLinesToCharsMunge(String string, List<String> list, Map<String, Integer> map) {
        int n = 0;
        int n2 = -1;
        StringBuilder stringBuilder = new StringBuilder();
        while (n2 < string.length() - 1) {
            n2 = string.indexOf(10, n);
            if (n2 == -1) {
                n2 = string.length() - 1;
            }
            String string2 = string.substring(n, n2 + 1);
            n = n2 + 1;
            if (map.containsKey(string2)) {
                stringBuilder.append(String.valueOf((char)map.get(string2).intValue()));
                continue;
            }
            list.add(string2);
            map.put(string2, list.size() - 1);
            stringBuilder.append(String.valueOf((char)(list.size() - 1)));
        }
        return stringBuilder.toString();
    }

    public void diffCharsToLines(LinkedList<Diff> linkedList, List<String> list) {
        for (Diff diff : linkedList) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < diff.text.length(); ++i) {
                stringBuilder.append(list.get(diff.text.charAt(i)));
            }
            diff.text = stringBuilder.toString();
        }
    }

    public LinkedList<Diff> diffMap(String string, String string2) {
        long l = System.currentTimeMillis() + (long)(this.diffTimeout * 1000.0f);
        int n = string.length() + string2.length() - 1;
        boolean bl = this.diffDualThreshold * 2 < n;
        List<Set<Long>> list = new ArrayList<Set<Long>>();
        List<Set<Long>> list2 = new ArrayList();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> hashMap2 = new HashMap<Integer, Integer>();
        hashMap.put(1, 0);
        hashMap2.put(1, 0);
        Long l2 = 0L;
        HashMap<Long, Integer> hashMap3 = new HashMap<Long, Integer>();
        boolean bl2 = false;
        boolean bl3 = (string.length() + string2.length()) % 2 == 1;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            int n4;
            if (this.diffTimeout > 0.0f && System.currentTimeMillis() > l) {
                return null;
            }
            list.add(new HashSet());
            for (n4 = -i; n4 <= i; n4 += 2) {
                n3 = n4 == -i || n4 != i && (Integer)hashMap.get(n4 - 1) < (Integer)hashMap.get(n4 + 1) ? (Integer)hashMap.get(n4 + 1) : (Integer)hashMap.get(n4 - 1) + 1;
                n2 = n3 - n4;
                if (bl) {
                    l2 = this.diffFootprint(n3, n2);
                    if (bl3 && hashMap3.containsKey(l2)) {
                        bl2 = true;
                    }
                    if (!bl3) {
                        hashMap3.put(l2, i);
                    }
                }
                while (!bl2 && n3 < string.length() && n2 < string2.length() && string.charAt(n3) == string2.charAt(n2)) {
                    ++n3;
                    ++n2;
                    if (!bl) continue;
                    l2 = this.diffFootprint(n3, n2);
                    if (bl3 && hashMap3.containsKey(l2)) {
                        bl2 = true;
                    }
                    if (bl3) continue;
                    hashMap3.put(l2, i);
                }
                hashMap.put(n4, n3);
                ((Set)list.get(i)).add(this.diffFootprint(n3, n2));
                if (n3 == string.length() && n2 == string2.length()) {
                    return this.diffPath1(list, string, string2);
                }
                if (!bl2) continue;
                list2 = list2.subList(0, (Integer)hashMap3.get(l2) + 1);
                LinkedList<Diff> linkedList = this.diffPath1(list, string.substring(0, n3), string2.substring(0, n2));
                linkedList.addAll(this.diffPath2(list2, string.substring(n3), string2.substring(n2)));
                return linkedList;
            }
            if (!bl) continue;
            list2.add(new HashSet());
            for (n4 = -i; n4 <= i; n4 += 2) {
                n3 = n4 == -i || n4 != i && (Integer)hashMap2.get(n4 - 1) < (Integer)hashMap2.get(n4 + 1) ? (Integer)hashMap2.get(n4 + 1) : (Integer)hashMap2.get(n4 - 1) + 1;
                n2 = n3 - n4;
                l2 = this.diffFootprint(string.length() - n3, string2.length() - n2);
                if (!bl3 && hashMap3.containsKey(l2)) {
                    bl2 = true;
                }
                if (bl3) {
                    hashMap3.put(l2, i);
                }
                while (!bl2 && n3 < string.length() && n2 < string2.length() && string.charAt(string.length() - n3 - 1) == string2.charAt(string2.length() - n2 - 1)) {
                    l2 = this.diffFootprint(string.length() - ++n3, string2.length() - ++n2);
                    if (!bl3 && hashMap3.containsKey(l2)) {
                        bl2 = true;
                    }
                    if (!bl3) continue;
                    hashMap3.put(l2, i);
                }
                hashMap2.put(n4, n3);
                ((Set)list2.get(i)).add(this.diffFootprint(n3, n2));
                if (!bl2) continue;
                list = list.subList(0, (Integer)hashMap3.get(l2) + 1);
                LinkedList<Diff> linkedList = this.diffPath1(list, string.substring(0, string.length() - n3), string2.substring(0, string2.length() - n2));
                linkedList.addAll(this.diffPath2(list2, string.substring(string.length() - n3), string2.substring(string2.length() - n2)));
                return linkedList;
            }
        }
        return null;
    }

    public LinkedList<Diff> diffPath1(List<Set<Long>> list, String string, String string2) {
        LinkedList<Diff> linkedList = new LinkedList<Diff>();
        int n = string.length();
        int n2 = string2.length();
        Operation operation = null;
        block0: for (int i = list.size() - 2; i >= 0; --i) {
            while (true) {
                if (list.get(i).contains(this.diffFootprint(n - 1, n2))) {
                    --n;
                    if (operation == Operation.DELETE) {
                        linkedList.getFirst().text = string.charAt(n) + linkedList.getFirst().text;
                    } else {
                        linkedList.addFirst(new Diff(Operation.DELETE, string.substring(n, n + 1)));
                    }
                    operation = Operation.DELETE;
                    continue block0;
                }
                if (list.get(i).contains(this.diffFootprint(n, n2 - 1))) {
                    --n2;
                    if (operation == Operation.INSERT) {
                        linkedList.getFirst().text = string2.charAt(n2) + linkedList.getFirst().text;
                    } else {
                        linkedList.addFirst(new Diff(Operation.INSERT, string2.substring(n2, n2 + 1)));
                    }
                    operation = Operation.INSERT;
                    continue block0;
                }
                assert (string.charAt(--n) == string2.charAt(--n2)) : "No diagonal.  Can't happen. (diffPath1)";
                if (operation == Operation.EQUAL) {
                    linkedList.getFirst().text = string.charAt(n) + linkedList.getFirst().text;
                } else {
                    linkedList.addFirst(new Diff(Operation.EQUAL, string.substring(n, n + 1)));
                }
                operation = Operation.EQUAL;
            }
        }
        return linkedList;
    }

    public LinkedList<Diff> diffPath2(List<Set<Long>> list, String string, String string2) {
        LinkedList<Diff> linkedList = new LinkedList<Diff>();
        int n = string.length();
        int n2 = string2.length();
        Operation operation = null;
        block0: for (int i = list.size() - 2; i >= 0; --i) {
            while (true) {
                if (list.get(i).contains(this.diffFootprint(n - 1, n2))) {
                    --n;
                    if (operation == Operation.DELETE) {
                        linkedList.getLast().text = linkedList.getLast().text + string.charAt(string.length() - n - 1);
                    } else {
                        linkedList.addLast(new Diff(Operation.DELETE, string.substring(string.length() - n - 1, string.length() - n)));
                    }
                    operation = Operation.DELETE;
                    continue block0;
                }
                if (list.get(i).contains(this.diffFootprint(n, n2 - 1))) {
                    --n2;
                    if (operation == Operation.INSERT) {
                        linkedList.getLast().text = linkedList.getLast().text + string2.charAt(string2.length() - n2 - 1);
                    } else {
                        linkedList.addLast(new Diff(Operation.INSERT, string2.substring(string2.length() - n2 - 1, string2.length() - n2)));
                    }
                    operation = Operation.INSERT;
                    continue block0;
                }
                assert (string.charAt(string.length() - --n - 1) == string2.charAt(string2.length() - --n2 - 1)) : "No diagonal.  Can't happen. (diffPath2)";
                if (operation == Operation.EQUAL) {
                    linkedList.getLast().text = linkedList.getLast().text + string.charAt(string.length() - n - 1);
                } else {
                    linkedList.addLast(new Diff(Operation.EQUAL, string.substring(string.length() - n - 1, string.length() - n)));
                }
                operation = Operation.EQUAL;
            }
        }
        return linkedList;
    }

    public Long diffFootprint(int n, int n2) {
        long l = n;
        l <<= 32;
        return l += (long)n2;
    }

    public int diffCommonPrefix(String string, String string2) {
        int n = Math.min(string.length(), string2.length());
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == string2.charAt(i)) continue;
            return i;
        }
        return n;
    }

    public int diffCommonSuffix(String string, String string2) {
        int n = Math.min(string.length(), string2.length());
        for (int i = 0; i < n; ++i) {
            if (string.charAt(string.length() - i - 1) == string2.charAt(string2.length() - i - 1)) continue;
            return i;
        }
        return n;
    }

    public String[] diffHalfMatch(String string, String string2) {
        String[] stringArray;
        String string3;
        String string4 = string.length() > string2.length() ? string : string2;
        String string5 = string3 = string.length() > string2.length() ? string2 : string;
        if (string4.length() < 10 || string3.length() < 1) {
            return null;
        }
        String[] stringArray2 = this.diffHalfMatchI(string4, string3, (string4.length() + 3) / 4);
        String[] stringArray3 = this.diffHalfMatchI(string4, string3, (string4.length() + 1) / 2);
        if (stringArray2 == null && stringArray3 == null) {
            return null;
        }
        if (stringArray3 == null) {
            stringArray = stringArray2;
        } else if (stringArray2 == null) {
            stringArray = stringArray3;
        } else {
            String[] stringArray4 = stringArray = stringArray2[4].length() > stringArray3[4].length() ? stringArray2 : stringArray3;
        }
        if (string.length() > string2.length()) {
            return stringArray;
        }
        return new String[]{stringArray[2], stringArray[3], stringArray[0], stringArray[1], stringArray[4]};
    }

    private String[] diffHalfMatchI(String string, String string2, int n) {
        String string3 = string.substring(n, n + string.length() / 4);
        int n2 = -1;
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        while ((n2 = string2.indexOf(string3, n2 + 1)) != -1) {
            int n3 = this.diffCommonPrefix(string.substring(n), string2.substring(n2));
            int n4 = this.diffCommonSuffix(string.substring(0, n), string2.substring(0, n2));
            if (string4.length() >= n4 + n3) continue;
            string4 = string2.substring(n2 - n4, n2) + string2.substring(n2, n2 + n3);
            string5 = string.substring(0, n - n4);
            string6 = string.substring(n + n3);
            string7 = string2.substring(0, n2 - n4);
            string8 = string2.substring(n2 + n3);
        }
        if (string4.length() >= string.length() / 2) {
            return new String[]{string5, string6, string7, string8, string4};
        }
        return null;
    }

    public void diffCleanupSemantic(LinkedList<Diff> linkedList) {
        if (linkedList.isEmpty()) {
            return;
        }
        boolean bl = false;
        Stack<Diff> stack = new Stack<Diff>();
        String string = null;
        ListIterator<Diff> listIterator = linkedList.listIterator();
        int n = 0;
        int n2 = 0;
        Diff diff = (Diff)listIterator.next();
        while (diff != null) {
            if (diff.operation == Operation.EQUAL) {
                stack.push(diff);
                n = n2;
                n2 = 0;
                string = diff.text;
            } else if (string != null && string.length() <= n && string.length() <= (n2 += diff.text.length())) {
                while (diff != stack.lastElement()) {
                    diff = (Diff)listIterator.previous();
                }
                listIterator.next();
                listIterator.set(new Diff(Operation.DELETE, string));
                listIterator.add(new Diff(Operation.INSERT, string));
                stack.pop();
                if (!stack.empty()) {
                    stack.pop();
                }
                if (stack.empty()) {
                    while (listIterator.hasPrevious()) {
                        listIterator.previous();
                    }
                } else {
                    diff = (Diff)stack.lastElement();
                    while (diff != listIterator.previous()) {
                    }
                }
                n = 0;
                n2 = 0;
                string = null;
                bl = true;
            }
            diff = listIterator.hasNext() ? (Diff)listIterator.next() : null;
        }
        if (bl) {
            this.diffCleanupMerge(linkedList);
        }
        this.diffCleanupSemanticLossless(linkedList);
    }

    public void diffCleanupSemanticLossless(LinkedList<Diff> linkedList) {
        Diff diff;
        ListIterator listIterator = linkedList.listIterator();
        Diff diff2 = listIterator.hasNext() ? (Diff)listIterator.next() : null;
        Diff diff3 = listIterator.hasNext() ? (Diff)listIterator.next() : null;
        Diff diff4 = diff = listIterator.hasNext() ? (Diff)listIterator.next() : null;
        while (diff != null) {
            if (diff2.operation == Operation.EQUAL && diff.operation == Operation.EQUAL) {
                String string = diff2.text;
                String string2 = diff3.text;
                String string3 = diff.text;
                int n = this.diffCommonSuffix(string, string2);
                if (n != 0) {
                    String string4 = string2.substring(string2.length() - n);
                    string = string.substring(0, string.length() - n);
                    string2 = string4 + string2.substring(0, string2.length() - n);
                    string3 = string4 + string3;
                }
                String string5 = string;
                String string6 = string2;
                String string7 = string3;
                int n2 = this.diffCleanupSemanticScore(string, string2) + this.diffCleanupSemanticScore(string2, string3);
                while (string2.length() != 0 && string3.length() != 0 && string2.charAt(0) == string3.charAt(0)) {
                    string = string + string2.charAt(0);
                    string2 = string2.substring(1) + string3.charAt(0);
                    string3 = string3.substring(1);
                    int n3 = this.diffCleanupSemanticScore(string, string2) + this.diffCleanupSemanticScore(string2, string3);
                    if (n3 < n2) continue;
                    n2 = n3;
                    string5 = string;
                    string6 = string2;
                    string7 = string3;
                }
                if (!diff2.text.equals(string5)) {
                    if (string5.length() != 0) {
                        diff2.text = string5;
                    } else {
                        listIterator.previous();
                        listIterator.previous();
                        listIterator.previous();
                        listIterator.remove();
                        listIterator.next();
                        listIterator.next();
                    }
                    diff3.text = string6;
                    if (string7.length() != 0) {
                        diff.text = string7;
                    } else {
                        listIterator.remove();
                        diff = diff3;
                        diff3 = diff2;
                    }
                }
            }
            diff2 = diff3;
            diff3 = diff;
            diff = listIterator.hasNext() ? (Diff)listIterator.next() : null;
        }
    }

    private int diffCleanupSemanticScore(String string, String string2) {
        if (string.length() == 0 || string2.length() == 0) {
            return 5;
        }
        int n = 0;
        if (!Character.isLetterOrDigit(string.charAt(string.length() - 1)) || !Character.isLetterOrDigit(string2.charAt(0))) {
            ++n;
            if (Character.isWhitespace(string.charAt(string.length() - 1)) || Character.isWhitespace(string2.charAt(0))) {
                ++n;
                if (Character.getType(string.charAt(string.length() - 1)) == 15 || Character.getType(string2.charAt(0)) == 15) {
                    ++n;
                    if (this.BLANKLINEEND.matcher(string).find() || this.BLANKLINESTART.matcher(string2).find()) {
                        ++n;
                    }
                }
            }
        }
        return n;
    }

    public void diffCleanupEfficiency(LinkedList<Diff> linkedList) {
        Diff diff;
        if (linkedList.isEmpty()) {
            return;
        }
        boolean bl = false;
        Stack<Diff> stack = new Stack<Diff>();
        String string = null;
        ListIterator<Diff> listIterator = linkedList.listIterator();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        Diff diff2 = diff = (Diff)listIterator.next();
        while (diff != null) {
            if (diff.operation == Operation.EQUAL) {
                if (diff.text.length() < this.diffEditCost && (bl4 || bl5)) {
                    stack.push(diff);
                    bl2 = bl4;
                    bl3 = bl5;
                    string = diff.text;
                } else {
                    stack.clear();
                    string = null;
                    diff2 = diff;
                }
                bl5 = false;
                bl4 = false;
            } else {
                if (diff.operation == Operation.DELETE) {
                    bl5 = true;
                } else {
                    bl4 = true;
                }
                if (string != null && (bl2 && bl3 && bl4 && bl5 || string.length() < this.diffEditCost / 2 && (bl2 ? 1 : 0) + (bl3 ? 1 : 0) + (bl4 ? 1 : 0) + (bl5 ? 1 : 0) == 3)) {
                    while (diff != stack.lastElement()) {
                        diff = (Diff)listIterator.previous();
                    }
                    listIterator.next();
                    listIterator.set(new Diff(Operation.DELETE, string));
                    diff = new Diff(Operation.INSERT, string);
                    listIterator.add(diff);
                    stack.pop();
                    string = null;
                    if (bl2 && bl3) {
                        bl5 = true;
                        bl4 = true;
                        stack.clear();
                        diff2 = diff;
                    } else {
                        if (!stack.empty()) {
                            stack.pop();
                        }
                        diff = stack.empty() ? diff2 : (Diff)stack.lastElement();
                        while (diff != listIterator.previous()) {
                        }
                        bl5 = false;
                        bl4 = false;
                    }
                    bl = true;
                }
            }
            diff = listIterator.hasNext() ? (Diff)listIterator.next() : null;
        }
        if (bl) {
            this.diffCleanupMerge(linkedList);
        }
    }

    public void diffCleanupMerge(LinkedList<Diff> linkedList) {
        Diff diff;
        linkedList.add(new Diff(Operation.EQUAL, ""));
        ListIterator<Diff> listIterator = linkedList.listIterator();
        int n = 0;
        int n2 = 0;
        String string = "";
        String string2 = "";
        Diff diff2 = (Diff)listIterator.next();
        Diff diff3 = null;
        while (diff2 != null) {
            switch (diff2.operation) {
                case INSERT: {
                    ++n2;
                    string2 = string2 + diff2.text;
                    diff3 = null;
                    break;
                }
                case DELETE: {
                    ++n;
                    string = string + diff2.text;
                    diff3 = null;
                    break;
                }
                case EQUAL: {
                    if (n != 0 || n2 != 0) {
                        listIterator.previous();
                        while (n-- > 0) {
                            listIterator.previous();
                            listIterator.remove();
                        }
                        while (n2-- > 0) {
                            listIterator.previous();
                            listIterator.remove();
                        }
                        if (n != 0 && n2 != 0) {
                            int n3 = this.diffCommonPrefix(string2, string);
                            if (n3 != 0) {
                                if (listIterator.hasPrevious()) {
                                    diff2 = (Diff)listIterator.previous();
                                    assert (diff2.operation == Operation.EQUAL) : "Previous diff should have been an equality.";
                                    diff2.text = diff2.text + string2.substring(0, n3);
                                    listIterator.next();
                                } else {
                                    listIterator.add(new Diff(Operation.EQUAL, string2.substring(0, n3)));
                                }
                                string2 = string2.substring(n3);
                                string = string.substring(n3);
                            }
                            if ((n3 = this.diffCommonSuffix(string2, string)) != 0) {
                                diff2 = (Diff)listIterator.next();
                                diff2.text = string2.substring(string2.length() - n3) + diff2.text;
                                string2 = string2.substring(0, string2.length() - n3);
                                string = string.substring(0, string.length() - n3);
                                listIterator.previous();
                            }
                        }
                        if (string.length() != 0) {
                            listIterator.add(new Diff(Operation.DELETE, string));
                        }
                        if (string2.length() != 0) {
                            listIterator.add(new Diff(Operation.INSERT, string2));
                        }
                        diff2 = listIterator.hasNext() ? (Diff)listIterator.next() : null;
                    } else if (diff3 != null) {
                        diff3.text = diff3.text + diff2.text;
                        listIterator.remove();
                        diff2 = (Diff)listIterator.previous();
                        listIterator.next();
                    }
                    n2 = 0;
                    n = 0;
                    string = "";
                    string2 = "";
                    diff3 = diff2;
                }
            }
            diff2 = listIterator.hasNext() ? (Diff)listIterator.next() : null;
        }
        if (linkedList.getLast().text.length() == 0) {
            linkedList.removeLast();
        }
        boolean bl = false;
        listIterator = linkedList.listIterator();
        Diff diff4 = listIterator.hasNext() ? (Diff)listIterator.next() : null;
        diff2 = listIterator.hasNext() ? (Diff)listIterator.next() : null;
        Diff diff5 = diff = listIterator.hasNext() ? (Diff)listIterator.next() : null;
        while (diff != null) {
            if (diff4.operation == Operation.EQUAL && diff.operation == Operation.EQUAL) {
                if (diff2.text.endsWith(diff4.text)) {
                    diff2.text = diff4.text + diff2.text.substring(0, diff2.text.length() - diff4.text.length());
                    diff.text = diff4.text + diff.text;
                    listIterator.previous();
                    listIterator.previous();
                    listIterator.previous();
                    listIterator.remove();
                    listIterator.next();
                    diff2 = (Diff)listIterator.next();
                    diff = listIterator.hasNext() ? (Diff)listIterator.next() : null;
                    bl = true;
                } else if (diff2.text.startsWith(diff.text)) {
                    diff4.text = diff4.text + diff.text;
                    diff2.text = diff2.text.substring(diff.text.length()) + diff.text;
                    listIterator.remove();
                    diff = listIterator.hasNext() ? (Diff)listIterator.next() : null;
                    bl = true;
                }
            }
            diff4 = diff2;
            diff2 = diff;
            diff = listIterator.hasNext() ? (Diff)listIterator.next() : null;
        }
        if (bl) {
            this.diffCleanupMerge(linkedList);
        }
    }

    public int diffXIndex(LinkedList<Diff> linkedList, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Diff diff = null;
        for (Diff diff2 : linkedList) {
            if (diff2.operation != Operation.INSERT) {
                n2 += diff2.text.length();
            }
            if (diff2.operation != Operation.DELETE) {
                n3 += diff2.text.length();
            }
            if (n2 > n) {
                diff = diff2;
                break;
            }
            n4 = n2;
            n5 = n3;
        }
        if (diff != null && diff.operation == Operation.DELETE) {
            return n5;
        }
        return n5 + (n - n4);
    }

    public String diffPrettyHtml(LinkedList<Diff> linkedList) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (Diff diff : linkedList) {
            String string = diff.text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\n", "&para;<BR>");
            switch (diff.operation) {
                case INSERT: {
                    stringBuilder.append("<INS STYLE=\"background:#E6FFE6;\" TITLE=\"i=").append(n).append("\">").append(string).append("</INS>");
                    break;
                }
                case DELETE: {
                    stringBuilder.append("<DEL STYLE=\"background:#FFE6E6;\" TITLE=\"i=").append(n).append("\">").append(string).append("</DEL>");
                    break;
                }
                case EQUAL: {
                    stringBuilder.append("<SPAN TITLE=\"i=").append(n).append("\">").append(string).append("</SPAN>");
                }
            }
            if (diff.operation == Operation.DELETE) continue;
            n += diff.text.length();
        }
        return stringBuilder.toString();
    }

    public String diffText1(LinkedList<Diff> linkedList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Diff diff : linkedList) {
            if (diff.operation == Operation.INSERT) continue;
            stringBuilder.append(diff.text);
        }
        return stringBuilder.toString();
    }

    public String diffText2(LinkedList<Diff> linkedList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Diff diff : linkedList) {
            if (diff.operation == Operation.DELETE) continue;
            stringBuilder.append(diff.text);
        }
        return stringBuilder.toString();
    }

    public int diffLevenshtein(LinkedList<Diff> linkedList) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (Diff diff : linkedList) {
            switch (diff.operation) {
                case INSERT: {
                    n2 += diff.text.length();
                    break;
                }
                case DELETE: {
                    n3 += diff.text.length();
                    break;
                }
                case EQUAL: {
                    n += Math.max(n2, n3);
                    n2 = 0;
                    n3 = 0;
                }
            }
        }
        return n += Math.max(n2, n3);
    }

    public String diffToDelta(LinkedList<Diff> linkedList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Diff diff : linkedList) {
            switch (diff.operation) {
                case INSERT: {
                    try {
                        stringBuilder.append("+").append(URLEncoder.encode(diff.text, "UTF-8").replace('+', ' ')).append("\t");
                        break;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new Error("This system does not support UTF-8.", unsupportedEncodingException);
                    }
                }
                case DELETE: {
                    stringBuilder.append("-").append(diff.text.length()).append("\t");
                    break;
                }
                case EQUAL: {
                    stringBuilder.append("=").append(diff.text.length()).append("\t");
                }
            }
        }
        Object object = stringBuilder.toString();
        if (((String)object).length() != 0) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
            object = DiffMatchPatch.unescapeForEncodeUriCompatability((String)object);
        }
        return object;
    }

    public LinkedList<Diff> diffFromDelta(String string, String string2) throws IllegalArgumentException {
        String[] stringArray;
        LinkedList<Diff> linkedList = new LinkedList<Diff>();
        int n = 0;
        block11: for (String string3 : stringArray = string2.split("\t")) {
            if (string3.length() == 0) continue;
            String string4 = string3.substring(1);
            switch (string3.charAt(0)) {
                case '+': {
                    string4 = string4.replace("+", "%2B");
                    try {
                        string4 = URLDecoder.decode(string4, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new Error("This system does not support UTF-8.", unsupportedEncodingException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new IllegalArgumentException("Illegal escape in diffFromDelta: " + string4, illegalArgumentException);
                    }
                    linkedList.add(new Diff(Operation.INSERT, string4));
                    continue block11;
                }
                case '-': 
                case '=': {
                    String string5;
                    int n2;
                    try {
                        n2 = Integer.parseInt(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("Invalid number in diffFromDelta: " + string4, numberFormatException);
                    }
                    if (n2 < 0) {
                        throw new IllegalArgumentException("Negative number in diffFromDelta: " + string4);
                    }
                    try {
                        string5 = string.substring(n, n += n2);
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        throw new IllegalArgumentException("Delta length (" + n + ") larger than source text length (" + string.length() + ").", stringIndexOutOfBoundsException);
                    }
                    if (string3.charAt(0) == '=') {
                        linkedList.add(new Diff(Operation.EQUAL, string5));
                        continue block11;
                    }
                    linkedList.add(new Diff(Operation.DELETE, string5));
                    continue block11;
                }
                default: {
                    throw new IllegalArgumentException("Invalid diff operation in diffFromDelta: " + string3.charAt(0));
                }
            }
        }
        if (n != string.length()) {
            throw new IllegalArgumentException("Delta length (" + n + ") smaller than source text length (" + string.length() + ").");
        }
        return linkedList;
    }

    public int matchMain(String string, String string2, int n) {
        n = Math.max(0, Math.min(n, string.length() - string2.length()));
        if (string.equals(string2)) {
            return 0;
        }
        if (string.length() == 0) {
            return -1;
        }
        if (string.substring(n, n + string2.length()).equals(string2)) {
            return n;
        }
        return this.matchBitap(string, string2, n);
    }

    public int matchBitap(String string, String string2, int n) {
        assert (this.matchMaxBits == 0 || string2.length() <= this.matchMaxBits) : "Pattern too long for this application.";
        Map<Character, Integer> map = this.matchAlphabet(string2);
        int n2 = string.length();
        n2 = Math.max(n2, this.matchMinLength);
        n2 = Math.min(n2, this.matchMaxLength);
        double d = this.matchThreshold;
        int n3 = string.indexOf(string2, n);
        if (n3 != -1) {
            d = Math.min(this.matchBitapScore(0, n3, n, n2, string2), d);
        }
        if ((n3 = string.lastIndexOf(string2, n + string2.length())) != -1) {
            d = Math.min(this.matchBitapScore(0, n3, n, n2, string2), d);
        }
        int n4 = 1 << string2.length() - 1;
        n3 = -1;
        int n5 = Math.max(n + n, string.length());
        int[] nArray = new int[]{};
        for (int i = 0; i < string2.length(); ++i) {
            int[] nArray2 = new int[string.length()];
            int n6 = n;
            int n7 = n5;
            while (n6 < n7) {
                if (this.matchBitapScore(i, n7, n, n2, string2) < d) {
                    n6 = n7;
                } else {
                    n5 = n7;
                }
                n7 = (n5 - n6) / 2 + n6;
            }
            n5 = n7;
            int n8 = Math.max(0, n - (n7 - n) - 1);
            int n9 = Math.min(string.length() - 1, string2.length() + n7);
            nArray2[n9] = string.charAt(n9) == string2.charAt(string2.length() - 1) ? (1 << i + 1) - 1 : (1 << i) - 1;
            for (int j = n9 - 1; j >= n8; --j) {
                double d2;
                nArray2[j] = i == 0 ? (nArray2[j + 1] << 1 | 1) & (map.containsKey(Character.valueOf(string.charAt(j))) ? map.get(Character.valueOf(string.charAt(j))) : 0) : (nArray2[j + 1] << 1 | 1) & (map.containsKey(Character.valueOf(string.charAt(j))) ? map.get(Character.valueOf(string.charAt(j))) : 0) | (nArray[j + 1] << 1 | 1) | (nArray[j] << 1 | 1) | nArray[j + 1];
                if ((nArray2[j] & n4) == 0 || !((d2 = this.matchBitapScore(i, j, n, n2, string2)) <= d)) continue;
                d = d2;
                n3 = j;
                if (j <= n) break;
                n8 = Math.max(0, n - (j - n));
            }
            if (this.matchBitapScore(i + 1, n, n, n2, string2) > d) break;
            nArray = nArray2;
        }
        return n3;
    }

    private double matchBitapScore(int n, int n2, int n3, int n4, String string) {
        int n5 = Math.abs(n3 - n2);
        return (double)((float)n / (float)string.length() / this.matchBalance) + (double)((float)n5 / (float)n4) / (1.0 - (double)this.matchBalance);
    }

    /*
     * WARNING - void declaration
     */
    public Map<Character, Integer> matchAlphabet(String string) {
        void var7_11;
        char[] cArray;
        HashMap<Character, Integer> hashMap = new HashMap<Character, Integer>();
        for (char n : cArray = string.toCharArray()) {
            hashMap.put(Character.valueOf(n), 0);
        }
        int n = 0;
        char[] cArray2 = cArray;
        int n2 = cArray2.length;
        boolean bl = false;
        while (var7_11 < n2) {
            char c = cArray2[var7_11];
            hashMap.put(Character.valueOf(c), (Integer)hashMap.get(Character.valueOf(c)) | 1 << string.length() - n - 1);
            ++n;
            ++var7_11;
        }
        return hashMap;
    }

    public void patchAddContext(Patch patch, String string) {
        String string2;
        String string3 = string.substring(patch.start2, patch.start2 + patch.length1);
        int n = 0;
        while (string.indexOf(string3) != string.lastIndexOf(string3) && string3.length() < this.matchMaxBits - this.patchMargin - this.patchMargin) {
            string3 = string.substring(Math.max(0, patch.start2 - (n += this.patchMargin)), Math.min(string.length(), patch.start2 + patch.length1 + n));
        }
        String string4 = string.substring(Math.max(0, patch.start2 - (n += this.patchMargin)), patch.start2);
        if (string4.length() != 0) {
            patch.diffs.addFirst(new Diff(Operation.EQUAL, string4));
        }
        if ((string2 = string.substring(patch.start2 + patch.length1, Math.min(string.length(), patch.start2 + patch.length1 + n))).length() != 0) {
            patch.diffs.addLast(new Diff(Operation.EQUAL, string2));
        }
        patch.start1 -= string4.length();
        patch.start2 -= string4.length();
        patch.length1 += string4.length() + string2.length();
        patch.length2 += string4.length() + string2.length();
    }

    public LinkedList<Patch> patchMake(String string, String string2) {
        LinkedList<Diff> linkedList = this.diffMain(string, string2, true);
        if (linkedList.size() > 2) {
            this.diffCleanupSemantic(linkedList);
            this.diffCleanupEfficiency(linkedList);
        }
        return this.patchMake(string, linkedList);
    }

    public LinkedList<Patch> patchMake(LinkedList<Diff> linkedList) {
        String string = this.diffText1(linkedList);
        return this.patchMake(string, linkedList);
    }

    public LinkedList<Patch> patchMake(String string, LinkedList<Diff> linkedList) {
        LinkedList<Patch> linkedList2 = new LinkedList<Patch>();
        if (linkedList.isEmpty()) {
            return linkedList2;
        }
        Patch patch = new Patch();
        int n = 0;
        int n2 = 0;
        String string2 = string;
        String string3 = string;
        for (Diff diff : linkedList) {
            if (patch.diffs.isEmpty() && diff.operation != Operation.EQUAL) {
                patch.start1 = n;
                patch.start2 = n2;
            }
            switch (diff.operation) {
                case INSERT: {
                    patch.diffs.add(diff);
                    patch.length2 += diff.text.length();
                    string3 = string3.substring(0, n2) + diff.text + string3.substring(n2);
                    break;
                }
                case DELETE: {
                    patch.length1 += diff.text.length();
                    patch.diffs.add(diff);
                    string3 = string3.substring(0, n2) + string3.substring(n2 + diff.text.length());
                    break;
                }
                case EQUAL: {
                    if (diff.text.length() <= 2 * this.patchMargin && !patch.diffs.isEmpty() && diff != linkedList.getLast()) {
                        patch.diffs.add(diff);
                        patch.length1 += diff.text.length();
                        patch.length2 += diff.text.length();
                    }
                    if (diff.text.length() < 2 * this.patchMargin || patch.diffs.isEmpty()) break;
                    this.patchAddContext(patch, string2);
                    linkedList2.add(patch);
                    patch = new Patch();
                    string2 = string3;
                    n = n2;
                }
            }
            if (diff.operation != Operation.INSERT) {
                n += diff.text.length();
            }
            if (diff.operation == Operation.DELETE) continue;
            n2 += diff.text.length();
        }
        if (!patch.diffs.isEmpty()) {
            this.patchAddContext(patch, string2);
            linkedList2.add(patch);
        }
        return linkedList2;
    }

    protected LinkedList<Patch> patchDeepCopy(LinkedList<Patch> linkedList) {
        LinkedList<Patch> linkedList2 = new LinkedList<Patch>();
        for (Patch patch : linkedList) {
            Patch patch2 = new Patch();
            for (Diff diff : patch.diffs) {
                Diff diff2 = new Diff(diff.operation, diff.text);
                patch2.diffs.add(diff2);
            }
            patch2.start1 = patch.start1;
            patch2.start2 = patch.start2;
            patch2.length1 = patch.length1;
            patch2.length2 = patch.length2;
            linkedList2.add(patch2);
        }
        return linkedList2;
    }

    public Object[] patchApply(LinkedList<Patch> linkedList, String string) {
        if (linkedList.isEmpty()) {
            return new Object[]{string, new boolean[0]};
        }
        linkedList = this.patchDeepCopy(linkedList);
        String string2 = this.patchAddPadding(linkedList);
        string = string2 + string + string2;
        this.patchSplitMax(linkedList);
        int n = 0;
        int n2 = 0;
        boolean[] blArray = new boolean[linkedList.size()];
        for (Patch patch : linkedList) {
            int n3 = patch.start2 + n2;
            String string3 = this.diffText1(patch.diffs);
            int n4 = this.matchMain(string, string3, n3);
            if (n4 == -1) {
                blArray[n] = false;
            } else {
                blArray[n] = true;
                n2 = n4 - n3;
                String string4 = string.substring(n4, Math.min(n4 + string3.length(), string.length()));
                if (string3.equals(string4)) {
                    string = string.substring(0, n4) + this.diffText2(patch.diffs) + string.substring(n4 + string3.length());
                } else {
                    LinkedList<Diff> linkedList2 = this.diffMain(string3, string4, false);
                    this.diffCleanupSemanticLossless(linkedList2);
                    int n5 = 0;
                    for (Diff diff : patch.diffs) {
                        if (diff.operation != Operation.EQUAL) {
                            int n6 = this.diffXIndex(linkedList2, n5);
                            if (diff.operation == Operation.INSERT) {
                                string = string.substring(0, n4 + n6) + diff.text + string.substring(n4 + n6);
                            } else if (diff.operation == Operation.DELETE) {
                                string = string.substring(0, n4 + n6) + string.substring(n4 + this.diffXIndex(linkedList2, n5 + diff.text.length()));
                            }
                        }
                        if (diff.operation == Operation.DELETE) continue;
                        n5 += diff.text.length();
                    }
                }
            }
            ++n;
        }
        string = string.substring(string2.length(), string.length() - string2.length());
        return new Object[]{string, blArray};
    }

    public String patchAddPadding(LinkedList<Patch> linkedList) {
        int n;
        String string = "";
        for (int i = 0; i < this.patchMargin; ++i) {
            string = string + String.valueOf((char)i);
        }
        for (Patch object2 : linkedList) {
            object2.start1 += string.length();
            object2.start2 += string.length();
        }
        Object object3 = linkedList.getFirst();
        LinkedList<Diff> linkedList2 = ((Patch)object3).diffs;
        if (linkedList2.isEmpty() || linkedList2.getFirst().operation != Operation.EQUAL) {
            linkedList2.addFirst(new Diff(Operation.EQUAL, string));
            ((Patch)object3).start1 -= string.length();
            ((Patch)object3).start2 -= string.length();
            ((Patch)object3).length1 += string.length();
            ((Patch)object3).length2 += string.length();
        } else if (string.length() > linkedList2.getFirst().text.length()) {
            Diff diff = linkedList2.getFirst();
            n = string.length() - diff.text.length();
            diff.text = string.substring(diff.text.length()) + diff.text;
            ((Patch)object3).start1 -= n;
            ((Patch)object3).start2 -= n;
            ((Patch)object3).length1 += n;
            ((Patch)object3).length2 += n;
        }
        object3 = linkedList.getLast();
        linkedList2 = ((Patch)object3).diffs;
        if (linkedList2.isEmpty() || linkedList2.getLast().operation != Operation.EQUAL) {
            linkedList2.addLast(new Diff(Operation.EQUAL, string));
            ((Patch)object3).length1 += string.length();
            ((Patch)object3).length2 += string.length();
        } else if (string.length() > linkedList2.getLast().text.length()) {
            Diff diff = linkedList2.getLast();
            n = string.length() - diff.text.length();
            diff.text = diff.text + string.substring(0, n);
            ((Patch)object3).length1 += n;
            ((Patch)object3).length2 += n;
        }
        return string;
    }

    public void patchSplitMax(LinkedList<Patch> linkedList) {
        Patch patch;
        ListIterator<Patch> listIterator = linkedList.listIterator();
        Patch patch2 = patch = listIterator.hasNext() ? (Patch)listIterator.next() : null;
        while (patch != null) {
            if (patch.length1 <= this.matchMaxBits) {
                patch = listIterator.hasNext() ? (Patch)listIterator.next() : null;
                continue;
            }
            listIterator.remove();
            int n = this.matchMaxBits;
            int n2 = patch.start1;
            int n3 = patch.start2;
            String string = "";
            while (!patch.diffs.isEmpty()) {
                Patch patch3 = new Patch();
                boolean bl = true;
                patch3.start1 = n2 - string.length();
                patch3.start2 = n3 - string.length();
                if (string.length() != 0) {
                    patch3.length1 = patch3.length2 = string.length();
                    patch3.diffs.add(new Diff(Operation.EQUAL, string));
                }
                while (!patch.diffs.isEmpty() && patch3.length1 < n - this.patchMargin) {
                    Operation operation = patch.diffs.getFirst().operation;
                    String string2 = patch.diffs.getFirst().text;
                    if (operation == Operation.INSERT) {
                        patch3.length2 += string2.length();
                        n3 += string2.length();
                        patch3.diffs.addLast(patch.diffs.removeFirst());
                        bl = false;
                        continue;
                    }
                    string2 = string2.substring(0, Math.min(string2.length(), n - patch3.length1 - this.patchMargin));
                    patch3.length1 += string2.length();
                    n2 += string2.length();
                    if (operation == Operation.EQUAL) {
                        patch3.length2 += string2.length();
                        n3 += string2.length();
                    } else {
                        bl = false;
                    }
                    patch3.diffs.add(new Diff(operation, string2));
                    if (string2.equals(patch.diffs.getFirst().text)) {
                        patch.diffs.removeFirst();
                        continue;
                    }
                    patch.diffs.getFirst().text = patch.diffs.getFirst().text.substring(string2.length());
                }
                string = this.diffText2(patch3.diffs);
                string = string.substring(Math.max(0, string.length() - this.patchMargin));
                String string3 = this.diffText1(patch.diffs).length() > this.patchMargin ? this.diffText1(patch.diffs).substring(0, this.patchMargin) : this.diffText1(patch.diffs);
                if (string3.length() != 0) {
                    patch3.length1 += string3.length();
                    patch3.length2 += string3.length();
                    if (!patch3.diffs.isEmpty() && patch3.diffs.getLast().operation == Operation.EQUAL) {
                        patch3.diffs.getLast().text = patch3.diffs.getLast().text + string3;
                    } else {
                        patch3.diffs.add(new Diff(Operation.EQUAL, string3));
                    }
                }
                if (bl) continue;
                listIterator.add(patch3);
            }
            patch = listIterator.hasNext() ? (Patch)listIterator.next() : null;
        }
    }

    public String patchToText(List<Patch> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Patch patch : list) {
            stringBuilder.append(patch);
        }
        return stringBuilder.toString();
    }

    public List<Patch> patchFromText(String string) throws IllegalArgumentException {
        LinkedList<Patch> linkedList = new LinkedList<Patch>();
        if (string.length() == 0) {
            return linkedList;
        }
        List<String> list = Arrays.asList(string.split("\n"));
        LinkedList<String> linkedList2 = new LinkedList<String>(list);
        Pattern pattern = Pattern.compile("^@@ -(\\d+),?(\\d*) \\+(\\d+),?(\\d*) @@$");
        block5: while (!linkedList2.isEmpty()) {
            Matcher matcher = pattern.matcher(linkedList2.getFirst());
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid patch string: " + linkedList2.getFirst());
            }
            Patch patch = new Patch();
            linkedList.add(patch);
            patch.start1 = Integer.parseInt(matcher.group(1));
            if (matcher.group(2).length() == 0) {
                --patch.start1;
                patch.length1 = 1;
            } else if (matcher.group(2).equals("0")) {
                patch.length1 = 0;
            } else {
                --patch.start1;
                patch.length1 = Integer.parseInt(matcher.group(2));
            }
            patch.start2 = Integer.parseInt(matcher.group(3));
            if (matcher.group(4).length() == 0) {
                --patch.start2;
                patch.length2 = 1;
            } else if (matcher.group(4).equals("0")) {
                patch.length2 = 0;
            } else {
                --patch.start2;
                patch.length2 = Integer.parseInt(matcher.group(4));
            }
            linkedList2.removeFirst();
            while (!linkedList2.isEmpty()) {
                char c;
                try {
                    c = linkedList2.getFirst().charAt(0);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    linkedList2.removeFirst();
                    continue;
                }
                String string2 = linkedList2.getFirst().substring(1);
                string2 = string2.replace("+", "%2B");
                try {
                    string2 = URLDecoder.decode(string2, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new Error("This system does not support UTF-8.", unsupportedEncodingException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException("Illegal escape in patchFromText: " + string2, illegalArgumentException);
                }
                if (c == '-') {
                    patch.diffs.add(new Diff(Operation.DELETE, string2));
                } else if (c == '+') {
                    patch.diffs.add(new Diff(Operation.INSERT, string2));
                } else if (c == ' ') {
                    patch.diffs.add(new Diff(Operation.EQUAL, string2));
                } else {
                    if (c == '@') continue block5;
                    throw new IllegalArgumentException("Invalid patch mode '" + c + "' in: " + string2);
                }
                linkedList2.removeFirst();
            }
        }
        return linkedList;
    }

    private static String unescapeForEncodeUriCompatability(String string) {
        return string.replace("%21", "!").replace("%7E", "~").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%3B", ";").replace("%2F", "/").replace("%3F", "?").replace("%3A", ":").replace("%40", "@").replace("%26", "&").replace("%3D", "=").replace("%2B", "+").replace("%24", "$").replace("%2C", ",").replace("%23", "#");
    }

    public static class Patch {
        public LinkedList<Diff> diffs = new LinkedList();
        public int start1;
        public int start2;
        public int length1;
        public int length2;

        public String toString() {
            String string = this.length1 == 0 ? this.start1 + ",0" : (this.length1 == 1 ? Integer.toString(this.start1 + 1) : this.start1 + 1 + "," + this.length1);
            String string2 = this.length2 == 0 ? this.start2 + ",0" : (this.length2 == 1 ? Integer.toString(this.start2 + 1) : this.start2 + 1 + "," + this.length2);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("@@ -").append(string).append(" +").append(string2).append(" @@\n");
            for (Diff diff : this.diffs) {
                switch (diff.operation) {
                    case INSERT: {
                        stringBuilder.append('+');
                        break;
                    }
                    case DELETE: {
                        stringBuilder.append('-');
                        break;
                    }
                    case EQUAL: {
                        stringBuilder.append(' ');
                    }
                }
                try {
                    stringBuilder.append(URLEncoder.encode(diff.text, "UTF-8").replace('+', ' ')).append("\n");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new Error("This system does not support UTF-8.", unsupportedEncodingException);
                }
            }
            return DiffMatchPatch.unescapeForEncodeUriCompatability(stringBuilder.toString());
        }
    }

    public static class Diff {
        public Operation operation;
        public String text;

        public Diff(Operation operation, String string) {
            this.operation = operation;
            this.text = string;
        }

        public String toString() {
            String string = this.text.replace('\n', '\u00b6');
            return "Diff(" + (Object)((Object)this.operation) + ",\"" + string + "\")";
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            try {
                return ((Diff)object).operation == this.operation && ((Diff)object).text.equals(this.text);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.operation == null ? 0 : this.operation.hashCode());
            n = 31 * n + (this.text == null ? 0 : this.text.hashCode());
            return n;
        }
    }

    public static enum Operation {
        DELETE,
        INSERT,
        EQUAL;

    }
}

