/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import jd.nutils.io.JDIO;
import jd.nutils.io.Signature;
import jd.utils.JDUtilities;
import org.appwork.utils.Regex;

public class FileSignatures {
    private static final Signature SIG_TXT = new Signature("TXTfile", null, "Plaintext", ".*\\.(txt|doc|nfo|html|htm|xml)");
    private static Signature[] SIGNATURES;

    public static Signature getFileSignature(File file) throws IOException {
        return FileSignatures.getSignature(FileSignatures.readFileSignature(file));
    }

    public static String readFileSignature(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            int n = fileInputStream.read();
            String string = Integer.toHexString(n);
            if (string.length() < 2) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
        }
        fileInputStream.close();
        return stringBuilder.toString();
    }

    public static Signature[] getSignatureList() {
        if (SIGNATURES != null) {
            return SIGNATURES;
        }
        String[] stringArray = Regex.getLines(JDIO.readFileToString(JDUtilities.getResourceFile("jd/mime.type")));
        SIGNATURES = new Signature[stringArray.length];
        int n = 0;
        for (String string : stringArray) {
            String[] stringArray2 = string.split(":::");
            if (stringArray2.length >= 5) {
                FileSignatures.SIGNATURES[n++] = new Signature(stringArray2[0], stringArray2[1], stringArray2[2], stringArray2[3], stringArray2[4]);
                continue;
            }
            if (stringArray2.length >= 4) {
                FileSignatures.SIGNATURES[n++] = new Signature(stringArray2[0], stringArray2[1], stringArray2[2], stringArray2[3]);
                continue;
            }
            System.err.println("Signature " + string + " invalid!");
        }
        return SIGNATURES;
    }

    public static Signature getSignature(String string) {
        Signature[] signatureArray;
        for (Signature signature : signatureArray = FileSignatures.getSignatureList()) {
            if (signature == null || !signature.matches(string)) continue;
            return signature;
        }
        return FileSignatures.checkTxt(string);
    }

    public static Signature checkTxt(String string) {
        for (int i = 0; i < string.length(); i += 2) {
            if (i + 2 > string.length()) {
                return null;
            }
            String string2 = string.substring(i, i + 2);
            int n = Integer.parseInt(string2, 16);
            if (n >= 32 && n <= 126) continue;
            return null;
        }
        return SIG_TXT;
    }
}

