/*
 * Decompiled with CFR 0.152.
 */
package jd.parser.html;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jd.http.requests.RequestVariable;
import jd.parser.Regex;
import jd.parser.html.InputField;
import jd.utils.EditDistance;
import org.appwork.utils.logging.Log;

public class Form {
    private static final long serialVersionUID = 5837247484638868257L;
    private String action;
    private ArrayList<InputField> inputfields;
    private String htmlcode = null;
    private MethodType method = MethodType.GET;
    private String encoding = "application/x-www-form-urlencoded";
    private InputField preferredSubmit;
    private final HashMap<String, String> keyValueMap;

    public static Form[] getForms(Object object) {
        LinkedList<Form> linkedList = new LinkedList<Form>();
        Pattern pattern = Pattern.compile("<[\\s]*form(.*?)>(.*?)<[\\s]*/[\\s]*form[\\s]*>|<[\\s]*form(.*?)>(.+)", 34);
        Matcher matcher = pattern.matcher(object.toString().replaceAll("(?s)<!--.*?-->", ""));
        while (matcher.find()) {
            String string = matcher.group(0);
            Form form = new Form(string);
            linkedList.add(form);
        }
        return linkedList.toArray(new Form[linkedList.size()]);
    }

    public Form() {
        this.inputfields = new ArrayList();
        this.keyValueMap = new HashMap();
    }

    public Form(String string) {
        this();
        this.parse(string);
    }

    public void addInputField(InputField inputField) {
        this.inputfields.add(inputField);
    }

    public void addInputFieldAt(InputField inputField, int n) {
        this.inputfields.add(n, inputField);
    }

    public boolean containsHTML(String string) {
        return new Regex(this.htmlcode, string).matches();
    }

    public boolean equalsIgnoreCase(Form form) {
        return this.toString().equalsIgnoreCase(form.toString());
    }

    public String getAction() {
        return this.action;
    }

    public String getAction(String string) {
        URL uRL = null;
        if (string == null) {
            uRL = null;
        } else {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                Log.exception(malformedURLException);
            }
        }
        String string2 = this.action;
        if (this.action == null || this.action.matches("[\\s]*")) {
            if (uRL == null) {
                return null;
            }
            string2 = uRL.toString();
        } else if (!string2.matches("https?://.*")) {
            String string3;
            String string4;
            String string5;
            String string6;
            if (uRL == null) {
                return null;
            }
            string2 = string2.charAt(0) == '/' ? (uRL.getPort() > 0 && uRL.getPort() != 80 ? "http://" + uRL.getHost() + ":" + uRL.getPort() + string2 : "http://" + uRL.getHost() + string2) : (string2.charAt(0) == '&' ? ((string6 = uRL.toString()).matches("http://.*/.*") ? string6 + string2 : string6 + "/" + string2) : (string2.charAt(0) == '?' ? ((string5 = uRL.toString()).matches("http://.*/.*") ? string5.replaceFirst("\\?.*", "") + string2 : string5 + "/" + string2) : (string2.charAt(0) == '#' ? ((string4 = uRL.toString()).matches("http://.*/.*") ? string4 + string2 : string4 + "/" + string2) : ((string3 = uRL.toString()).matches("http://.*/.*") ? string3.substring(0, string3.lastIndexOf("/")) + "/" + string2 : string3 + "/" + string2))));
        }
        return string2;
    }

    public String getBestVariable(String string) {
        String string2 = null;
        int n = Integer.MAX_VALUE;
        for (InputField inputField : this.inputfields) {
            int n2 = EditDistance.getLevenshteinDistance(string, inputField.getKey());
            if (n2 >= n) continue;
            string2 = inputField.getKey();
            n = n2;
        }
        return string2;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getHtmlCode() {
        return this.htmlcode;
    }

    public InputField getInputField(String string) {
        for (InputField inputField : this.inputfields) {
            if (inputField.getKey() == null || !inputField.getKey().equalsIgnoreCase(string)) continue;
            return inputField;
        }
        return null;
    }

    public InputField getInputFieldByName(String string) {
        for (InputField inputField : this.inputfields) {
            if (inputField.getKey() == null || !inputField.getKey().equalsIgnoreCase(string)) continue;
            return inputField;
        }
        return null;
    }

    public InputField getInputFieldByProperty(String string) {
        for (InputField inputField : this.inputfields) {
            if (inputField.get(string) == null || !((String)inputField.get(string)).equalsIgnoreCase(string)) continue;
            return inputField;
        }
        return null;
    }

    public InputField getInputFieldByType(String string) {
        for (InputField inputField : this.inputfields) {
            if (inputField.getType() == null || !inputField.getType().equalsIgnoreCase(string)) continue;
            return inputField;
        }
        return null;
    }

    public ArrayList<InputField> getInputFields() {
        return this.inputfields;
    }

    public ArrayList<InputField> getInputFieldsByType(String string) {
        ArrayList<InputField> arrayList = new ArrayList<InputField>();
        for (InputField inputField : this.inputfields) {
            if (inputField.getType() == null || !org.appwork.utils.Regex.matches((Object)inputField.getType(), string)) continue;
            arrayList.add(inputField);
        }
        return arrayList;
    }

    public MethodType getMethod() {
        return this.method;
    }

    public InputField getPreferredSubmit() {
        return this.preferredSubmit;
    }

    public String getPropertyString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (InputField inputField : this.inputfields) {
            if (inputField.getKey() == null) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append("&");
            }
            stringBuilder.append(inputField.getKey());
            stringBuilder.append("=");
            stringBuilder.append(inputField.getValue());
        }
        return stringBuilder.toString();
    }

    public Regex getRegex(Pattern pattern) {
        return new Regex(this.htmlcode, pattern);
    }

    public Regex getRegex(String string) {
        return new Regex(this.htmlcode, string);
    }

    public ArrayList<RequestVariable> getRequestVariables() {
        ArrayList<RequestVariable> arrayList = new ArrayList<RequestVariable>();
        for (InputField inputField : this.inputfields) {
            if (this.getPreferredSubmit() != null && inputField.getType() != null && inputField.getType().equalsIgnoreCase("submit") && this.getPreferredSubmit() != inputField || inputField.getKey() == null || inputField.getValue() == null) continue;
            if (inputField.getType() != null && inputField.getType().equalsIgnoreCase("image")) {
                arrayList.add(new RequestVariable(inputField.getKey() + ".x", new Random().nextInt(100) + ""));
                arrayList.add(new RequestVariable(inputField.getKey() + ".y", new Random().nextInt(100) + ""));
                continue;
            }
            arrayList.add(new RequestVariable(inputField.getKey(), inputField.getValue()));
        }
        return arrayList;
    }

    public String getStringProperty(String string) {
        return this.keyValueMap.get(string);
    }

    public HashMap<String, String> getVarsMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (InputField inputField : this.inputfields) {
            if (inputField.getKey() == null) continue;
            hashMap.put(inputField.getKey(), inputField.getValue());
        }
        return hashMap;
    }

    public boolean hasInputFieldByName(String string) {
        return this.getInputFieldByName(string) != null;
    }

    private void parse(String string) {
        this.htmlcode = string;
        String string2 = new Regex(string, "<[\\s]*form(.*?)>").getMatch(0);
        String[][] stringArray = new Regex(string2, "[\"' ](\\w+?)[ ]*=[ ]*[\"'](.*?)[\"']").getMatches();
        String[][] stringArray2 = new Regex(string2, "[\"' ](\\w+?)[ ]*=[ ]*([^>^ ^\"^']+)").getMatches();
        this.parseHeader(stringArray);
        this.parseHeader(stringArray2);
        this.parseInputFields();
    }

    private void parseHeader(String[][] stringArray) {
        for (String[] stringArray2 : stringArray) {
            String string = stringArray2[0];
            String string2 = stringArray2[1];
            String string3 = string2.toLowerCase();
            if (string.equalsIgnoreCase("action")) {
                this.setAction(string2);
                continue;
            }
            if (string.equalsIgnoreCase("enctype")) {
                this.setEncoding(string2);
                continue;
            }
            if (string.equalsIgnoreCase("method")) {
                if (string3.matches(".*post.*")) {
                    this.setMethod(MethodType.POST);
                    continue;
                }
                if (string3.matches(".*get.*")) {
                    this.setMethod(MethodType.GET);
                    continue;
                }
                if (string3.matches(".*put.*")) {
                    this.setMethod(MethodType.PUT);
                    continue;
                }
                this.setMethod(MethodType.POST);
                continue;
            }
            this.setProperty(string, string2);
        }
    }

    private void parseInputFields() {
        this.inputfields = new ArrayList();
        Matcher matcher = Pattern.compile("(?s)(<[\\s]*(input|textarea|select).*?>)", 2).matcher(this.htmlcode);
        while (matcher.find()) {
            InputField inputField = InputField.parse(matcher.group(1));
            if (inputField == null) continue;
            this.addInputField(inputField);
        }
    }

    public void put(String string, String string2) {
        InputField inputField = this.getInputField(string);
        if (inputField != null) {
            inputField.setValue(string2);
        } else {
            this.inputfields.add(new InputField(string, string2));
        }
    }

    public void remove(String string) {
        Iterator<InputField> iterator = this.inputfields.iterator();
        while (iterator.hasNext()) {
            InputField inputField = iterator.next();
            if (inputField.getKey() == null && string == null) {
                iterator.remove();
                return;
            }
            if (inputField.getKey() == null || !inputField.getKey().equalsIgnoreCase(string)) continue;
            iterator.remove();
            return;
        }
    }

    public void setAction(String string) {
        this.action = string;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setMethod(MethodType methodType) {
        this.method = methodType;
    }

    public void setPreferredSubmit(int n) {
        this.preferredSubmit = null;
        for (InputField inputField : this.inputfields) {
            if (inputField.getType() == null || inputField.getValue() == null || !inputField.getType().equalsIgnoreCase("submit") || n-- > 0) continue;
            this.preferredSubmit = inputField;
            return;
        }
        throw new IllegalArgumentException("No such Submitfield: " + n);
    }

    public void setPreferredSubmit(String string) {
        this.preferredSubmit = null;
        for (InputField inputField : this.inputfields) {
            if (inputField.getType() == null || inputField.getValue() == null || !inputField.getType().equalsIgnoreCase("submit") || !inputField.getValue().equalsIgnoreCase(string)) continue;
            this.preferredSubmit = inputField;
            return;
        }
        Log.L.warning("No exact match for submit found! Trying to find best match now!");
        for (InputField inputField : this.inputfields) {
            if (inputField.getType() == null || inputField.getValue() == null || !inputField.getType().equalsIgnoreCase("submit") || !inputField.getValue().contains(string)) continue;
            this.preferredSubmit = inputField;
            return;
        }
        throw new IllegalArgumentException("No such Submitfield: " + string);
    }

    public void setProperty(String string, String string2) {
        this.keyValueMap.put(string, string2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Action: ");
        stringBuilder.append(this.action);
        stringBuilder.append('\n');
        if (this.method == MethodType.POST) {
            stringBuilder.append("Method: POST\n");
        } else if (this.method == MethodType.GET) {
            stringBuilder.append("Method: GET\n");
        } else if (this.method == MethodType.PUT) {
            stringBuilder.append("Method: PUT is not supported\n");
        } else if (this.method == MethodType.UNKNOWN) {
            stringBuilder.append("Method: Unknown\n");
        }
        for (InputField inputField : this.inputfields) {
            stringBuilder.append(inputField.toString());
            stringBuilder.append('\n');
        }
        stringBuilder.append(this.keyValueMap.toString());
        return stringBuilder.toString();
    }

    public static enum MethodType {
        GET,
        POST,
        PUT,
        UNKNOWN;

    }
}

