/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.hoster;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import jd.PluginWrapper;
import jd.config.Property;
import jd.http.Browser;
import jd.http.URLConnectionAdapter;
import jd.nutils.encoding.Encoding;
import jd.parser.Regex;
import jd.plugins.BrowserAdapter;
import jd.plugins.DownloadLink;
import jd.plugins.HostPlugin;
import jd.plugins.PluginException;
import jd.plugins.PluginForHost;
import jd.utils.locale.JDL;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.images.Artwork;
import org.jaudiotagger.tag.images.ArtworkFactory;

@HostPlugin(revision="$Revision$", interfaceVersion=2, names={"soundcloud.com"}, urls={"https://(www\\.)?soundclouddecrypted\\.com/[a-z\\-_0-9]+/[a-z\\-_0-9]+"}, flags={0})
public class SoundcloudCom
extends PluginForHost {
    private static final long MAX_ACCEPTABLE_SOUNDCLOUD_FILESIZE_FOR_COVERART_FETCH = 0xA00000L;
    private String url;
    public static final String CLIENTID = "b45b1aa10f1ac2941910a7f0d10f8e28";

    public SoundcloudCom(PluginWrapper pluginWrapper) {
        super(pluginWrapper);
    }

    @Override
    public void correctDownloadLink(DownloadLink downloadLink) {
        downloadLink.setUrlDownload(downloadLink.getDownloadURL().replace("soundclouddecrypted", "soundcloud"));
    }

    @Override
    public String getAGBLink() {
        return "http://soundcloud.com/terms-of-use";
    }

    @Override
    public int getMaxSimultanFreeDownloadNum() {
        return -1;
    }

    @Override
    public void handleFree(DownloadLink downloadLink) throws Exception {
        this.requestFileInformation(downloadLink);
        this.dl = BrowserAdapter.openDownload(this.br, downloadLink, this.url, true, 0);
        if (this.dl.getConnection().getContentType().contains("html")) {
            this.logger.warning("The final dllink seems not to be a file!");
            this.br.followConnection();
            throw new PluginException(0x400000);
        }
        if (this.dl.startDownload()) {
            this.postprocess(downloadLink);
        }
    }

    @Override
    public DownloadLink.AvailableStatus requestFileInformation(DownloadLink downloadLink) throws Exception {
        this.setBrowserExclusive();
        this.br.setFollowRedirects(true);
        this.url = downloadLink.getStringProperty("directlink");
        if (this.url != null) {
            this.checkDirectLink(downloadLink, this.url);
            if (this.url != null) {
                return DownloadLink.AvailableStatus.TRUE;
            }
        }
        this.br.getPage("https://api.sndcdn.com/resolve?url=" + Encoding.urlEncode(downloadLink.getDownloadURL()) + "&_status_code_map%5B302%5D=200&_status_format=json&client_id=" + CLIENTID);
        if (this.br.containsHTML("\"404 \\- Not Found\"")) {
            throw new PluginException(32);
        }
        DownloadLink.AvailableStatus availableStatus = this.checkStatus(downloadLink, this.br.toString());
        if (availableStatus.equals((Object)DownloadLink.AvailableStatus.FALSE)) {
            throw new PluginException(32);
        }
        if (this.url == null) {
            throw new PluginException(0x400000);
        }
        this.checkDirectLink(downloadLink, this.url);
        return DownloadLink.AvailableStatus.TRUE;
    }

    public DownloadLink.AvailableStatus checkStatus(DownloadLink downloadLink, String string) {
        String string2;
        String string3 = this.getXML("title", string);
        if (string3 == null) {
            downloadLink.getLinkStatus().setStatusText(JDL.L("plugins.hoster.SoundCloudCom.status.pluginBroken", "The host plugin is broken!"));
            return DownloadLink.AvailableStatus.FALSE;
        }
        String string4 = this.getXML("original-content-size", string);
        if (string4 != null) {
            downloadLink.setDownloadSize(Integer.parseInt(string4));
        }
        if ((string2 = this.getXML("description", string)) != null) {
            downloadLink.setComment(string2);
        }
        String string5 = this.getXML("username", string);
        string3 = Encoding.htmlDecode(string3.trim());
        String string6 = this.getXML("original-format", string);
        if (string6 == null) {
            string6 = "mp3";
        }
        if ((string5 = string5.trim()) != null && !string3.contains(string5)) {
            string3 = string3 + " - " + string5;
        }
        string3 = string3 + "." + string6;
        this.url = this.getXML("download-url", string);
        if (this.url != null) {
            downloadLink.getLinkStatus().setStatusText(JDL.L("plugins.hoster.SoundCloudCom.status.downloadavailable", "Original file is downloadable"));
        } else {
            this.url = this.getXML("stream-url", string);
            downloadLink.getLinkStatus().setStatusText(JDL.L("plugins.hoster.SoundCloudCom.status.previewavailable", "Preview (Stream) is downloadable"));
        }
        if (this.url == null) {
            downloadLink.getLinkStatus().setStatusText(JDL.L("plugins.hoster.SoundCloudCom.status.pluginBroken", "The host plugin is broken!"));
            return DownloadLink.AvailableStatus.FALSE;
        }
        string3 = this.cleanupFilename(string3);
        downloadLink.setFinalFileName(string3);
        downloadLink.setProperty("directlink", this.url + "?client_id=" + CLIENTID);
        return DownloadLink.AvailableStatus.TRUE;
    }

    private void checkDirectLink(DownloadLink downloadLink, String string) {
        try {
            Browser browser = this.br.cloneBrowser();
            URLConnectionAdapter uRLConnectionAdapter = browser.openGetConnection(this.url);
            if (uRLConnectionAdapter.getContentType().contains("html") || uRLConnectionAdapter.getLongContentLength() == -1L) {
                downloadLink.setProperty(string, Property.NULL);
                this.url = null;
                return;
            }
            downloadLink.setDownloadSize(uRLConnectionAdapter.getLongContentLength());
            uRLConnectionAdapter.disconnect();
        }
        catch (Exception exception) {
            downloadLink.setProperty(string, Property.NULL);
            this.url = null;
        }
    }

    private String getJson(String string) {
        return this.br.getRegex("\"" + string + "\":\"([^<>\"]*?)\"").getMatch(0);
    }

    public String getXML(String string, String string2) {
        return new Regex(string2, "<" + string + "( type=\"[^<>\"/]*?\")?>([^<>\"]*?)</" + string + ">").getMatch(1);
    }

    @Override
    public void reset() {
    }

    @Override
    public void resetDownloadlink(DownloadLink downloadLink) {
    }

    private void postprocess(DownloadLink downloadLink) {
        try {
            if (((Boolean)downloadLink.getProperty("setid3tag", "false")).booleanValue()) {
                String string = (String)downloadLink.getProperty("thumbnailUrl", null);
                String string2 = (String)downloadLink.getProperty("username", null);
                String string3 = (String)downloadLink.getProperty("title", null);
                String string4 = (String)downloadLink.getProperty("detailsUrl", null);
                File file = new File(downloadLink.getFileOutput());
                File file2 = new File(downloadLink.getFileOutput().replace(".mp3", "_id3.mp3"));
                this.downloadAndUpdateCoverArt(file, file2, string, string2, string3, string4);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void downloadAndUpdateCoverArt(File file, File file2, String string, String string2, String string3, String string4) {
        byte[] byArray;
        if (file != null && file.exists() && file.length() <= 0xA00000L && (byArray = this.downloadCoverArt(string)) != null && byArray.length > 0 && !this.setAlbumArt(byArray, file.getAbsolutePath(), file2.getAbsolutePath(), string2, string3, string4) && file2.exists()) {
            file2.delete();
        }
    }

    private byte[] downloadCoverArt(String string) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            SoundcloudCom.simpleHTTP(string, byteArrayOutputStream, 3000);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private boolean setAlbumArt(byte[] byArray, String string, String string2, String string3, String string4, String string5) {
        try {
            AudioFile audioFile = AudioFileIO.read((File)new File(string));
            Tag tag = audioFile.getTagOrCreateAndSetDefault();
            tag.setField(FieldKey.ALBUM, string3 + ": " + string4 + " via SoundCloud.com");
            tag.setField(FieldKey.ARTIST, string3);
            tag.setField(FieldKey.TITLE, string4);
            tag.setField(FieldKey.URL_OFFICIAL_RELEASE_SITE, string5);
            Artwork artwork = ArtworkFactory.getNew();
            artwork.setBinaryData(byArray);
            artwork.setMimeType("image/jpg");
            tag.addField(artwork);
            audioFile.commit();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private String cleanupFilename(String string) {
        if ((string = string.replace("&#8482;", "TM")).endsWith(".m4a")) {
            string = string.replace(".m4a", ".mp3");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void simpleHTTP(String string, OutputStream outputStream, int n) throws Throwable {
        URL uRL = new URL(string);
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setConnectTimeout(n);
        uRLConnection.setReadTimeout(n);
        InputStream inputStream = uRLConnection.getInputStream();
        try {
            byte[] byArray = new byte[1024];
            int n2 = 0;
            while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1) {
                outputStream.write(byArray, 0, n2);
            }
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Throwable throwable) {}
            try {
                inputStream.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

