/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.storage.InvalidTypeException;
import org.appwork.storage.JSONMapper;
import org.appwork.storage.JsonKeyValueStorage;
import org.appwork.storage.SimpleMapper;
import org.appwork.storage.Storable;
import org.appwork.storage.Storage;
import org.appwork.storage.StorageException;
import org.appwork.storage.TypeRef;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.crypto.Crypto;
import org.appwork.utils.logging.Log;
import org.appwork.utils.reflection.Clazz;
import sun.reflect.generics.reflectiveObjects.GenericArrayTypeImpl;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class JSonStorage {
    private static final HashMap<String, Storage> MAP = new HashMap();
    public static final Object LOCK = new Object();
    private static JSONMapper JSON_MAPPER = new SimpleMapper();
    public static byte[] KEY = new byte[]{1, 2, 17, 1, 1, 84, 1, 1, 1, 1, 18, 1, 1, 1, 34, 1};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addStorage(Storage storage) {
        HashMap<String, Storage> hashMap = MAP;
        synchronized (hashMap) {
            Storage storage2 = MAP.get(storage.getID());
            if (storage2 == null) {
                MAP.put(storage.getID(), storage);
                return true;
            }
            return false;
        }
    }

    public static void canStore(Type type) throws InvalidTypeException {
        JSonStorage.canStoreIntern(type, type.toString());
    }

    private static void canStoreIntern(Type type, String string) throws InvalidTypeException {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz == Void.TYPE) {
                throw new InvalidTypeException(type, "Void is not accepted: " + string);
            }
            if (clazz.isPrimitive()) {
                return;
            }
            if (clazz == Boolean.class || clazz == Long.class || clazz == Integer.class || clazz == Byte.class || clazz == Double.class || clazz == Float.class || clazz == String.class) {
                return;
            }
            if (clazz.isEnum()) {
                return;
            }
            if (clazz.isArray()) {
                Class<?> clazz2 = clazz.getComponentType();
                JSonStorage.canStoreIntern(clazz2, string + "[" + clazz2 + "]");
                return;
            }
            if (Storable.class.isAssignableFrom(clazz)) {
                try {
                    clazz.getDeclaredConstructor(new Class[0]);
                    for (Method method : clazz.getDeclaredMethods()) {
                        if (method.getName().startsWith("get")) {
                            if (method.getParameterTypes().length > 0) {
                                throw new InvalidTypeException(type, "Getter " + string + "." + method + " has parameters.");
                            }
                            JSonStorage.canStoreIntern(method.getGenericReturnType(), string + "->" + method.getGenericReturnType());
                            continue;
                        }
                        if (!method.getName().startsWith("set") || method.getParameterTypes().length == 1) continue;
                        throw new InvalidTypeException(type, "Setter " + string + "." + method + " has != 1 Parameters.");
                    }
                    return;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new InvalidTypeException(type, "Storable " + string + " has no empty Constructor");
                }
            }
            if (List.class.isAssignableFrom(clazz)) {
                return;
            }
            if (Map.class.isAssignableFrom(clazz)) {
                return;
            }
        } else {
            if (type instanceof ParameterizedTypeImpl) {
                ParameterizedTypeImpl parameterizedTypeImpl = (ParameterizedTypeImpl)type;
                Type type2 = ((ParameterizedTypeImpl)type).getRawType();
                JSonStorage.canStoreIntern(type2, string);
                for (Type type3 : parameterizedTypeImpl.getActualTypeArguments()) {
                    JSonStorage.canStoreIntern(type3, string + "(" + type3 + ")");
                }
                return;
            }
            if (type instanceof GenericArrayTypeImpl) {
                GenericArrayTypeImpl genericArrayTypeImpl = (GenericArrayTypeImpl)type;
                Type type4 = genericArrayTypeImpl.getGenericComponentType();
                JSonStorage.canStoreIntern(type4, string + "[" + type4 + "]");
                return;
            }
            throw new InvalidTypeException(type, "Generic Type Structure not implemented: " + type.getClass() + " in " + string);
        }
        throw new InvalidTypeException(type, "Type " + string + " is not supported.");
    }

    public static boolean canStorePrimitive(Class<?> clazz) {
        return Clazz.isPrimitive(clazz) || clazz == String.class || clazz.isEnum();
    }

    public static JSONMapper getMapper() {
        return JSON_MAPPER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Storage getPlainStorage(File file) throws StorageException {
        HashMap<String, Storage> hashMap = MAP;
        synchronized (hashMap) {
            String string = file.getAbsolutePath();
            Storage storage = MAP.get(string);
            if (storage == null) {
                storage = new JsonKeyValueStorage(file, true);
                MAP.put(storage.getID(), storage);
            }
            return storage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Storage getPlainStorage(String string) throws StorageException {
        HashMap<String, Storage> hashMap = MAP;
        synchronized (hashMap) {
            String string2 = Application.getResource("cfg/" + string + ".json").getAbsolutePath();
            Storage storage = MAP.get(string2);
            if (storage == null) {
                storage = new JsonKeyValueStorage(string, true);
                MAP.put(storage.getID(), storage);
            }
            return storage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Storage getStorage(String string) throws StorageException {
        HashMap<String, Storage> hashMap = MAP;
        synchronized (hashMap) {
            String string2 = Application.getResource("cfg/" + string + ".ejs").getAbsolutePath();
            Storage storage = MAP.get(string2);
            if (storage == null) {
                storage = new JsonKeyValueStorage(string);
                MAP.put(storage.getID(), storage);
            }
            return storage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeStorage(Storage storage) {
        HashMap<String, Storage> hashMap = MAP;
        synchronized (hashMap) {
            Storage storage2 = MAP.remove(storage.getID());
            return storage2 != null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <E> E restoreFrom(File file, boolean bl, byte[] byArray, TypeRef<E> typeRef, E e) {
        Object object = LOCK;
        synchronized (object) {
            String string = null;
            byte[] byArray2 = null;
            try {
                File file2;
                File file3 = new File(file.getAbsolutePath() + ".tmp");
                if (file3.exists() && file3.length() > 0L) {
                    Log.L.warning("TMP file " + file3.getAbsolutePath() + " found");
                    try {
                        E e2;
                        byArray2 = IO.readFile(file3);
                        if (bl) {
                            string = new String(byArray2, "UTF-8");
                            e2 = JSonStorage.restoreFromString(string, typeRef, e);
                        } else {
                            string = Crypto.decrypt(byArray2, byArray);
                            e2 = JSonStorage.restoreFromString(string, typeRef, e);
                        }
                        Log.L.warning("Could restore tmp file");
                        file.delete();
                        file3.renameTo(file);
                        if (e2 == null) {
                            E e3 = e;
                            return e3;
                        }
                        E e4 = e2;
                        return e4;
                    }
                    catch (Exception exception) {
                        Log.L.warning("Could not restore tmp file");
                        Log.exception(Level.WARNING, exception);
                    }
                    finally {
                        file3.delete();
                    }
                }
                if (!(file2 = file).exists() || file2.length() == 0L) {
                    return e;
                }
                byArray2 = IO.readFile(file2);
                if (bl) {
                    string = new String(byArray2, "UTF-8");
                    return JSonStorage.restoreFromString(string, typeRef, e);
                }
                string = Crypto.decrypt(byArray2, byArray);
                return JSonStorage.restoreFromString(string, typeRef, e);
            }
            catch (Throwable throwable) {
                Log.L.warning(file.getAbsolutePath() + ":read:" + string);
                try {
                    if (byArray2 != null) {
                        Log.L.severe(file.getAbsolutePath() + ":original:" + new String(byArray2, "UTF-8"));
                    }
                }
                catch (Throwable throwable2) {
                    Log.exception(throwable2);
                }
                Log.exception(throwable);
                return e;
            }
        }
    }

    public static <E> E restoreFrom(File file, E e) {
        E e2 = JSonStorage.restoreFrom(file, true, null, null, e);
        if (e2 == null) {
            return e;
        }
        return e2;
    }

    public static <E> E restoreFrom(String string, E e) {
        boolean bl = string.toLowerCase().endsWith(".json");
        return JSonStorage.restoreFrom(Application.getResource(string), bl, KEY, null, e);
    }

    public static <E> E restoreFrom(String string, TypeRef<E> typeRef, E e) {
        boolean bl = string.toLowerCase().endsWith(".json");
        return JSonStorage.restoreFrom(Application.getResource(string), bl, KEY, typeRef, e);
    }

    public static <T> T restoreFromString(String string, Class<T> clazz) throws StorageException {
        Object object = LOCK;
        synchronized (object) {
            T t;
            try {
                t = JSON_MAPPER.stringToObject(string, clazz);
            }
            catch (Exception exception) {
                throw new StorageException(string, exception);
            }
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> E restoreFromString(String string, TypeRef<E> typeRef) {
        if (string == null || "".equals(string)) {
            return null;
        }
        Object object = LOCK;
        synchronized (object) {
            return JSON_MAPPER.stringToObject(string, typeRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> E restoreFromString(byte[] byArray, boolean bl, byte[] byArray2, TypeRef<E> typeRef, E e) {
        if (byArray == null) {
            return e;
        }
        String string = null;
        try {
            string = !bl ? Crypto.decrypt(byArray, byArray2) : new String(byArray, "UTF-8");
            Object object = LOCK;
            synchronized (object) {
                if (typeRef != null) {
                    return JSON_MAPPER.stringToObject(string, typeRef);
                }
                return (E)JSON_MAPPER.stringToObject(string, e.getClass());
            }
        }
        catch (Exception exception) {
            Log.exception(Level.WARNING, exception);
            Log.L.warning(string);
            return e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> E restoreFromString(String string, TypeRef<E> typeRef, E e) {
        if (string == null || "".equals(string)) {
            return e;
        }
        try {
            Object object = LOCK;
            synchronized (object) {
                if (typeRef != null) {
                    return JSON_MAPPER.stringToObject(string, typeRef);
                }
                return (E)JSON_MAPPER.stringToObject(string, e.getClass());
            }
        }
        catch (Exception exception) {
            Log.L.warning("Error parsing String: " + string);
            Log.exception(Level.WARNING, exception);
            return e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save() {
        Log.L.config("Start Saving Storage");
        HashMap<String, Storage> hashMap = MAP;
        synchronized (hashMap) {
            for (Map.Entry<String, Storage> entry : MAP.entrySet()) {
                try {
                    entry.getValue().save();
                }
                catch (Throwable throwable) {
                    Log.exception(throwable);
                }
                finally {
                    try {
                        entry.getValue().close();
                    }
                    catch (Throwable throwable) {
                        Log.exception(throwable);
                    }
                }
            }
        }
        Log.L.config("ENDED Saving Storage");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveTo(File file, boolean bl, byte[] byArray, String string) throws StorageException {
        Object object = LOCK;
        synchronized (object) {
            try {
                File file2 = new File(file.getAbsolutePath() + ".tmp");
                file2.getParentFile().mkdirs();
                file2.delete();
                if (bl) {
                    IO.writeToFile(file2, string.getBytes("UTF-8"));
                } else {
                    IO.writeToFile(file2, Crypto.encrypt(string, byArray));
                }
                if (file.exists() && !file.delete()) {
                    throw new StorageException("Could not overwrite file: " + file.getAbsolutePath());
                }
                if (!file2.renameTo(file)) {
                    throw new StorageException("Could not rename file: " + file2 + " to " + file);
                }
            }
            catch (IOException iOException) {
                throw new StorageException(iOException);
            }
        }
    }

    public static void saveTo(File file, Object object) {
        boolean bl = file.getName().toLowerCase().endsWith(".json");
        JSonStorage.saveTo(file, bl, KEY, JSonStorage.serializeToJson(object));
    }

    public static void saveTo(String string, String string2) throws StorageException {
        JSonStorage.saveTo(string, string2, KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveTo(String string, String string2, byte[] byArray) {
        Object object = LOCK;
        synchronized (object) {
            try {
                File file = Application.getResource(string);
                File file2 = new File(file.getParentFile(), file.getName() + ".tmp");
                file2.getParentFile().mkdirs();
                file2.delete();
                if (new Regex(string, ".+\\.json").matches()) {
                    IO.writeToFile(file2, string2.getBytes("UTF-8"));
                } else {
                    IO.writeToFile(file2, Crypto.encrypt(string2, byArray));
                }
                if (file.exists() && !file.delete()) {
                    throw new StorageException("Could not overwrite file: " + file);
                }
                if (!file2.renameTo(file)) {
                    throw new StorageException("Could not rename file: " + file2 + " to " + file);
                }
            }
            catch (IOException iOException) {
                throw new StorageException(iOException);
            }
        }
    }

    public static String serializeToJson(Object object) throws StorageException {
        Object object2 = LOCK;
        synchronized (object2) {
            try {
                String string = JSON_MAPPER.objectToString(object);
                return string;
            }
            catch (Exception exception) {
                throw new StorageException(exception);
            }
        }
    }

    public static void setMapper(JSONMapper jSONMapper) {
        JSON_MAPPER = jSONMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeTo(String string, Object object) {
        Object object2 = LOCK;
        synchronized (object2) {
            try {
                JSonStorage.saveTo(string, JSonStorage.serializeToJson(object));
            }
            catch (Exception exception) {
                throw new StorageException(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Object object) {
        Object object2 = LOCK;
        synchronized (object2) {
            try {
                return JSON_MAPPER.objectToString(object);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return object.toString();
            }
        }
    }

    static {
        ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

            @Override
            public int getHookPriority() {
                return 0;
            }

            @Override
            public void run() {
                JSonStorage.save();
            }

            @Override
            public String toString() {
                return "JSonStorage";
            }
        });
    }
}

