/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.Regex;
import org.appwork.utils.logging.Log;
import org.appwork.utils.os.CrossSystem;

public class Application {
    private static String APP_FOLDER;
    private static String ROOT;
    private static long javaVersion;
    public static long JAVA15;
    public static long JAVA16;
    public static long JAVA17;
    private static boolean REDIRECTED;

    public static void addFolderToClassPath(File file) throws IOException {
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)Application.class.getClassLoader(), file.toURI().toURL());
        }
        catch (Throwable throwable) {
            Log.exception(throwable);
            throw new IOException("Error, could not add URL to system classloader");
        }
    }

    public static void addUrlToClassPath(URL uRL, ClassLoader classLoader) throws IOException {
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)classLoader, uRL);
        }
        catch (Throwable throwable) {
            Log.exception(throwable);
            throw new IOException("Error, could not add URL to system classloader");
        }
    }

    public static String getApplication() {
        return APP_FOLDER;
    }

    public static File getApplicationRoot() {
        return Application.getRootByClass(Application.class, null);
    }

    public static String getHome() {
        return Application.getRoot(Application.class);
    }

    public static URL getHomeURL() {
        try {
            return new File(Application.getHome()).toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new WTFException(malformedURLException);
        }
    }

    public static long getJavaVersion() {
        if (javaVersion > 0L) {
            return javaVersion;
        }
        try {
            String string = System.getProperty("java.version");
            String string2 = new Regex(string, "^(\\d+\\.\\d+\\.\\d+)").getMatch(0);
            String string3 = new Regex(string, "^.*?_(\\d+)").getMatch(0);
            String string4 = new Regex(string, "^.*?_b(\\d+)").getMatch(0);
            string2 = string2.replaceAll("\\.", "");
            long l = Long.parseLong(string2) * 100000L;
            if (string3 != null) {
                l += Long.parseLong(string3) * 1000L;
            }
            if (string4 != null) {
                l += Long.parseLong(string4);
            }
            javaVersion = l;
            return l;
        }
        catch (Exception exception) {
            Log.exception(exception);
            return -1L;
        }
    }

    public static String getPackagePath(Class<?> clazz) {
        return clazz.getPackage().getName().replace('.', '/') + "/";
    }

    public static File getResource(String string) {
        return new File(Application.getHome(), string);
    }

    public static URL getRessourceURL(String string) {
        return Application.getRessourceURL(string, true);
    }

    public static URL getRessourceURL(String string, boolean bl) {
        try {
            if (string == null) {
                return null;
            }
            if (string.startsWith("/") || string.startsWith("\\")) {
                throw new WTFException("getRessourceURL only works with relative pathes.");
            }
            if (bl) {
                URL uRL = Application.class.getClassLoader().getResource(string);
                if (uRL != null) {
                    return uRL;
                }
                File file = new File(Application.getHome(), string);
                if (!file.exists()) {
                    return null;
                }
                return file.toURI().toURL();
            }
            File file = new File(Application.getHome(), string);
            if (file.exists()) {
                return file.toURI().toURL();
            }
            URL uRL = Application.class.getClassLoader().getResource(string);
            if (uRL != null) {
                return uRL;
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        return null;
    }

    public static String getRoot(Class<?> clazz) {
        if (ROOT != null) {
            return ROOT;
        }
        if (Application.isJared(clazz)) {
            URL uRL = clazz.getProtectionDomain().getCodeSource().getLocation();
            try {
                File file = new File(uRL.toURI());
                if (file.isFile()) {
                    file = file.getParentFile();
                }
                ROOT = file.getAbsolutePath();
            }
            catch (URISyntaxException uRISyntaxException) {
                Log.exception(uRISyntaxException);
                ROOT = System.getProperty("user.home") + System.getProperty("file.separator") + APP_FOLDER + System.getProperty("file.separator");
            }
        } else {
            ROOT = System.getProperty("user.home") + System.getProperty("file.separator") + APP_FOLDER + System.getProperty("file.separator");
        }
        return ROOT;
    }

    public static File getRootByClass(Class<?> clazz, String string) {
        URL uRL = clazz.getProtectionDomain().getCodeSource().getLocation();
        try {
            File file = new File(uRL.toURI());
            if (file.isFile()) {
                file = file.getParentFile();
            }
            if (string != null) {
                return new File(file, string);
            }
            return file;
        }
        catch (URISyntaxException uRISyntaxException) {
            Log.exception(uRISyntaxException);
            return null;
        }
    }

    public static URL getRootUrlByClass(Class<?> clazz, String string) {
        try {
            return Application.getRootByClass(clazz, string).toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    public static boolean isJared(Class<?> clazz) {
        String string = clazz.getName().replaceAll("\\.", "/") + ".class";
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            Log.L.severe("getContextClassLoader() is null");
            return true;
        }
        URL uRL = classLoader.getResource(string);
        if (uRL == null) {
            return false;
        }
        return uRL.toString().matches("jar\\:.*\\.(jar|exe)\\!.*");
    }

    public static boolean isOutdatedJavaVersion(boolean bl) {
        long l = Application.getJavaVersion();
        if (l < 16000000L && !CrossSystem.isMac()) {
            Log.L.warning("Java 1.6 should be available on your System, please upgrade!");
            return true;
        }
        if (l < 16000000L && !bl) {
            Log.L.warning("Java 1.5 no longer supported!");
            return true;
        }
        if (l >= 16018000L && l < 16019000L) {
            Log.L.warning("Java 1.6 Update 18 has a serious bug in garbage collector!");
            return true;
        }
        if (l >= 16010000L && l < 16011000L) {
            Log.L.warning("Java 1.6 Update 10 has a swing bug!");
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        System.out.println(Application.getJavaVersion());
    }

    public static void redirectOutputStreams() {
        if (REDIRECTED) {
            return;
        }
        if (Charset.defaultCharset() == Charset.forName("cp1252")) {
            REDIRECTED = true;
            try {
                System.setOut(new PrintStream((OutputStream)new FileOutputStream(FileDescriptor.out), true, "CP850"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            try {
                System.setErr(new PrintStream((OutputStream)new FileOutputStream(FileDescriptor.err), true, "CP850"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
    }

    public static synchronized void setApplication(String string) {
        ROOT = string;
        APP_FOLDER = string;
    }

    static {
        Application.redirectOutputStreams();
        APP_FOLDER = ".appwork";
        javaVersion = 0L;
        JAVA15 = 15000000L;
        JAVA16 = 16000000L;
        JAVA17 = 17000000L;
        REDIRECTED = false;
    }
}

