/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.io.ByteArrayOutputStream;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedList;

public class ReusableByteArrayOutputStreamPool {
    private static final LinkedList<SoftReference<ReusableByteArrayOutputStream>> pool = new LinkedList();

    public static ReusableByteArrayOutputStream getReusableByteArrayOutputStream() {
        return ReusableByteArrayOutputStreamPool.getReusableByteArrayOutputStream(32);
    }

    public static ReusableByteArrayOutputStream getReusableByteArrayOutputStream(int n) {
        return ReusableByteArrayOutputStreamPool.getReusableByteArrayOutputStream(n, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReusableByteArrayOutputStream getReusableByteArrayOutputStream(int n, boolean bl) {
        int n2 = Math.max(32, n);
        LinkedList<SoftReference<ReusableByteArrayOutputStream>> linkedList = pool;
        synchronized (linkedList) {
            ReusableByteArrayOutputStream reusableByteArrayOutputStream = null;
            ReusableByteArrayOutputStream reusableByteArrayOutputStream2 = null;
            if (!pool.isEmpty()) {
                SoftReference softReference;
                Iterator iterator = pool.iterator();
                while (iterator.hasNext()) {
                    softReference = (SoftReference)iterator.next();
                    reusableByteArrayOutputStream = (ReusableByteArrayOutputStream)softReference.get();
                    if (reusableByteArrayOutputStream == null) {
                        iterator.remove();
                        continue;
                    }
                    if (reusableByteArrayOutputStream.bufferSize() >= n) {
                        iterator.remove();
                        return reusableByteArrayOutputStream;
                    }
                    if (reusableByteArrayOutputStream2 == null) {
                        reusableByteArrayOutputStream2 = reusableByteArrayOutputStream;
                        continue;
                    }
                    if (reusableByteArrayOutputStream.bufferSize() <= reusableByteArrayOutputStream2.bufferSize()) continue;
                    reusableByteArrayOutputStream2 = reusableByteArrayOutputStream;
                }
                if (reusableByteArrayOutputStream2 != null && bl) {
                    iterator = pool.iterator();
                    while (iterator.hasNext()) {
                        softReference = (SoftReference)iterator.next();
                        reusableByteArrayOutputStream = (ReusableByteArrayOutputStream)softReference.get();
                        if (reusableByteArrayOutputStream == null) {
                            iterator.remove();
                            continue;
                        }
                        if (reusableByteArrayOutputStream != reusableByteArrayOutputStream2) continue;
                        iterator.remove();
                        return reusableByteArrayOutputStream;
                    }
                }
            }
            return new ReusableByteArrayOutputStream(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reuseReusableByteArrayOutputStream(ReusableByteArrayOutputStream reusableByteArrayOutputStream) {
        if (reusableByteArrayOutputStream == null) {
            return;
        }
        LinkedList<SoftReference<ReusableByteArrayOutputStream>> linkedList = pool;
        synchronized (linkedList) {
            if (pool.contains(reusableByteArrayOutputStream)) {
                return;
            }
            pool.add(new SoftReference<ReusableByteArrayOutputStream>(reusableByteArrayOutputStream));
            reusableByteArrayOutputStream.reset();
        }
    }

    public static class ReusableByteArrayOutputStream
    extends ByteArrayOutputStream {
        protected ReusableByteArrayOutputStream(int n) {
            super(n);
        }

        public int bufferSize() {
            return this.buf.length;
        }

        public synchronized int free() {
            return this.buf.length - this.count;
        }

        public byte[] getInternalBuffer() {
            return this.buf;
        }

        public synchronized void setUsed(int n) {
            this.count = n;
        }
    }
}

