/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.logging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Date;
import org.appwork.utils.Application;
import org.appwork.utils.logging.Log;

public class ErrRedirect
extends Thread {
    private final File file;
    private FileOutputStream outStr = null;
    private PrintStream printStream = null;

    public ErrRedirect() {
        this.setDaemon(true);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(new Date().getTime());
        this.file = Application.getResource("logs/error_cerr_" + calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5) + "-" + System.currentTimeMillis() + ".log");
        try {
            this.file.getParentFile().mkdirs();
            this.file.deleteOnExit();
            if (!this.file.isFile()) {
                this.file.createNewFile();
            }
            this.outStr = new FileOutputStream(this.file, true);
            this.printStream = new PrintStream(this.outStr);
            System.setErr(this.printStream);
            this.start();
        }
        catch (IOException iOException) {
            Log.exception(iOException);
        }
    }

    public void close() throws IOException {
        try {
            this.printStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.outStr.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.printStream = null;
        this.outStr = null;
    }

    public void flush() throws IOException {
        if (this.printStream == null) {
            return;
        }
        this.printStream.flush();
        this.outStr.flush();
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public void run() {
        while (this.printStream != null) {
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                if (this.printStream == null) break;
                this.printStream.flush();
            }
            catch (Throwable throwable) {
                Log.exception(throwable);
                break;
            }
        }
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

