/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.logging;

import java.util.ArrayList;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.appwork.utils.logging.LogEvent;
import org.appwork.utils.logging.LogEventSender;

public class LogEventHandler
extends Handler {
    private static final LogEventHandler INSTANCE = new LogEventHandler();
    private LogEventSender eventSender;
    private boolean doLogging = false;
    private ArrayList<LogRecord> cache;
    private Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogEventHandler() {
        Object object = this.lock = new Object();
        synchronized (object) {
            this.cache = new ArrayList();
        }
        this.eventSender = new LogEventSender();
        this.doLogging = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableLogging(boolean bl) {
        if (!bl && this.doLogging) {
            Object object = this.lock;
            synchronized (object) {
                this.cache.clear();
            }
        }
        this.doLogging = bl;
    }

    public boolean isEnabled() {
        return this.doLogging;
    }

    public LogEventSender getEventSender() {
        return this.eventSender;
    }

    public static LogEventHandler getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<LogRecord> getCache() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<LogRecord>(this.cache);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(LogRecord logRecord) {
        if (this.doLogging) {
            this.cache.add(logRecord);
            this.getEventSender().fireEvent(new LogEvent((Object)this, 0, logRecord));
        }
    }
}

