/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.logging;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.appwork.utils.logging.LoggingOutputStream;

public final class StdOutErr2Logging
extends Level {
    private static final PrintStream stdout = System.out;
    private static final PrintStream stderr = System.err;
    private static final long serialVersionUID = -8193079562712405474L;
    public static final Level STDOUT = new StdOutErr2Logging("STDOUT", Level.INFO.intValue() + 53);
    public static final Level STDERR = new StdOutErr2Logging("STDERR", Level.INFO.intValue() + 54);

    public static PrintStream getStdErr() {
        return stderr;
    }

    public static PrintStream getStdOut() {
        return stdout;
    }

    public static void redirectStdErr2Logger(Logger logger) {
        System.setErr(new PrintStream(new LoggingOutputStream(logger, STDERR), true));
    }

    public static void redirectStdOut2Logger(Logger logger) {
        System.setOut(new PrintStream(new LoggingOutputStream(logger, STDOUT), true));
    }

    private StdOutErr2Logging(String string, int n) {
        super(string, n);
    }

    protected Object readResolve() throws ObjectStreamException {
        if (this.intValue() == STDOUT.intValue()) {
            return STDOUT;
        }
        if (this.intValue() == STDERR.intValue()) {
            return STDERR;
        }
        throw new InvalidObjectException("Unknown instance :" + this);
    }
}

