/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Base64InputStream
extends FilterInputStream {
    private static final char[] BASE64;
    private static final byte[] BASE64MAP;
    private final byte[] base64Encoded = new byte[4];
    private final byte[] base64Decoded = new byte[3];
    private int decodedAvailable = 0;
    private static final int LF = 10;
    private static final int CR = 13;
    private static final byte PADDING = 61;

    public Base64InputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public int available() throws IOException {
        return this.in.available() * 3 / 4 + this.decodedAvailable;
    }

    private void decodeBase64() throws IOException {
        int n = -1;
        int n2 = 0;
        this.decodedAvailable = 0;
        while (n2 < 4 && (n = this.in.read()) >= 0) {
            if (n == 10 || n == 13) continue;
            this.base64Encoded[n2++] = (byte)n;
        }
        if (n == -1 && n2 != 0) {
            throw new IOException("Base64 encoding error");
        }
        if (n == -1 && n2 == 0) {
            return;
        }
        byte by = BASE64MAP[this.base64Encoded[0] & 0xFF];
        byte by2 = BASE64MAP[this.base64Encoded[1] & 0xFF];
        this.base64Decoded[this.decodedAvailable++] = (byte)(by << 2 & 0xFC | by2 >>> 4 & 3);
        if (this.base64Encoded[2] != 61) {
            by = by2;
            by2 = BASE64MAP[this.base64Encoded[2] & 0xFF];
            this.base64Decoded[this.decodedAvailable++] = (byte)(by << 4 & 0xF0 | by2 >>> 2 & 0xF);
            if (this.base64Encoded[3] != 61) {
                by = by2;
                by2 = BASE64MAP[this.base64Encoded[3] & 0xFF];
                this.base64Decoded[this.decodedAvailable++] = (byte)(by << 6 & 0xC0 | by2 & 0x3F);
            }
        }
    }

    @Override
    public synchronized void mark(int n) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        int n = this.returnDecodedBase64();
        if (n >= 0) {
            return n;
        }
        this.decodeBase64();
        return this.returnDecodedBase64();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.read();
        if (n3 == -1) {
            return -1;
        }
        int n4 = 0;
        byArray[n + n4++] = (byte)n3;
        while (n4 < n2 && (n3 = this.read()) != -1) {
            byArray[n + n4] = (byte)n3;
            ++n4;
        }
        return n4;
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    private int returnDecodedBase64() {
        int n = -1;
        if (this.decodedAvailable > 0) {
            --this.decodedAvailable;
            n = this.base64Decoded[0] & 0xFF;
            this.base64Decoded[0] = this.base64Decoded[1];
            this.base64Decoded[1] = this.base64Decoded[2];
        }
        return n;
    }

    static {
        int n;
        BASE64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        BASE64MAP = new byte[256];
        for (n = 0; n < 255; ++n) {
            Base64InputStream.BASE64MAP[n] = -1;
        }
        for (n = 0; n < BASE64.length; ++n) {
            Base64InputStream.BASE64MAP[Base64InputStream.BASE64[n]] = (byte)n;
        }
    }
}

