/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net;

import java.io.IOException;
import java.io.InputStream;

public class ChunkedInputStream
extends InputStream {
    private final InputStream is;
    private int nextChunkSize = 0;
    private int nextChunkLeft = 0;
    private long completeSize = 0L;

    public ChunkedInputStream(InputStream inputStream) {
        this.is = inputStream;
    }

    @Override
    public int available() throws IOException {
        if (this.nextChunkLeft > 0) {
            return this.nextChunkLeft;
        }
        return this.is.available();
    }

    private int availableChunkData() throws IOException {
        if (this.nextChunkLeft == -1) {
            return -1;
        }
        if (this.nextChunkLeft > 0) {
            return this.nextChunkLeft;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        byte[] byArray = new byte[]{0};
        int n = 0;
        if (this.nextChunkSize > 0 && (n = this.is.read()) == 13) {
            n = this.is.read();
        }
        n = this.is.read();
        while (n > -1 && n != 10 && n != 13) {
            if (n == 59) {
                bl = true;
            }
            if (!bl) {
                byArray[0] = (byte)(n & 0xFF);
                stringBuilder.append(new String(byArray, 0, 1));
            }
            n = this.is.read();
        }
        if (n == -1 && stringBuilder.length() == 0) {
            return -1;
        }
        if (n == 13) {
            n = this.is.read();
        }
        this.nextChunkSize = 0;
        if (stringBuilder.length() > 0) {
            this.nextChunkSize = Integer.parseInt(stringBuilder.toString().trim(), 16);
        }
        if (this.nextChunkSize == 0) {
            this.nextChunkLeft = -1;
            this.readTrailers();
        } else {
            this.completeSize += (long)this.nextChunkSize;
            this.nextChunkLeft = this.nextChunkSize;
        }
        return this.nextChunkLeft;
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    private void exhaustInputStream() throws IOException {
        while (this.is.read() > 0) {
        }
    }

    public long getCompleteSize() {
        return this.completeSize;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        int n = this.availableChunkData();
        if (n > 0) {
            int n2 = this.is.read();
            if (n2 != -1) {
                --this.nextChunkLeft;
                return n2;
            }
            throw new IOException("premature EOF");
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.availableChunkData();
        if (n3 > 0) {
            int n4 = this.is.read(byArray, n, Math.min(n3, n2));
            if (n4 != -1) {
                this.nextChunkLeft -= n4;
                return n4;
            }
            throw new IOException("premature EOF");
        }
        return -1;
    }

    private void readTrailers() throws IOException {
        this.exhaustInputStream();
    }
}

