/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Input2OutputStreamForwarder {
    private final InputStream in;
    private final OutputStream out;
    final byte[] buffer;
    long inC = 0L;
    long outC = 0L;
    int readP = 0;
    int writeF = 0;
    int readF = 0;
    int writeP = 0;
    int readS = 0;
    int writeS = 0;
    final Object LOCK = new Object();
    private Thread thread = null;
    private IOException outE = null;
    private volatile boolean eof = false;
    private volatile boolean readDone = false;

    public Input2OutputStreamForwarder(InputStream inputStream, OutputStream outputStream) {
        this.in = inputStream;
        this.out = outputStream;
        this.buffer = new byte[0x100000];
        this.createstartThread();
    }

    public Input2OutputStreamForwarder(InputStream inputStream, OutputStream outputStream, byte[] byArray) {
        this.in = inputStream;
        this.out = outputStream;
        if (byArray == null || byArray.length < 1024) {
            throw new IllegalArgumentException("invalid buffer");
        }
        this.buffer = byArray;
        this.createstartThread();
    }

    public Input2OutputStreamForwarder(InputStream inputStream, OutputStream outputStream, int n) {
        this.in = inputStream;
        this.out = outputStream;
        if (n < 1024) {
            throw new IllegalArgumentException("invalid buffer size");
        }
        this.buffer = new byte[n];
        this.createstartThread();
    }

    private void createstartThread() {
        this.thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    while (!Input2OutputStreamForwarder.this.thread.isInterrupted()) {
                        Object object = Input2OutputStreamForwarder.this.LOCK;
                        synchronized (object) {
                            if (Input2OutputStreamForwarder.this.writeF > Input2OutputStreamForwarder.this.readF) {
                                Input2OutputStreamForwarder.this.readP = 0;
                                Input2OutputStreamForwarder.this.readF = Input2OutputStreamForwarder.this.writeF;
                            }
                            if (Input2OutputStreamForwarder.this.readP < Input2OutputStreamForwarder.this.writeP) {
                                Input2OutputStreamForwarder.this.readS = Input2OutputStreamForwarder.this.writeP - Input2OutputStreamForwarder.this.readP;
                            } else if (Input2OutputStreamForwarder.this.writeP < Input2OutputStreamForwarder.this.readP) {
                                Input2OutputStreamForwarder.this.readS = Input2OutputStreamForwarder.this.buffer.length - Input2OutputStreamForwarder.this.readP;
                            } else {
                                if (Input2OutputStreamForwarder.this.eof) return;
                                if (Input2OutputStreamForwarder.this.readDone) {
                                    return;
                                }
                                try {
                                    Input2OutputStreamForwarder.this.LOCK.wait(100L);
                                    continue;
                                }
                                catch (InterruptedException interruptedException) {
                                    return;
                                }
                            }
                        }
                        Input2OutputStreamForwarder.this.out.write(Input2OutputStreamForwarder.this.buffer, Input2OutputStreamForwarder.this.readP, Input2OutputStreamForwarder.this.readS);
                        Input2OutputStreamForwarder.this.outC += (long)Input2OutputStreamForwarder.this.readS;
                        object = Input2OutputStreamForwarder.this.LOCK;
                        synchronized (object) {
                            Input2OutputStreamForwarder.this.readP += Input2OutputStreamForwarder.this.readS;
                            Input2OutputStreamForwarder.this.LOCK.notifyAll();
                        }
                    }
                    return;
                }
                catch (IOException iOException) {
                    Input2OutputStreamForwarder.this.outE = iOException;
                    return;
                }
                finally {
                    Object object = Input2OutputStreamForwarder.this.LOCK;
                    synchronized (object) {
                        Input2OutputStreamForwarder.this.LOCK.notifyAll();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forward() throws IOException, InterruptedException {
        try {
            this.thread.start();
            int n = 0;
            while (!this.thread.isInterrupted() && this.thread.isAlive()) {
                Object object = this.LOCK;
                synchronized (object) {
                    if (this.readP == this.buffer.length && this.readF == this.writeF) {
                        this.writeP = 0;
                        ++this.writeF;
                    }
                    if (this.writeP >= this.buffer.length) {
                        this.LOCK.notifyAll();
                        try {
                            if (!this.thread.isAlive() || this.thread.isInterrupted()) {
                                break;
                            }
                            this.LOCK.wait(100L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                    }
                    this.writeS = this.buffer.length - this.writeP;
                }
                n = this.in.read(this.buffer, this.writeP, this.writeS);
                if (n == -1) {
                    this.eof = true;
                    break;
                }
                this.inC += (long)n;
                object = this.LOCK;
                synchronized (object) {
                    this.writeP += n;
                }
            }
            if (this.outE != null) {
                throw this.outE;
            }
        }
        finally {
            this.readDone = true;
            Object object = this.LOCK;
            synchronized (object) {
                this.LOCK.notifyAll();
            }
            while (this.thread.isAlive()) {
                object = this.LOCK;
                synchronized (object) {
                    this.LOCK.wait(100L);
                }
            }
        }
    }

    public long getInC() {
        return this.inC;
    }

    public long getOutC() {
        return this.outC;
    }
}

