/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.throttledconnection;

import java.io.InputStream;
import org.appwork.utils.net.throttledconnection.ThrottledInputStream;
import org.appwork.utils.speedmeter.SpeedMeterInterface;

public class MeteredThrottledInputStream
extends ThrottledInputStream
implements SpeedMeterInterface {
    private SpeedMeterInterface speedmeter = null;
    private long time = 0L;
    private long speed = 0L;
    private long lastTime;
    private long lastTrans;
    private long transferedCounter3;

    public MeteredThrottledInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public MeteredThrottledInputStream(InputStream inputStream, SpeedMeterInterface speedMeterInterface) {
        super(inputStream);
        this.speedmeter = speedMeterInterface;
    }

    @Override
    public synchronized long getSpeedMeter() {
        if (this.time == 0L) {
            this.transferedCounter3 = this.transferedCounter;
            this.time = System.currentTimeMillis();
            return 0L;
        }
        if (System.currentTimeMillis() - this.time < 1000L) {
            if (this.speedmeter != null) {
                return this.speedmeter.getSpeedMeter();
            }
            return this.speed;
        }
        long l = this.transferedCounter;
        this.lastTrans = l - this.transferedCounter3;
        long l2 = System.currentTimeMillis();
        this.lastTime = l2 - this.time;
        this.transferedCounter3 = l;
        this.time = l2;
        if (this.speedmeter != null) {
            this.speedmeter.putSpeedMeter(this.lastTrans, this.lastTime);
            this.speed = this.speedmeter.getSpeedMeter();
            return this.speed;
        }
        this.speed = this.lastTrans / this.lastTime * 1000L;
        return this.speed;
    }

    @Override
    public void putSpeedMeter(long l, long l2) {
    }

    @Override
    public synchronized void resetSpeedMeter() {
        if (this.speedmeter != null) {
            this.speedmeter.resetSpeedMeter();
        }
        this.time = System.currentTimeMillis();
        this.speed = 0L;
        this.transferedCounter3 = this.transferedCounter;
    }
}

