/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.throttledconnection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.appwork.utils.logging.Log;
import org.appwork.utils.net.throttledconnection.ThrottledConnection;
import org.appwork.utils.net.throttledconnection.ThrottledConnectionHandler;
import org.appwork.utils.speedmeter.AverageSpeedMeter;
import org.appwork.utils.speedmeter.SpeedMeterInterface;

public class SimpleThrottledConnectionHandler
implements ThrottledConnectionHandler {
    protected Thread watchDog = null;
    protected ArrayList<ThrottledConnection> connections = new ArrayList();
    protected volatile int limit = 0;
    protected int updateSpeed = 2000;
    protected volatile int bandwidth = 0;
    protected SpeedMeterInterface speedMeter = new AverageSpeedMeter(10);
    protected volatile long traffic = 0L;
    private final Object watchDogLOCK = new Object();
    private final String name;

    public SimpleThrottledConnectionHandler(String string) {
        this.name = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addThrottledConnection(ThrottledConnection throttledConnection) {
        if (this.connections.contains(throttledConnection)) {
            return;
        }
        SimpleThrottledConnectionHandler simpleThrottledConnectionHandler = this;
        synchronized (simpleThrottledConnectionHandler) {
            ArrayList<ThrottledConnection> arrayList = new ArrayList<ThrottledConnection>(this.connections);
            arrayList.add(throttledConnection);
            this.connections = arrayList;
        }
        throttledConnection.setHandler(this);
        throttledConnection.setLimit(10);
        this.startWatchDog();
    }

    @Override
    public List<ThrottledConnection> getConnections() {
        return this.connections;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public int getSpeed() {
        return this.bandwidth;
    }

    public SpeedMeterInterface getSpeedMeter() {
        return this.speedMeter;
    }

    @Override
    public long getTraffic() {
        return this.traffic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeThrottledConnection(ThrottledConnection throttledConnection) {
        if (!this.connections.contains(throttledConnection)) {
            return;
        }
        SimpleThrottledConnectionHandler simpleThrottledConnectionHandler = this;
        synchronized (simpleThrottledConnectionHandler) {
            ArrayList<ThrottledConnection> arrayList = new ArrayList<ThrottledConnection>(this.connections);
            arrayList.remove(throttledConnection);
            this.connections = arrayList;
        }
        throttledConnection.setHandler(null);
    }

    @Override
    public void setLimit(int n) {
        this.limit = Math.max(0, n);
    }

    @Override
    public int size() {
        return this.connections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWatchDog() {
        Object object = this.watchDogLOCK;
        synchronized (object) {
            if (this.watchDog != null && this.watchDog.isAlive()) {
                return;
            }
            this.watchDog = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object;
                    this.setName(SimpleThrottledConnectionHandler.this.name);
                    SimpleThrottledConnectionHandler.this.speedMeter.resetSpeedMeter();
                    HashMap<ThrottledConnection, SpeedAssignHelp> hashMap = new HashMap<ThrottledConnection, SpeedAssignHelp>();
                    while (((ArrayList)(object = SimpleThrottledConnectionHandler.this.connections)).size() != 0) {
                        SpeedAssignHelp speedAssignHelp;
                        Object object2;
                        long l = Math.max(1000, SimpleThrottledConnectionHandler.this.updateSpeed);
                        try {
                            Thread.sleep(l);
                        }
                        catch (InterruptedException interruptedException) {
                            Log.exception(interruptedException);
                        }
                        long l2 = 0L;
                        int n = 0;
                        long l3 = 0L;
                        long l4 = 0L;
                        Iterator iterator = ((ArrayList)object).iterator();
                        while (iterator.hasNext()) {
                            ThrottledConnection throttledConnection = (ThrottledConnection)iterator.next();
                            object2 = (SpeedAssignHelp)hashMap.get(throttledConnection);
                            if (object2 == null) {
                                object2 = new SpeedAssignHelp();
                                hashMap.put(throttledConnection, (SpeedAssignHelp)object2);
                                ((SpeedAssignHelp)object2).lastTraffic = throttledConnection.transfered();
                                ((SpeedAssignHelp)object2).lastTimeStamp = System.currentTimeMillis();
                                continue;
                            }
                            long l5 = System.currentTimeMillis() - ((SpeedAssignHelp)object2).lastTimeStamp;
                            l2 = throttledConnection.transfered();
                            ((SpeedAssignHelp)object2).lastTimeStamp = System.currentTimeMillis();
                            l3 = l2 - ((SpeedAssignHelp)object2).lastTraffic;
                            SimpleThrottledConnectionHandler.this.traffic += l3;
                            ((SpeedAssignHelp)object2).lastTraffic = l2;
                            l4 += ((SpeedAssignHelp)object2).lastTraffic;
                            ((SpeedAssignHelp)object2).lastSpeed = (int)(l3 * 1000L / l5);
                            n = (int)((long)n + ((SpeedAssignHelp)object2).lastSpeed);
                        }
                        SimpleThrottledConnectionHandler.this.bandwidth = n;
                        SimpleThrottledConnectionHandler.this.speedMeter.putSpeedMeter(l4, l);
                        int n2 = ((ArrayList)object).size();
                        int n3 = SimpleThrottledConnectionHandler.this.limit;
                        object2 = ((ArrayList)object).iterator();
                        while (object2.hasNext()) {
                            ThrottledConnection throttledConnection = (ThrottledConnection)object2.next();
                            speedAssignHelp = (SpeedAssignHelp)hashMap.get(throttledConnection);
                            speedAssignHelp.lastLimit = speedAssignHelp.newLimit;
                            speedAssignHelp.newLimit = n3 / n2;
                            --n2;
                            n3 -= speedAssignHelp.newLimit;
                        }
                        object2 = ((ArrayList)object).iterator();
                        while (object2.hasNext()) {
                            ThrottledConnection throttledConnection = (ThrottledConnection)object2.next();
                            speedAssignHelp = (SpeedAssignHelp)hashMap.get(throttledConnection);
                            throttledConnection.setLimit(speedAssignHelp.newLimit);
                        }
                    }
                    object = SimpleThrottledConnectionHandler.this.watchDogLOCK;
                    synchronized (object) {
                        SimpleThrottledConnectionHandler.this.watchDog = null;
                        SimpleThrottledConnectionHandler.this.bandwidth = 0;
                        SimpleThrottledConnectionHandler.this.speedMeter.resetSpeedMeter();
                    }
                }
            };
            this.watchDog.setDaemon(false);
            this.watchDog.start();
        }
    }

    private static class SpeedAssignHelp {
        protected long lastLimit = 0L;
        protected int newLimit = 0;
        protected long lastDifference = 0L;
        protected long lastSpeed = 0L;
        protected long lastTraffic = 0L;
        protected long lastTimeStamp = 0L;

        private SpeedAssignHelp() {
        }
    }
}

