/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.filter;

import java.util.ArrayList;
import java.util.regex.Pattern;
import org.appwork.utils.logging.Log;
import org.jdownloader.controlling.filter.FiletypeFilter;
import org.jdownloader.controlling.filter.LinkgrabberFilterRuleWrapper;

public class CompiledFiletypeFilter {
    private Pattern[] list = new Pattern[0];
    private FiletypeFilter.TypeMatchType matchType;

    public FiletypeFilter.TypeMatchType getMatchType() {
        return this.matchType;
    }

    private static Pattern compileAllPattern(ExtensionsFilterInterface[] extensionsFilterInterfaceArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        boolean bl = false;
        for (ExtensionsFilterInterface extensionsFilterInterface : extensionsFilterInterfaceArray) {
            if (bl) {
                stringBuilder.append("|");
            }
            stringBuilder.append(extensionsFilterInterface.getPattern());
            bl = true;
        }
        stringBuilder.append(")");
        return Pattern.compile(stringBuilder.toString(), 34);
    }

    public CompiledFiletypeFilter(FiletypeFilter filetypeFilter) {
        ArrayList<Pattern> arrayList = new ArrayList<Pattern>();
        if (filetypeFilter.isArchivesEnabled()) {
            for (Enum object : ArchiveExtensions.values()) {
                arrayList.add(((ArchiveExtensions)object).getPattern());
            }
        }
        if (filetypeFilter.isAudioFilesEnabled()) {
            for (Enum enum_ : AudioExtensions.values()) {
                arrayList.add(((AudioExtensions)enum_).getPattern());
            }
        }
        if (filetypeFilter.isImagesEnabled()) {
            for (Enum enum_ : ImageExtensions.values()) {
                arrayList.add(((ImageExtensions)enum_).getPattern());
            }
        }
        if (filetypeFilter.isVideoFilesEnabled()) {
            for (Enum enum_ : VideoExtensions.values()) {
                arrayList.add(((VideoExtensions)enum_).getPattern());
            }
        }
        try {
            if (filetypeFilter.getCustoms() != null) {
                if (filetypeFilter.isUseRegex()) {
                    arrayList.add(Pattern.compile(filetypeFilter.getCustoms(), 34));
                } else {
                    for (String string : filetypeFilter.getCustoms().split("\\,")) {
                        arrayList.add(LinkgrabberFilterRuleWrapper.createPattern(string, false));
                    }
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.exception(illegalArgumentException);
        }
        this.matchType = filetypeFilter.getMatchType();
        this.list = arrayList.toArray(new Pattern[arrayList.size()]);
    }

    public boolean matches(String string) {
        switch (this.matchType) {
            case IS: {
                for (Pattern pattern : this.list) {
                    try {
                        if (!pattern.matcher(string).matches()) continue;
                        return true;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                return false;
            }
            case IS_NOT: {
                for (Pattern pattern : this.list) {
                    try {
                        if (!pattern.matcher(string).matches()) continue;
                        return false;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                return true;
            }
        }
        return false;
    }

    public Pattern[] getList() {
        return this.list;
    }

    public static enum ImageExtensions implements ExtensionsFilterInterface
    {
        JPG,
        JPEG,
        GIF,
        PNG,
        BMP,
        TIFF,
        RAW,
        SVG,
        ICO;

        private Pattern pattern;

        @Override
        public Pattern getPattern() {
            return this.pattern;
        }

        private ImageExtensions() {
            this.pattern = Pattern.compile(this.name(), 34);
        }

        private ImageExtensions(String string2) {
            this.pattern = Pattern.compile(string2, 34);
        }

        @Override
        public String getDesc() {
            return "_GUI._.FilterRuleDialog_createTypeFilter_mime_images()";
        }

        @Override
        public Pattern compiledAllPattern() {
            return CompiledFiletypeFilter.compileAllPattern(ImageExtensions.values());
        }

        @Override
        public String getIconID() {
            return "image";
        }
    }

    public static enum ArchiveExtensions implements ExtensionsFilterInterface
    {
        RAR,
        ZIP,
        SevenZIP("7ZIP"),
        R_NUM("r\\d+"),
        NUM("\\d+"),
        MultiZip("z\\d+"),
        ACE,
        TAR,
        GZ,
        AR,
        BZ2,
        SevenZ("7Z"),
        S7Z,
        DMG,
        SFX,
        TGZ;

        private Pattern pattern;

        @Override
        public Pattern getPattern() {
            return this.pattern;
        }

        private ArchiveExtensions() {
            this.pattern = Pattern.compile(this.name(), 34);
        }

        private ArchiveExtensions(String string2) {
            this.pattern = Pattern.compile(string2, 34);
        }

        @Override
        public String getDesc() {
            return "_GUI._.FilterRuleDialog_createTypeFilter_mime_archives()";
        }

        @Override
        public Pattern compiledAllPattern() {
            return CompiledFiletypeFilter.compileAllPattern(ArchiveExtensions.values());
        }

        @Override
        public String getIconID() {
            return "archive";
        }
    }

    public static enum VideoExtensions implements ExtensionsFilterInterface
    {
        ASF,
        AVI,
        DIVX,
        XVID,
        FLV,
        MP4,
        H264,
        M4U,
        M4V,
        MOV,
        MKV,
        MPEG,
        MPEG4,
        MPG,
        OGM,
        OGV,
        VOB,
        WMV,
        WEBM;

        private Pattern pattern;

        private VideoExtensions() {
            this.pattern = Pattern.compile(this.name(), 34);
        }

        @Override
        public Pattern getPattern() {
            return this.pattern;
        }

        private VideoExtensions(String string2) {
            this.pattern = Pattern.compile(string2, 34);
        }

        @Override
        public String getDesc() {
            return "_GUI._.FilterRuleDialog_createTypeFilter_mime_video()";
        }

        @Override
        public Pattern compiledAllPattern() {
            return CompiledFiletypeFilter.compileAllPattern(VideoExtensions.values());
        }

        @Override
        public String getIconID() {
            return "video";
        }
    }

    public static enum AudioExtensions implements ExtensionsFilterInterface
    {
        MP3,
        WMA,
        ACC,
        WAV,
        FLAC,
        MID,
        MOD,
        OGG,
        S3M,
        FourMP("4MP"),
        AA,
        AIF,
        AIFF,
        AU,
        M3U,
        M4a,
        M4b,
        M4P,
        MKA,
        MP1,
        MP2,
        MPA,
        OMG,
        OMF,
        SND;

        private Pattern pattern;

        @Override
        public Pattern getPattern() {
            return this.pattern;
        }

        private AudioExtensions() {
            this.pattern = Pattern.compile(this.name(), 34);
        }

        private AudioExtensions(String string2) {
            this.pattern = Pattern.compile(string2, 34);
        }

        @Override
        public String getDesc() {
            return "_GUI._.FilterRuleDialog_createTypeFilter_mime_audio()";
        }

        @Override
        public String getIconID() {
            return "audio";
        }

        @Override
        public Pattern compiledAllPattern() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(");
            boolean bl = false;
            for (AudioExtensions audioExtensions : AudioExtensions.values()) {
                if (bl) {
                    stringBuilder.append("|");
                }
                stringBuilder.append(audioExtensions.getPattern());
                bl = true;
            }
            stringBuilder.append(")");
            return Pattern.compile(stringBuilder.toString(), 34);
        }
    }

    public static interface ExtensionsFilterInterface {
        public Pattern compiledAllPattern();

        public String getDesc();

        public String getIconID();

        public Pattern getPattern();
    }
}

