/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.settings;

import java.io.File;
import java.util.ArrayList;
import jd.utils.JDUtilities;
import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DefaultFactory;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.Description;
import org.appwork.storage.config.annotations.RequiresRestart;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.appwork.storage.config.defaults.AbstractDefaultFactory;
import org.appwork.utils.Application;
import org.appwork.utils.StringUtils;
import org.jdownloader.settings.AutoDownloadStartOption;
import org.jdownloader.settings.CleanAfterDownloadAction;
import org.jdownloader.settings.IfFileExistsAction;

public interface GeneralSettings
extends ConfigInterface {
    @AboutConfig
    @DefaultEnumValue(value="NEVER")
    public CleanAfterDownloadAction getCleanupAfterDownloadAction();

    @DefaultFactory(value=DefaultDownloadFolder.class)
    public String getDefaultDownloadFolder();

    public ArrayList<String[]> getDownloadFolderHistory();

    @AboutConfig
    @Description(value="Download Speed limit in bytes.")
    @SpinnerValidator(min=0L, max=0x7FFFFFFFL)
    public int getDownloadSpeedLimit();

    @AboutConfig
    @Description(value="flush download buffers when filled up to x percent (1-100)")
    @DefaultIntValue(value=80)
    @SpinnerValidator(min=1L, max=100L)
    public int getFlushBufferLevel();

    @AboutConfig
    @Description(value="flush download buffers after x ms")
    @DefaultIntValue(value=120000)
    public int getFlushBufferTimeout();

    @AboutConfig
    @Description(value="Force Jdownloader to always keep a certain amount of MB Diskspace free")
    @DefaultIntValue(value=512)
    public int getForcedFreeSpaceOnDisk();

    @AboutConfig
    @Description(value="Timeout for connecting to a httpserver")
    @SpinnerValidator(min=0L, max=300000L)
    @DefaultIntValue(value=10000)
    @RequiresRestart
    public int getHttpConnectTimeout();

    @AboutConfig
    @Description(value="Timeout for reading to a httpserver")
    @SpinnerValidator(min=0L, max=300000L)
    @DefaultIntValue(value=30000)
    @RequiresRestart
    public int getHttpReadTimeout();

    @AboutConfig
    @Description(value="Timeout for network problems")
    @SpinnerValidator(min=0L, max=1000000L)
    @DefaultIntValue(value=15000)
    @RequiresRestart
    public int getNetworkIssuesTimeout();

    @AboutConfig
    @DefaultEnumValue(value="ASK_FOR_EACH_FILE")
    public IfFileExistsAction getIfFileExistsAction();

    @AboutConfig
    @Description(value="max buffer size for write operations in kb")
    @SpinnerValidator(min=100L, max=10240L)
    @DefaultIntValue(value=500)
    public int getMaxBufferSize();

    @AboutConfig
    @Description(value="http://jdownloader.org/knowledge/wiki/glossary/chunkload")
    @SpinnerValidator(min=1L, max=20L)
    @DefaultIntValue(value=1)
    public int getMaxChunksPerFile();

    @AboutConfig
    @Description(value="How often a Plugin restarts a download if download failed")
    @DefaultIntValue(value=3)
    public int getMaxPluginRetries();

    @AboutConfig
    @Description(value="How many downloads should Jdownloader download at once? Note that most hosters allow only one download at a time in freemode")
    @SpinnerValidator(min=1L, max=20L)
    @DefaultIntValue(value=3)
    public int getMaxSimultaneDownloads();

    @AboutConfig
    @DefaultIntValue(value=1)
    @SpinnerValidator(min=1L, max=100L)
    public int getMaxSimultaneDownloadsPerHost();

    @AboutConfig
    @Description(value="Pause Speed. in Pause Mode we limit speed to this value to keep connections open, but use hardly bandwidth")
    @DefaultIntValue(value=10240)
    @SpinnerValidator(min=0L, max=0x7FFFFFFFL)
    public int getPauseSpeed();

    @AboutConfig
    @Description(value="Penaltytime before a retry if JDownloader lost connection")
    @DefaultIntValue(value=300000)
    public int getWaittimeOnConnectionLoss();

    @AboutConfig
    public boolean isAddNewLinksOnTop();

    @AboutConfig
    public boolean isAutoaddLinksAfterLinkcheck();

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isAutoDownloadStartAfterAddingEnabled();

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isAutoOpenContainerAfterDownload();

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @Description(value="AutoReconnect enabled?")
    public boolean isAutoReconnectEnabled();

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isCleanUpFilenames();

    @AboutConfig
    @Description(value="Do not start further downloads if others are waiting for a reconnect/new ip")
    @DefaultBooleanValue(value=true)
    public boolean isDownloadControllerPrefersReconnectEnabled();

    @AboutConfig
    public boolean isDownloadSpeedLimitEnabled();

    @AboutConfig
    @DefaultBooleanValue(value=false)
    public boolean isFilterRegex();

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isHashCheckEnabled();

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isInterruptResumeableDownloadsEnable();

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isLinkcheckEnabled();

    @AboutConfig
    @DefaultBooleanValue(value=false)
    public boolean isMaxDownloadsPerHostEnabled();

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @Description(value="Use available Accounts?")
    public boolean isUseAvailableAccounts();

    @AboutConfig
    @DefaultBooleanValue(value=false)
    public boolean isUseOriginalLastModified();

    public void setAddNewLinksOnTop(boolean var1);

    public void setAutoaddLinksAfterLinkcheck(boolean var1);

    public void setAutoDownloadStartAfterAddingEnabled(boolean var1);

    public void setAutoOpenContainerAfterDownload(boolean var1);

    public void setAutoReconnectEnabled(boolean var1);

    public void setCleanupAfterDownloadAction(CleanAfterDownloadAction var1);

    public void setCleanUpFilenames(boolean var1);

    @AboutConfig
    public void setDefaultDownloadFolder(String var1);

    public void setDownloadControllerPrefersReconnectEnabled(boolean var1);

    public void setDownloadFolderHistory(ArrayList<String[]> var1);

    public void setDownloadSpeedLimit(int var1);

    public void setDownloadSpeedLimitEnabled(boolean var1);

    public void setFilterRegex(boolean var1);

    public void setFlushBufferLevel(int var1);

    public void setFlushBufferTimeout(int var1);

    public void setForcedFreeSpaceOnDisk(int var1);

    public void setHashCheckEnabled(boolean var1);

    public void setHttpConnectTimeout(int var1);

    public void setHttpReadTimeout(int var1);

    public void setIfFileExistsAction(IfFileExistsAction var1);

    public void setInterruptResumeableDownloadsEnable(boolean var1);

    public void setLinkcheckEnabled(boolean var1);

    public void setMaxBufferSize(int var1);

    public void setMaxChunksPerFile(int var1);

    public void setMaxDownloadsPerHostEnabled(boolean var1);

    public void setMaxPluginRetries(int var1);

    public void setMaxSimultaneDownloads(int var1);

    public void setMaxSimultaneDownloadsPerHost(int var1);

    public void setPauseSpeed(int var1);

    public void setUseAvailableAccounts(boolean var1);

    public void setUseOriginalLastModified(boolean var1);

    public void setWaittimeOnConnectionLoss(int var1);

    @Description(value="Is true, if jdownloader got closed with running downloads.")
    @DefaultBooleanValue(value=false)
    public void setClosedWithRunningDownloads(boolean var1);

    public boolean isClosedWithRunningDownloads();

    @DefaultIntValue(value=10)
    @Description(value="AutoStart Downloads will show a Countdown Dialog after Startup. Set the countdown time to 0 to remove this dialog. @see showCountdownonAutoStartDownloads")
    public int getAutoStartCountdownSeconds();

    public void setAutoStartCountdownSeconds(int var1);

    public void setNetworkIssuesTimeout(int var1);

    @AboutConfig
    @DefaultEnumValue(value="ONLY_IF_EXIT_WITH_RUNNING_DOWNLOADS")
    public void setAutoStartDownloadOption(AutoDownloadStartOption var1);

    public AutoDownloadStartOption getAutoStartDownloadOption();

    @DefaultBooleanValue(value=true)
    @AboutConfig
    @Description(value="@see AutoStartCountdownSeconds")
    public void setShowCountdownonAutoStartDownloads(boolean var1);

    public boolean isShowCountdownonAutoStartDownloads();

    public static class DefaultDownloadFolder
    extends AbstractDefaultFactory<String> {
        @Override
        public String getDefaultValue() {
            File file;
            String string = JDUtilities.getConfiguration().getStringProperty("DOWNLOAD_DIRECTORY", null);
            if (!StringUtils.isEmpty(string) && (file = new File(string)).exists() && file.isDirectory()) {
                return string;
            }
            file = new File(System.getProperty("user.home"));
            if (file.exists() && file.isDirectory()) {
                return new File(file, "downloads").getAbsolutePath();
            }
            return Application.getResource("downloads").getAbsolutePath();
        }
    }
}

