/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.limewire.collection.TrieEdge;
import org.limewire.collection.UnmodifiableIterator;

final class TrieNode<E> {
    private E value = null;
    private ArrayList<TrieEdge<E>> children = new ArrayList(0);

    public TrieNode() {
    }

    public TrieNode(E e) {
        this.value = e;
    }

    public E getValue() {
        return this.value;
    }

    public void setValue(E e) {
        this.value = e;
    }

    private final TrieEdge<E> get(int n) {
        return this.children.get(n);
    }

    private final int search(char c, boolean bl) {
        int n = 0;
        int n2 = this.children.size() - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            char c2 = this.get(n3).getLabelStart();
            if (c2 < c) {
                n = n3 + 1;
                continue;
            }
            if (c < c2) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        if (bl) {
            return -1;
        }
        return n2;
    }

    public TrieEdge<E> get(char c) {
        int n = this.search(c, true);
        if (n < 0) {
            return null;
        }
        TrieEdge<E> trieEdge = this.get(n);
        assert (trieEdge.getLabelStart() == c);
        return trieEdge;
    }

    public void put(String string, TrieNode<E> trieNode) {
        char c = string.charAt(0);
        int n = this.search(c, false);
        if (n >= 0) assert (this.get(n).getLabelStart() != c) : "Precondition of TrieNode.put violated.";
        this.children.add(n + 1, new TrieEdge<E>(string, trieNode));
    }

    public boolean remove(char c) {
        int n = this.search(c, true);
        if (n < 0) {
            return false;
        }
        assert (this.get(n).getLabelStart() == c);
        this.children.remove(n);
        return true;
    }

    public void trim() {
        this.children.trimToSize();
    }

    public Iterator<TrieNode<E>> childrenForward() {
        return new ChildrenForwardIterator();
    }

    public Iterator<String> labelsForward() {
        return new LabelForwardIterator();
    }

    public String toString() {
        E e = this.getValue();
        if (e != null) {
            return e.toString();
        }
        return "NULL";
    }

    private class LabelForwardIterator
    extends UnmodifiableIterator<String> {
        int i = 0;

        private LabelForwardIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < TrieNode.this.children.size();
        }

        @Override
        public String next() {
            if (this.i < TrieNode.this.children.size()) {
                return TrieNode.this.get(this.i++).getLabel();
            }
            throw new NoSuchElementException();
        }
    }

    private class ChildrenForwardIterator
    extends UnmodifiableIterator<TrieNode<E>> {
        int i = 0;

        private ChildrenForwardIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < TrieNode.this.children.size();
        }

        @Override
        public TrieNode<E> next() {
            if (this.i < TrieNode.this.children.size()) {
                return TrieNode.this.get(this.i++).getChild();
            }
            throw new NoSuchElementException();
        }
    }
}

