/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.concurrent;

import org.limewire.service.ErrorService;

public class ManagedThread
extends Thread {
    private static Thread.UncaughtExceptionHandler HANDLER = new ErrorServiceHandler();

    public ManagedThread() {
        this.setPriority(5);
        this.setUncaughtExceptionHandler(HANDLER);
    }

    public ManagedThread(Runnable runnable) {
        super(runnable);
        this.setPriority(5);
        this.setUncaughtExceptionHandler(HANDLER);
    }

    public ManagedThread(String string) {
        super(string);
        this.setPriority(5);
        this.setUncaughtExceptionHandler(HANDLER);
    }

    public ManagedThread(Runnable runnable, String string) {
        super(runnable, string);
        this.setPriority(5);
        this.setUncaughtExceptionHandler(HANDLER);
    }

    private static class ErrorServiceHandler
    implements Thread.UncaughtExceptionHandler {
        private ErrorServiceHandler() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            ErrorService.error(throwable, "Uncaught thread error: " + thread.getName());
        }
    }
}

