/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.limewire.util.FileUtils;
import org.limewire.util.I18NConvert;
import org.limewire.util.OSUtils;

public class CommonUtils {
    public static final String FROSTWIRE_420_PREFS_DIR_NAME = ".frostwire4.20";
    public static final String FROSTWIRE_418_PREFS_DIR_NAME = ".frostwire4.18";
    public static final String FROSTWIRE_500_PREFS_DIR_NAME = ".frostwire5";
    private static final char[] ILLEGAL_CHARS_ANY_OS = new char[]{'/', '\n', '\r', '\t', '\u0000', '\f'};
    private static final char[] ILLEGAL_CHARS_UNIX = new char[]{'`'};
    private static final char[] ILLEGAL_CHARS_WINDOWS = new char[]{'?', '*', '\\', '<', '>', '|', '\"', ':'};
    private static final char[] ILLEGAL_CHARS_MACOS = new char[]{':'};
    private static volatile File settingsDirectory = null;

    public static File getUserHomeDir() {
        return new File(System.getProperty("user.home"));
    }

    public static String getUserName() {
        return System.getProperty("user.name");
    }

    public static InputStream getResourceStream(String string) throws IOException {
        ClassLoader classLoader = CommonUtils.class.getClassLoader();
        URL uRL = null;
        uRL = classLoader == null ? ClassLoader.getSystemResource(string) : classLoader.getResource(string);
        if (uRL == null) {
            throw new IOException("null resource: " + string);
        }
        return uRL.openStream();
    }

    public static String decode(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '+': {
                    stringBuilder.append(' ');
                    continue block8;
                }
                case '%': {
                    try {
                        stringBuilder.append((char)Integer.parseInt(string.substring(i + 1, i + 3), 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException(string);
                    }
                    i += 2;
                    continue block8;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        String string2 = stringBuilder.toString();
        try {
            byte[] byArray = string2.getBytes("8859_1");
            string2 = new String(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string2;
    }

    public static void copyResourceFile(String string, File file, boolean bl) throws IOException {
        ClassLoader classLoader;
        URL uRL;
        if (file == null) {
            file = new File(".", string);
        }
        if (!bl && file.exists()) {
            return;
        }
        String string2 = file.getParent();
        if (string2 == null) {
            return;
        }
        File file2 = new File(string2);
        if (!file2.isDirectory()) {
            file2.mkdirs();
        }
        URL uRL2 = uRL = (classLoader = CommonUtils.class.getClassLoader()) != null ? classLoader.getResource(string) : ClassLoader.getSystemResource(string);
        if (uRL == null) {
            throw new IOException("resource: " + string + " doesn't exist.");
        }
        CommonUtils.saveStream(uRL.openStream(), file);
    }

    public static void copyFile(File file, File file2) throws IOException {
        CommonUtils.saveStream(new FileInputStream(file), file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveStream(InputStream inputStream, File file) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(inputStream, 2048);
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file), 2048);
            byte[] byArray = new byte[2048];
            int n = 0;
            do {
                if ((n = bufferedInputStream.read(byArray, 0, 2048)) <= 0) continue;
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
            } while (n == 2048);
            ((BufferedOutputStream)filterOutputStream).flush();
        }
        catch (IOException iOException) {
            file.delete();
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String getAllStackTraces() {
        try {
            Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
            ArrayList<Map.Entry<Thread, StackTraceElement[]>> arrayList = new ArrayList<Map.Entry<Thread, StackTraceElement[]>>(map.entrySet());
            Collections.sort(arrayList, new Comparator<Map.Entry<Thread, StackTraceElement[]>>(){

                @Override
                public int compare(Map.Entry<Thread, StackTraceElement[]> entry, Map.Entry<Thread, StackTraceElement[]> entry2) {
                    return entry.getKey().getName().compareTo(entry2.getKey().getName());
                }
            });
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry entry : arrayList) {
                Thread thread = (Thread)entry.getKey();
                StackTraceElement[] stackTraceElementArray = (StackTraceElement[])entry.getValue();
                stringBuilder.append(thread.getName()).append("\n");
                for (int i = 0; i < stackTraceElementArray.length; ++i) {
                    stringBuilder.append("    ").append(stackTraceElementArray[i]).append("\n");
                }
                stringBuilder.append("\n");
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.println("An error occured during getting the StackTraces of all active Threads");
            exception.printStackTrace(printWriter);
            printWriter.flush();
            return stringWriter.toString();
        }
    }

    public static String seconds2time(long l) {
        long l2 = l / 60L;
        l -= l2 * 60L;
        long l3 = l2 / 60L;
        l2 -= l3 * 60L;
        long l4 = l3 / 24L;
        l3 -= l4 * 24L;
        StringBuilder stringBuilder = new StringBuilder();
        if (l4 != 0L) {
            stringBuilder.append(Long.toString(l4));
            stringBuilder.append(":");
            if (l3 < 10L) {
                stringBuilder.append("0");
            }
        }
        if (l4 != 0L || l3 != 0L) {
            stringBuilder.append(Long.toString(l3));
            stringBuilder.append(":");
            if (l2 < 10L) {
                stringBuilder.append("0");
            }
        }
        stringBuilder.append(Long.toString(l2));
        stringBuilder.append(":");
        if (l < 10L) {
            stringBuilder.append("0");
        }
        stringBuilder.append(Long.toString(l));
        return stringBuilder.toString();
    }

    public static String convertFileName(File file, String string) throws IOException {
        int n = file.getAbsolutePath().getBytes(Charset.defaultCharset().name()).length;
        if (n >= OSUtils.getMaxPathLength() - 1) {
            throw new IOException("Path too long");
        }
        return CommonUtils.convertFileName(string, Math.min(OSUtils.getMaxPathLength() - n - 1, 180));
    }

    public static String convertFileName(String string) {
        return CommonUtils.convertFileName(string, 180);
    }

    public static String convertFileName(String string, int n) {
        try {
            return CommonUtils.convertFileName(string, n, Charset.defaultCharset());
        }
        catch (CharacterCodingException characterCodingException) {
            try {
                return CommonUtils.convertFileName(string, n, Charset.forName("UTF-8"));
            }
            catch (CharacterCodingException characterCodingException2) {
                throw new RuntimeException("UTF-8 should have encoded: " + string, characterCodingException2);
            }
        }
    }

    public static String convertFileName(String string, int n, Charset charset) throws CharacterCodingException {
        block11: {
            int n2;
            block12: {
                block10: {
                    if (n <= 0) {
                        throw new IllegalArgumentException("maxBytes must be > 0");
                    }
                    string = I18NConvert.instance().compose(string);
                    if (string.length() > n || string.getBytes().length > n) {
                        n2 = string.lastIndexOf(46);
                        if (n2 == -1) {
                            string = CommonUtils.getPrefixWithMaxBytes(string, n, charset);
                        } else {
                            int n3 = string.length() - n2;
                            int n4 = n3 > 11 ? n2 + 11 : string.length();
                            byte[] byArray = CommonUtils.getMaxBytes(string.substring(n2, n4), 16, charset);
                            try {
                                string = byArray.length >= n - 10 ? CommonUtils.getPrefixWithMaxBytes(string, n, charset) : CommonUtils.getPrefixWithMaxBytes(string, n - byArray.length, charset) + new String(byArray, charset.name());
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                throw new RuntimeException("Could not handle string", unsupportedEncodingException);
                            }
                        }
                    }
                    for (n2 = 0; n2 < ILLEGAL_CHARS_ANY_OS.length; ++n2) {
                        string = string.replace(ILLEGAL_CHARS_ANY_OS[n2], '_');
                    }
                    if (!OSUtils.isWindows() && !OSUtils.isOS2()) break block10;
                    for (n2 = 0; n2 < ILLEGAL_CHARS_WINDOWS.length; ++n2) {
                        string = string.replace(ILLEGAL_CHARS_WINDOWS[n2], '_');
                    }
                    break block11;
                }
                if (!OSUtils.isLinux() && !OSUtils.isSolaris()) break block12;
                for (n2 = 0; n2 < ILLEGAL_CHARS_UNIX.length; ++n2) {
                    string = string.replace(ILLEGAL_CHARS_UNIX[n2], '_');
                }
                break block11;
            }
            if (!OSUtils.isMacOSX()) break block11;
            for (n2 = 0; n2 < ILLEGAL_CHARS_MACOS.length; ++n2) {
                string = string.replace(ILLEGAL_CHARS_MACOS[n2], '_');
            }
        }
        return string;
    }

    static String getPrefixWithMaxBytes(String string, int n, Charset charset) throws CharacterCodingException {
        try {
            return new String(CommonUtils.getMaxBytes(string, n, charset), charset.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Could not recreate string", unsupportedEncodingException);
        }
    }

    static byte[] getMaxBytes(String string, int n, Charset charset) throws CharacterCodingException {
        byte[] byArray = new byte[n];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        CharBuffer charBuffer = CharBuffer.wrap(string.toCharArray());
        CharsetEncoder charsetEncoder = charset.newEncoder();
        CoderResult coderResult = charsetEncoder.encode(charBuffer, byteBuffer, true);
        charsetEncoder.flush(byteBuffer);
        if (coderResult.isError()) {
            coderResult.throwException();
        }
        byte[] byArray2 = new byte[byteBuffer.position()];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public static File getCurrentDirectory() {
        return new File(System.getProperty("user.dir"));
    }

    public static String getExecutableDirectory() {
        String string;
        Class<?> clazz = null;
        String string2 = string = "/Applications/FrostWire.app/";
        try {
            String string3;
            clazz = Class.forName("com.limegroup.gnutella.gui.Main");
            if (clazz != null && (string2 = URLDecoder.decode(string3 = clazz.getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8")) != null && string2.toLowerCase().lastIndexOf("frostwire.jar") != -1) {
                string2 = string2.substring(0, string2.toLowerCase().lastIndexOf("frostwire.jar"));
            }
        }
        catch (Throwable throwable) {
            string2 = string;
        }
        return string2;
    }

    public static File validateSettingsDirectory(File file) throws IOException {
        if (!(file = file.getAbsoluteFile()).isDirectory()) {
            file.delete();
            if (!file.mkdirs()) {
                throw new IOException("could not create preferences directory: " + file);
            }
        }
        if (!file.canWrite()) {
            throw new IOException("settings dir not writable: " + file);
        }
        if (!file.canRead()) {
            throw new IOException("settings dir not readable: " + file);
        }
        File file2 = File.createTempFile("test", "test", file);
        if (!file2.exists()) {
            throw new IOException("can't write test file in directory: " + file);
        }
        file2.delete();
        return file;
    }

    public static void setUserSettingsDir(File file) throws IOException {
        if (settingsDirectory != null) {
            throw new IllegalStateException("settings directory already set!");
        }
        settingsDirectory = CommonUtils.validateSettingsDirectory(file);
    }

    public static synchronized File getUserSettingsDir() {
        if (settingsDirectory != null) {
            return settingsDirectory;
        }
        return CommonUtils.getUserSettingsDir2();
    }

    private static File getUserSettingsDir2() {
        File file = CommonUtils.getUserHomeDir();
        if (!OSUtils.isPOSIX() && file != null && file.exists()) {
            FileUtils.setWriteable(file);
        }
        File file2 = new File(file, FROSTWIRE_500_PREFS_DIR_NAME);
        if (OSUtils.isMacOSX()) {
            file2 = new File(CommonUtils.getUserHomeDir(), "Library/Preferences/FrostWire5");
        }
        return file2;
    }

    public static File getFrostWire4UserSettingsDir() {
        File file = CommonUtils.getUserHomeDir();
        File file2 = new File(file, FROSTWIRE_420_PREFS_DIR_NAME);
        if (OSUtils.isMacOSX()) {
            file2 = new File(CommonUtils.getUserHomeDir(), "Library/Preferences/FrostWire");
        }
        return file2;
    }

    public static boolean isDebugMode() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
    }
}

