/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.lang.reflect.UndeclaredThrowableException;

public class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static void rethrow(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new UndeclaredThrowableException(throwable);
    }

    public static Throwable reportOrReturn(Throwable throwable) {
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.currentThread().getUncaughtExceptionHandler();
        if (uncaughtExceptionHandler == null) {
            uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        }
        if (uncaughtExceptionHandler != null) {
            uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), throwable);
            return null;
        }
        return throwable;
    }

    public static void reportOrRethrow(Throwable throwable) {
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.currentThread().getUncaughtExceptionHandler();
        if (uncaughtExceptionHandler == null) {
            uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        }
        if (uncaughtExceptionHandler != null) {
            uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), throwable);
        } else {
            ExceptionUtils.rethrow(throwable);
        }
    }
}

