/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.util.Utils;
import org.jaudiotagger.logging.ErrorMessage;

public enum ContainerType {
    CONTENT_BRANDING(GUID.GUID_CONTENT_BRANDING, 32, false, false, false, false),
    CONTENT_DESCRIPTION(GUID.GUID_CONTENTDESCRIPTION, 16, false, false, false, false),
    EXTENDED_CONTENT(GUID.GUID_EXTENDED_CONTENT_DESCRIPTION, 16, false, false, false, false),
    METADATA_LIBRARY_OBJECT(GUID.GUID_METADATA_LIBRARY, 32, true, true, true, true),
    METADATA_OBJECT(GUID.GUID_METADATA, 16, false, true, false, true);

    private final GUID containerGUID;
    private final boolean guidEnabled;
    private final boolean languageEnabled;
    private final BigInteger maximumDataLength;
    private final boolean multiValued;
    private final long perfMaxDataLen;
    private final boolean streamEnabled;

    public static boolean areInCorrectOrder(ContainerType containerType, ContainerType containerType2) {
        List<ContainerType> list = Arrays.asList(ContainerType.getOrdered());
        return list.indexOf((Object)containerType) <= list.indexOf((Object)containerType2);
    }

    public static ContainerType[] getOrdered() {
        return new ContainerType[]{CONTENT_DESCRIPTION, CONTENT_BRANDING, EXTENDED_CONTENT, METADATA_OBJECT, METADATA_LIBRARY_OBJECT};
    }

    private ContainerType(GUID gUID, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.containerGUID = gUID;
        this.maximumDataLength = BigInteger.valueOf(2L).pow(n2).subtract(BigInteger.ONE);
        this.perfMaxDataLen = this.maximumDataLength.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) <= 0 ? this.maximumDataLength.longValue() : -1L;
        this.guidEnabled = bl;
        this.streamEnabled = bl2;
        this.languageEnabled = bl3;
        this.multiValued = bl4;
    }

    public void assertConstraints(String string, byte[] byArray, int n, int n2, int n3) {
        RuntimeException runtimeException = this.checkConstraints(string, byArray, n, n2, n3);
        if (runtimeException != null) {
            throw runtimeException;
        }
    }

    public RuntimeException checkConstraints(String string, byte[] byArray, int n, int n2, int n3) {
        String string2;
        IllegalArgumentException illegalArgumentException = null;
        if (string == null || byArray == null) {
            illegalArgumentException = new IllegalArgumentException("Arguments must not be null.");
        } else if (!Utils.isStringLengthValidNullSafe(string)) {
            illegalArgumentException = new IllegalArgumentException(ErrorMessage.WMA_LENGTH_OF_STRING_IS_TOO_LARGE.getMsg(string.length()));
        }
        if (illegalArgumentException == null && !this.isWithinValueRange(byArray.length)) {
            illegalArgumentException = new IllegalArgumentException(ErrorMessage.WMA_LENGTH_OF_DATA_IS_TOO_LARGE.getMsg(byArray.length, this.getMaximumDataLength(), this.getContainerGUID().getDescription()));
        }
        if (illegalArgumentException == null && (n2 < 0 || n2 > 127 || !this.isStreamNumberEnabled() && n2 != 0)) {
            string2 = this.isStreamNumberEnabled() ? "0 to 127" : "0";
            illegalArgumentException = new IllegalArgumentException(ErrorMessage.WMA_INVALID_STREAM_REFERNCE.getMsg(n2, string2, this.getContainerGUID().getDescription()));
        }
        if (illegalArgumentException == null && n == 6 && !this.isGuidEnabled()) {
            illegalArgumentException = new IllegalArgumentException(ErrorMessage.WMA_INVALID_GUID_USE.getMsg(this.getContainerGUID().getDescription()));
        }
        if (illegalArgumentException == null && (n3 != 0 && !this.isLanguageEnabled() || n3 < 0 || n3 >= 127)) {
            string2 = this.isStreamNumberEnabled() ? "0 to 126" : "0";
            illegalArgumentException = new IllegalArgumentException(ErrorMessage.WMA_INVALID_LANGUAGE_USE.getMsg(n3, this.getContainerGUID().getDescription(), string2));
        }
        if (illegalArgumentException == null && this == CONTENT_DESCRIPTION && n != 0) {
            illegalArgumentException = new IllegalArgumentException(ErrorMessage.WMA_ONLY_STRING_IN_CD.getMsg());
        }
        return illegalArgumentException;
    }

    public GUID getContainerGUID() {
        return this.containerGUID;
    }

    public BigInteger getMaximumDataLength() {
        return this.maximumDataLength;
    }

    public boolean isGuidEnabled() {
        return this.guidEnabled;
    }

    public boolean isLanguageEnabled() {
        return this.languageEnabled;
    }

    public boolean isWithinValueRange(long l) {
        return (this.perfMaxDataLen == -1L || this.perfMaxDataLen >= l) && l >= 0L;
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public boolean isStreamNumberEnabled() {
        return this.streamEnabled;
    }
}

