/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import org.jaudiotagger.audio.asf.data.ContainerType;
import org.jaudiotagger.audio.asf.data.MetadataContainer;
import org.jaudiotagger.audio.asf.data.MetadataDescriptor;
import org.jaudiotagger.audio.asf.util.Utils;

public final class ContentBranding
extends MetadataContainer {
    public static final Set<String> ALLOWED = new HashSet<String>();
    public static final String KEY_BANNER_IMAGE = "BANNER_IMAGE";
    public static final String KEY_BANNER_TYPE = "BANNER_IMAGE_TYPE";
    public static final String KEY_BANNER_URL = "BANNER_IMAGE_URL";
    public static final String KEY_COPYRIGHT_URL = "COPYRIGHT_URL";

    public ContentBranding() {
        this(0L, BigInteger.ZERO);
    }

    public ContentBranding(long l, BigInteger bigInteger) {
        super(ContainerType.CONTENT_BRANDING, l, bigInteger);
    }

    public String getBannerImageURL() {
        return this.getValueFor(KEY_BANNER_URL);
    }

    public String getCopyRightURL() {
        return this.getValueFor(KEY_COPYRIGHT_URL);
    }

    @Override
    public long getCurrentAsfChunkSize() {
        long l = 40L;
        l += (long)this.assertDescriptor(KEY_BANNER_IMAGE, 1).getRawDataSize();
        l += (long)this.getBannerImageURL().length();
        return l += (long)this.getCopyRightURL().length();
    }

    public byte[] getImageData() {
        return this.assertDescriptor(KEY_BANNER_IMAGE, 1).getRawData();
    }

    public long getImageType() {
        if (!this.hasDescriptor(KEY_BANNER_TYPE)) {
            MetadataDescriptor metadataDescriptor = new MetadataDescriptor(ContainerType.CONTENT_BRANDING, KEY_BANNER_TYPE, 3);
            metadataDescriptor.setDWordValue(0L);
            this.addDescriptor(metadataDescriptor);
        }
        return this.assertDescriptor(KEY_BANNER_TYPE).getNumber();
    }

    @Override
    public boolean isAddSupported(MetadataDescriptor metadataDescriptor) {
        return ALLOWED.contains(metadataDescriptor.getName()) && super.isAddSupported(metadataDescriptor);
    }

    public void setBannerImageURL(String string) {
        if (Utils.isBlank(string)) {
            this.removeDescriptorsByName(KEY_BANNER_URL);
        } else {
            this.assertDescriptor(KEY_BANNER_URL).setStringValue(string);
        }
    }

    public void setCopyRightURL(String string) {
        if (Utils.isBlank(string)) {
            this.removeDescriptorsByName(KEY_COPYRIGHT_URL);
        } else {
            this.assertDescriptor(KEY_COPYRIGHT_URL).setStringValue(string);
        }
    }

    public void setImage(long l, byte[] byArray) {
        assert (l >= 0L && l <= 3L);
        assert (l > 0L || byArray.length == 0);
        this.assertDescriptor(KEY_BANNER_TYPE, 3).setDWordValue(l);
        this.assertDescriptor(KEY_BANNER_IMAGE, 1).setBinaryValue(byArray);
    }

    @Override
    public long writeInto(OutputStream outputStream) throws IOException {
        long l = this.getCurrentAsfChunkSize();
        outputStream.write(this.getGuid().getBytes());
        Utils.writeUINT64(l, outputStream);
        Utils.writeUINT32(this.getImageType(), outputStream);
        assert (this.getImageType() >= 0L && this.getImageType() <= 3L);
        byte[] byArray = this.getImageData();
        assert (this.getImageType() > 0L || byArray.length == 0);
        Utils.writeUINT32(byArray.length, outputStream);
        outputStream.write(byArray);
        Utils.writeUINT32(this.getBannerImageURL().length(), outputStream);
        outputStream.write(this.getBannerImageURL().getBytes("ASCII"));
        Utils.writeUINT32(this.getCopyRightURL().length(), outputStream);
        outputStream.write(this.getCopyRightURL().getBytes("ASCII"));
        return l;
    }

    static {
        ALLOWED.add(KEY_BANNER_IMAGE);
        ALLOWED.add(KEY_BANNER_TYPE);
        ALLOWED.add(KEY_BANNER_URL);
        ALLOWED.add(KEY_COPYRIGHT_URL);
    }
}

