/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.util.Utils;
import org.jaudiotagger.logging.ErrorMessage;

public class LanguageList
extends Chunk {
    private final List<String> languages = new ArrayList<String>();

    public LanguageList() {
        super(GUID.GUID_LANGUAGE_LIST, 0L, BigInteger.ZERO);
    }

    public LanguageList(long l, BigInteger bigInteger) {
        super(GUID.GUID_LANGUAGE_LIST, l, bigInteger);
    }

    public void addLanguage(String string) {
        if (string.length() < 127) {
            if (!this.languages.contains(string)) {
                this.languages.add(string);
            }
        } else {
            throw new IllegalArgumentException(ErrorMessage.WMA_LENGTH_OF_LANGUAGE_IS_TOO_LARGE.getMsg(string.length() * 2 + 2));
        }
    }

    public String getLanguage(int n) {
        return this.languages.get(n);
    }

    public int getLanguageCount() {
        return this.languages.size();
    }

    public List<String> getLanguages() {
        return new ArrayList<String>(this.languages);
    }

    @Override
    public String prettyPrint(String string) {
        StringBuilder stringBuilder = new StringBuilder(super.prettyPrint(string));
        for (int i = 0; i < this.getLanguageCount(); ++i) {
            stringBuilder.append(string);
            stringBuilder.append("  |-> ");
            stringBuilder.append(i);
            stringBuilder.append(" : ");
            stringBuilder.append(this.getLanguage(i));
            stringBuilder.append(Utils.LINE_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    public void removeLanguage(int n) {
        this.languages.remove(n);
    }
}

