/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.ContainerType;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.data.MetadataDescriptor;
import org.jaudiotagger.audio.asf.io.WriteableChunk;
import org.jaudiotagger.audio.asf.util.Utils;

public class MetadataContainer
extends Chunk
implements WriteableChunk {
    private final ContainerType containerType;
    private final Map<DescriptorPointer, List<MetadataDescriptor>> descriptors = new Hashtable<DescriptorPointer, List<MetadataDescriptor>>();
    private final DescriptorPointer perfPoint = new DescriptorPointer(new MetadataDescriptor(""));

    private static ContainerType determineType(GUID gUID) throws IllegalArgumentException {
        assert (gUID != null);
        ContainerType containerType = null;
        for (ContainerType containerType2 : ContainerType.values()) {
            if (!containerType2.getContainerGUID().equals(gUID)) continue;
            containerType = containerType2;
            break;
        }
        if (containerType == null) {
            throw new IllegalArgumentException("Unknown metadata container specified by GUID (" + gUID.toString() + ")");
        }
        return containerType;
    }

    public MetadataContainer(ContainerType containerType) {
        this(containerType, 0L, BigInteger.ZERO);
    }

    public MetadataContainer(ContainerType containerType, long l, BigInteger bigInteger) {
        super(containerType.getContainerGUID(), l, bigInteger);
        this.containerType = containerType;
    }

    public MetadataContainer(GUID gUID, long l, BigInteger bigInteger) {
        this(MetadataContainer.determineType(gUID), l, bigInteger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addDescriptor(MetadataDescriptor metadataDescriptor) throws IllegalArgumentException {
        List<MetadataDescriptor> list;
        this.containerType.assertConstraints(metadataDescriptor.getName(), metadataDescriptor.getRawData(), metadataDescriptor.getType(), metadataDescriptor.getStreamNumber(), metadataDescriptor.getLanguageIndex());
        if (!this.isAddSupported(metadataDescriptor)) {
            throw new IllegalArgumentException("Descriptor cannot be added, see isAddSupported(...)");
        }
        DescriptorPointer descriptorPointer = this.perfPoint;
        synchronized (descriptorPointer) {
            list = this.descriptors.get(this.perfPoint.setDescriptor(metadataDescriptor));
        }
        if (list == null) {
            list = new ArrayList<MetadataDescriptor>();
            this.descriptors.put(new DescriptorPointer(metadataDescriptor), list);
        } else if (!list.isEmpty() && !this.containerType.isMultiValued()) {
            throw new IllegalArgumentException("Container does not allow multiple values of descriptors with same name, language index and stream number");
        }
        list.add(metadataDescriptor);
    }

    protected final MetadataDescriptor assertDescriptor(String string) {
        return this.assertDescriptor(string, 0);
    }

    protected final MetadataDescriptor assertDescriptor(String string, int n) {
        MetadataDescriptor metadataDescriptor;
        List<MetadataDescriptor> list = this.getDescriptorsByName(string);
        if (list == null || list.isEmpty()) {
            metadataDescriptor = new MetadataDescriptor(this.getContainerType(), string, n);
            this.addDescriptor(metadataDescriptor);
        } else {
            metadataDescriptor = list.get(0);
        }
        return metadataDescriptor;
    }

    public final boolean containsDescriptor(MetadataDescriptor metadataDescriptor) {
        assert (metadataDescriptor != null);
        return this.descriptors.containsKey(this.perfPoint.setDescriptor(metadataDescriptor));
    }

    public final ContainerType getContainerType() {
        return this.containerType;
    }

    @Override
    public long getCurrentAsfChunkSize() {
        long l = 26L;
        for (MetadataDescriptor metadataDescriptor : this.getDescriptors()) {
            l += (long)metadataDescriptor.getCurrentAsfSize(this.containerType);
        }
        return l;
    }

    public final int getDescriptorCount() {
        return this.getDescriptors().size();
    }

    public final List<MetadataDescriptor> getDescriptors() {
        ArrayList<MetadataDescriptor> arrayList = new ArrayList<MetadataDescriptor>();
        for (List<MetadataDescriptor> list : this.descriptors.values()) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public final List<MetadataDescriptor> getDescriptorsByName(String string) {
        assert (string != null);
        ArrayList<MetadataDescriptor> arrayList = new ArrayList<MetadataDescriptor>();
        Collection<List<MetadataDescriptor>> collection = this.descriptors.values();
        for (List<MetadataDescriptor> list : collection) {
            if (list.isEmpty() || !list.get(0).getName().equals(string)) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }

    protected final String getValueFor(String string) {
        String string2 = "";
        List<MetadataDescriptor> list = this.getDescriptorsByName(string);
        if (list != null) {
            assert (list.size() <= 1);
            if (!list.isEmpty()) {
                string2 = list.get(0).getString();
            }
        }
        return string2;
    }

    public final boolean hasDescriptor(String string) {
        return !this.getDescriptorsByName(string).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAddSupported(MetadataDescriptor metadataDescriptor) {
        boolean bl;
        boolean bl2 = bl = this.getContainerType().checkConstraints(metadataDescriptor.getName(), metadataDescriptor.getRawData(), metadataDescriptor.getType(), metadataDescriptor.getStreamNumber(), metadataDescriptor.getLanguageIndex()) == null;
        if (bl && !this.getContainerType().isMultiValued()) {
            DescriptorPointer descriptorPointer = this.perfPoint;
            synchronized (descriptorPointer) {
                List<MetadataDescriptor> list = this.descriptors.get(this.perfPoint.setDescriptor(metadataDescriptor));
                if (list != null) {
                    bl = list.isEmpty();
                }
            }
        }
        return bl;
    }

    @Override
    public final boolean isEmpty() {
        boolean bl;
        if (this.getDescriptorCount() != 0) {
            Iterator<MetadataDescriptor> iterator = this.getDescriptors().iterator();
            for (bl = true; bl && iterator.hasNext(); bl &= iterator.next().isEmpty()) {
            }
        }
        return bl;
    }

    @Override
    public String prettyPrint(String string) {
        StringBuilder stringBuilder = new StringBuilder(super.prettyPrint(string));
        for (MetadataDescriptor metadataDescriptor : this.getDescriptors()) {
            stringBuilder.append(string).append("  |-> ");
            stringBuilder.append(metadataDescriptor);
            stringBuilder.append(Utils.LINE_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    public final void removeDescriptorsByName(String string) {
        assert (string != null);
        Iterator<List<MetadataDescriptor>> iterator = this.descriptors.values().iterator();
        while (iterator.hasNext()) {
            List<MetadataDescriptor> list = iterator.next();
            if (list.isEmpty() || !list.get(0).getName().equals(string)) continue;
            iterator.remove();
        }
    }

    protected final void setStringValue(String string, String string2) {
        this.assertDescriptor(string).setStringValue(string2);
    }

    @Override
    public long writeInto(OutputStream outputStream) throws IOException {
        long l = this.getCurrentAsfChunkSize();
        List<MetadataDescriptor> list = this.getDescriptors();
        outputStream.write(this.getGuid().getBytes());
        Utils.writeUINT64(l, outputStream);
        Utils.writeUINT16(list.size(), outputStream);
        for (MetadataDescriptor metadataDescriptor : list) {
            metadataDescriptor.writeInto(outputStream, this.containerType);
        }
        return l;
    }

    private static final class DescriptorPointer {
        private MetadataDescriptor desc;

        public DescriptorPointer(MetadataDescriptor metadataDescriptor) {
            this.setDescriptor(metadataDescriptor);
        }

        public boolean equals(Object object) {
            boolean bl;
            boolean bl2 = bl = object == this;
            if (object instanceof DescriptorPointer && !bl) {
                MetadataDescriptor metadataDescriptor = ((DescriptorPointer)object).desc;
                bl = this.desc.getName().equals(metadataDescriptor.getName());
                bl &= this.desc.getLanguageIndex() == metadataDescriptor.getLanguageIndex();
                bl &= this.desc.getStreamNumber() == metadataDescriptor.getStreamNumber();
            }
            return bl;
        }

        public int hashCode() {
            int n = this.desc.getName().hashCode();
            n = n * 31 + this.desc.getLanguageIndex();
            n = n * 31 + this.desc.getStreamNumber();
            return n;
        }

        protected DescriptorPointer setDescriptor(MetadataDescriptor metadataDescriptor) {
            assert (metadataDescriptor != null);
            this.desc = metadataDescriptor;
            return this;
        }
    }
}

