/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.data.StreamChunk;
import org.jaudiotagger.audio.asf.util.Utils;

public class VideoStreamChunk
extends StreamChunk {
    private byte[] codecId = new byte[0];
    private long pictureHeight;
    private long pictureWidth;

    public VideoStreamChunk(BigInteger bigInteger) {
        super(GUID.GUID_VIDEOSTREAM, bigInteger);
    }

    public byte[] getCodecId() {
        return (byte[])this.codecId.clone();
    }

    public String getCodecIdAsString() {
        String string = this.codecId == null ? "Unknown" : new String(this.getCodecId());
        return string;
    }

    public long getPictureHeight() {
        return this.pictureHeight;
    }

    public long getPictureWidth() {
        return this.pictureWidth;
    }

    @Override
    public String prettyPrint(String string) {
        StringBuilder stringBuilder = new StringBuilder(super.prettyPrint(string));
        stringBuilder.insert(0, Utils.LINE_SEPARATOR + string + "|->VideoStream");
        stringBuilder.append(string).append("Video info:").append(Utils.LINE_SEPARATOR);
        stringBuilder.append(string).append("      |->Width  : ").append(this.getPictureWidth()).append(Utils.LINE_SEPARATOR);
        stringBuilder.append(string).append("      |->Heigth : ").append(this.getPictureHeight()).append(Utils.LINE_SEPARATOR);
        stringBuilder.append(string).append("      |->Codec  : ").append(this.getCodecIdAsString()).append(Utils.LINE_SEPARATOR);
        return stringBuilder.toString();
    }

    public void setCodecId(byte[] byArray) {
        this.codecId = (byte[])byArray.clone();
    }

    public void setPictureHeight(long l) {
        this.pictureHeight = l;
    }

    public void setPictureWidth(long l) {
        this.pictureWidth = l;
    }
}

