/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.ContentBranding;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.io.ChunkReader;
import org.jaudiotagger.audio.asf.util.Utils;

public class ContentBrandingReader
implements ChunkReader {
    private static final GUID[] APPLYING = new GUID[]{GUID.GUID_CONTENT_BRANDING};

    protected ContentBrandingReader() {
    }

    @Override
    public boolean canFail() {
        return false;
    }

    @Override
    public GUID[] getApplyingIds() {
        return (GUID[])APPLYING.clone();
    }

    @Override
    public Chunk read(GUID gUID, InputStream inputStream, long l) throws IOException {
        assert (GUID.GUID_CONTENT_BRANDING.equals(gUID));
        BigInteger bigInteger = Utils.readBig64(inputStream);
        long l2 = Utils.readUINT32(inputStream);
        assert (l2 >= 0L && l2 <= 3L) : l2;
        long l3 = Utils.readUINT32(inputStream);
        assert (l2 > 0L || l3 == 0L) : l3;
        assert (l3 < Integer.MAX_VALUE);
        byte[] byArray = Utils.readBinary(inputStream, l3);
        long l4 = Utils.readUINT32(inputStream);
        String string = new String(Utils.readBinary(inputStream, l4));
        long l5 = Utils.readUINT32(inputStream);
        String string2 = new String(Utils.readBinary(inputStream, l5));
        ContentBranding contentBranding = new ContentBranding(l, bigInteger);
        contentBranding.setImage(l2, byArray);
        contentBranding.setCopyRightURL(string);
        contentBranding.setBannerImageURL(string2);
        return contentBranding;
    }
}

